/*
Functions for local users UI and table
*/

function alertListError()
{
    if( 0 == pageNav )
    {
        pageIndex++;
    }
    else
    {
        pageIndex--;
    }
    alertNoMoreRecord();
}


getLocalUserListResp=function(data) {
    $("#dataRecords").empty();
    $.each(data, function(index, ev) {
        $("#dataRecords").append("<tr id='"+ev.usrname+"'></tr>");
        $("#"+ev.usrname).append("<td>"+ev.usrname+"</td>");
        
        switch(ev.state)
        {
            case 1:
                $("#"+ev.usrname).append("<td>"+"<img src='../img/idle_user.png' />"+"</td>");
                break;
            
            case 2:
                $("#"+ev.usrname).append("<td>"+"<img src='../img/alert_user.png' />"+"</td>");
                break;
                
            case 3:
                $("#"+ev.usrname).append("<td>"+"<img src='../img/talk_user.png' />"+"</td>");
                break;

            default:
                $("#"+ev.usrname).append("<td>"+"<img src='../img/offline_user.png' />"+"</td>");
                break;
        }
        $("#"+ev.usrname).append("<td>"+ev.description+"</td>");
        $("#"+ev.usrname).append("<td>"+ev.dispname+"</td>");
        $("#"+ev.usrname).append("<td>"+ev.addr+"</td>");
        $("#"+ev.usrname).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editLocalUser(\""+ev.usrname+"\")' />"
                                    +"<img src='../img/del.png' alt='delete a record' onclick='delLocalUser(\""+ev.usrname+"\")' /></td>");
                      
    });
    
};

getLocalUserList=function(currIndex) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("pageIndex", currIndex);    
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/localuser/list",
        type: "get",
        dataType: "json",
        data:      {content:jsonStr},
        success: getLocalUserListResp,
        
        error: function(ev) {
            alertListError();
        }
    });
};

delLocalUser=function(usr_name) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("usrname", usr_name);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/localuser/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {           
            $('#'+usr_name).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

getLocalUserDetailResp=function(data) {
    $.each(data, function(index, ev) {
        $("#edtUsrPwd").val(ev.usrpwd);
        $("#edtDesc").val(ev.description);
        $("#edtIPAddr").val(ev.addr);
        $("#edtIPPort").val(ev.port);
        $("#edtDispName").val(ev.dispname);
        $("#edtEmailAddr").val(ev.email);
        
        $("#edtCFU").val(ev.cfunbr);
        $("#edtCFNC").val(ev.cfncnbr);
        $("#edtCFB").val(ev.cfbnbr);
        $("#edtCFNA").val(ev.cfnanbr);
        $("#edtCFNATmr").val(ev.cfnatmr);
        $("#edtVMSVoiceID").val(ev.vmannid.toString(16));
        
        $("#edtRGID").val(ev.ringgrpid);
        $("#edtPickUPID").val(ev.pickupgrpid);
        
        switch( ev.fmtype )
        {
            case 1:
                setInputChecked("optFmSameTime");                
                break;
            
            case 2:
                setInputChecked("optFmNoAns");   
                break;
            
            case 3:
                setInputChecked("optFmInterval");  
                break;
            
            default:
                break;
        }
        $("#edtFMInterval").val(ev.fminterval);
        $("#edtFMDestA").val(ev.fmdesta);
        $("#edtFMDestB").val(ev.fmdestb);
        $("#edtFMDestC").val(ev.fmdestc);
        
        $("#edtPresenceID").val(ev.presgrpid);
        
        var callLevel = ev.calllevel;
        
        var tmpVal = callLevel&(0x01<<1 );
        setInputCheckAttr("chkCallLevel1", tmpVal);

        tmpVal = callLevel&(0x01<<2 );
        setInputCheckAttr("chkCallLevel2", tmpVal);

        tmpVal = callLevel&(0x01<<3);
        setInputCheckAttr("chkCallLevel3", tmpVal);

        tmpVal = callLevel&(0x01<<4);
        setInputCheckAttr("chkCallLevel4", tmpVal);

        tmpVal = callLevel&(0x01<<5);
        setInputCheckAttr("chkCallLevel5", tmpVal);

        tmpVal = callLevel&(0x01<<6);
        setInputCheckAttr("chkCallLevel6", tmpVal);

        $("#edtDialPlan").val(ev.dialPlan);
        $("#edtExtLine").val(ev.specextline);
        $("#edtMaxDuration").val(ev.maxdura);
        $("#momaxcall").val(ev.momaxcall);
        $("#edtEndDate").val(ev.enddate);
        $("#edtTCID").val(ev.tcID);
        
        setInputCheckAttr("chkCFU", ev.right_cfu);
        setInputCheckAttr("chkCFNR", ev.right_cfnc);
        setInputCheckAttr("chkCFB", ev.right_cfb);
        setInputCheckAttr("chkCFNA", ev.right_cfna);
        setInputCheckAttr("chkVMS", ev.right_vms);
        setInputCheckAttr("chkAA", ev.right_aa);
        setInputCheckAttr("chkRG", ev.right_rg);
        setInputCheckAttr("chkSuppressRG", ev.right_sup_rg);
        setInputCheckAttr("chkPickUP", ev.right_pickup);
        setInputCheckAttr("chkCallPark", ev.right_park);
        setInputCheckAttr("chkCallRetrieve", ev.right_retrieve);
        setInputCheckAttr("chkCallerPrepaid", ev.right_prepaid);
        setInputCheckAttr("chkCallShop", ev.right_callshop);
        setInputCheckAttr("chkCallerID", ev.right_clrid);
        setInputCheckAttr("chkSubscribe", ev.right_subpre);
        setInputCheckAttr("chkMOH", ev.right_moh);
        setInputCheckAttr("chkRelay", ev.right_relay);
        setInputCheckAttr("chkOLI", ev.right_oli);
        setInputCheckAttr("chkTLI", ev.right_tli);
        setInputCheckAttr("chkCW", ev.right_cw);
        setInputCheckAttr("chkIPAuth", ev.right_ipauth);
        
        updateUI();
    });    
};

getLocalUserDetail=function(usr_name) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("usrname", usr_name);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/localuser/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getLocalUserDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

checkParamsValid=function() {
    if( $("#edtUsrName").val() == null )
    {
        return "Invalid user name";
    }
    
    return "ok"
};

updateLocalUserDetail=function() {
    var checkResult = checkParamsValid();
    if( "ok" != checkResult )
    {
        alert(checkResult);
        return;
    }
    
    var usrInfoJson = "{";
    
    usrInfoJson += jsonEncodeString("usrname", $("#edtUsrName").val())+",";     
    usrInfoJson += jsonEncodeString("usrpwd", $("#edtUsrPwd").val())+",";  
    usrInfoJson += jsonEncodeString("description", $("#edtDesc").val())+",";  
    usrInfoJson += jsonEncodeString("addr", $("#edtIPAddr").val())+",";
    usrInfoJson += jsonEncodeNumber("port",$("#edtIPPort").val())+",";
    usrInfoJson += jsonEncodeString("dispname", $("#edtDispName").val())+","; 
    usrInfoJson += jsonEncodeString("email", $("#edtEmailAddr").val())+",";

    usrInfoJson += jsonEncodeString("cfunbr", $("#edtCFU").val())+",";
    usrInfoJson += jsonEncodeString("cfncnbr", $("#edtCFNC").val())+",";
    usrInfoJson += jsonEncodeString("cfbnbr", $("#edtCFB").val())+",";
    usrInfoJson += jsonEncodeString("cfnanbr", $("#edtCFNA").val())+",";
    if( true == editBoxHasValue("edtCFNATmr") )
    {
        usrInfoJson += jsonEncodeNumber("cfnatmr",$("#edtCFNATmr").val())+",";
    }
    
    if( true == editBoxHasValue("edtVMSVoiceID") )
    {
        usrInfoJson += jsonEncodeString("vmannid", $("#edtVMSVoiceID").val())+",";
    }
        
    usrInfoJson += jsonEncodeNumber("ringgrpid",$("#edtRGID").val())+",";
    usrInfoJson += jsonEncodeNumber("pickupgrpid",$("#edtPickUPID").val())+",";
    
    if( inputHasChecked("optFmSameTime") )
    {
        usrInfoJson += jsonEncodeNumber("fmtype",1)+",";
    }
    else if( inputHasChecked("optFmNoAns") )
    {
        usrInfoJson += jsonEncodeNumber("fmtype",2)+",";
    }
    else
    {
        usrInfoJson += jsonEncodeNumber("fmtype",3)+",";
    }
    
    if( true == editBoxHasValue("edtFMInterval") )
    {
        usrInfoJson += jsonEncodeNumber("fminterval",$("#edtFMInterval").val())+",";
    }
    
    usrInfoJson += jsonEncodeString("fmdesta", $("#edtFMDestA").val())+",";
    usrInfoJson += jsonEncodeString("fmdestb", $("#edtFMDestB").val())+",";
    usrInfoJson += jsonEncodeString("fmdestc", $("#edtFMDestC").val())+",";
    
    if( true == editBoxHasValue("edtPresenceID") )
    {
        usrInfoJson += jsonEncodeNumber("presgrpid",$("#edtPresenceID").val())+",";
    }
    
    var callLevel=0;    
    if( inputHasChecked("chkCallLevel1") )
    {
        callLevel += 0x01<<1;
    }
    if( inputHasChecked("chkCallLevel2") )
    {
        callLevel += 0x01<<2;
    }
    if( inputHasChecked("chkCallLevel3") )
    {
        callLevel += 0x01<<3;
    }
    if( inputHasChecked("chkCallLevel4") )
    {
        callLevel += 0x01<<4;
    }
    if( inputHasChecked("chkCallLevel5") )
    {
        callLevel += 0x01<<5;
    }
    if( inputHasChecked("chkCallLevel6") )
    {
        callLevel += 0x01<<6;
    }
    if( 0 < callLevel )
    {
        usrInfoJson += jsonEncodeNumber("calllevel", callLevel)+",";
    }
    
    usrInfoJson += jsonEncodeString("dialplan", $("#edtDialPlan").val())+",";
    
    usrInfoJson += jsonEncodeString("specextline", $("#edtExtLine").val())+",";
    
    usrInfoJson += jsonEncodeNumber("maxdura", $("#edtMaxDuration").val())+",";
    
    usrInfoJson += jsonEncodeNumber("momaxcall", $("#momaxcall").val())+",";
    
    usrInfoJson += jsonEncodeNumber("enddate", $("#edtEndDate").val())+",";
    
    usrInfoJson += jsonEncodeNumber("tcID", $("#edtTCID").val())+",";
    
    // service rights 
    if( inputHasChecked("chkCFU") )
    {
        usrInfoJson += jsonEncodeNumber("right_cfu", 1)+",";
    }
    if( inputHasChecked("chkCFNR") )
    {
        usrInfoJson += jsonEncodeNumber("right_cfnc", 1)+",";
    }
    if( inputHasChecked("chkCFB") )
    {
        usrInfoJson += jsonEncodeNumber("right_cfb", 1)+",";
    }
    if( inputHasChecked("chkCFNA") )
    {
        usrInfoJson += jsonEncodeNumber("right_cfna", 1)+",";
    }
    if( inputHasChecked("chkVMS") )
    {
        usrInfoJson += jsonEncodeNumber("right_vms", 1)+",";
    }
    if( inputHasChecked("chkAA") )
    {
        usrInfoJson += jsonEncodeNumber("right_aa", 1)+",";
    }
   
    if( inputHasChecked("chkRG") )
    {
        usrInfoJson += jsonEncodeNumber("right_rg", 1)+",";
    }
    if( inputHasChecked("chkSuppressRG") )
    {
        usrInfoJson += jsonEncodeNumber("right_sup_rg", 1)+",";
    }
    if( inputHasChecked("chkPickUP") )
    {
        usrInfoJson += jsonEncodeNumber("right_pickup", 1)+",";
    }
    if( inputHasChecked("chkCallPark") )
    {
        usrInfoJson += jsonEncodeNumber("right_park", 1)+",";
    }
    if( inputHasChecked("chkCallRetrieve") )
    {
        usrInfoJson += jsonEncodeNumber("right_retrieve", 1)+",";
    }
    if( inputHasChecked("chkCallerPrepaid") )
    {
        usrInfoJson += jsonEncodeNumber("right_prepaid", 1)+",";
    }
    if( inputHasChecked("chkCallShop") )
    {
        usrInfoJson += jsonEncodeNumber("right_callshop", 1)+",";
    }
    if( inputHasChecked("chkCallerID") )
    {
        usrInfoJson += jsonEncodeNumber("right_clrid", 1)+",";
    }
    if( inputHasChecked("chkSubscribe") )
    {
        usrInfoJson += jsonEncodeNumber("right_subpre", 1)+",";
    }
    if( inputHasChecked("chkMOH") )
    {
        usrInfoJson += jsonEncodeNumber("right_moh", 1)+",";
    }
    if( inputHasChecked("chkRelay") )
    {
        usrInfoJson += jsonEncodeNumber("right_relay", 1)+",";
    }
    if( inputHasChecked("chkOLI") )
    {
        usrInfoJson += jsonEncodeNumber("right_oli", 1)+",";
    }
    if( inputHasChecked("chkTLI") )
    {
        usrInfoJson += jsonEncodeNumber("right_tli", 1)+",";
    }
    if( inputHasChecked("chkCW") )
    {
        usrInfoJson += jsonEncodeNumber("right_cw", 1)+",";
    }
    if( inputHasChecked("chkIPAuth") )
    {
        usrInfoJson += jsonEncodeNumber("right_ipauth", 1)+",";
    }
    
    usrInfoJson += jsonEncodeString("endjson", "yes");
    
    usrInfoJson += "}";
    
    $.ajax({
        url:  "/dbajax/localuser/set",
        type: "get",
        data: {content:usrInfoJson},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiLocalUser.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiLocalUser.html");
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie();
    loadHtmlPage("../uiLocalUserDlg.html");
};

gotoPrevList=function() {
    pageNav=0;
    pageIndex--;
    getLocalUserList(pageIndex);
};

gotoNextList=function() {
    pageNav=1;
    pageIndex++;
    getLocalUserList(pageIndex);
};

editLocalUser=function(usr_name) {
    var dataPost = "usrname="+encodeURIComponent(usr_name);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiLocalUserDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiLocalUser.html");
};
