
buildIndexStr=function(dialPlan, calledNbr) {
    return hex_md5("dialPlan"+dialPlan+"calledNbr"+calledNbr);
};

getIVRTriggerListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.dialPlan, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.dialPlan+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        if( null != ev.desc )
        {    
            $("#"+indexStr).append("<td>"+ev.desc+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        $("#"+indexStr).append("<td>"+ev.fileName+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editIVRTrigger(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delIVRTrigger(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getIVRTriggerList=function() {
    $.ajax({
        url: "/dbajax/ivrtrigger/list",
        type: "get",
        dataType: "json",
        success: getIVRTriggerListResp
    });
};

getIVRTriggerDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#dialPlan").val(ev.dialPlan);
        $("#calledNbr").val(ev.calledNbr);
        $("#desc").val(ev.desc);
        $("#fileName").val(ev.fileName);
    });
};

getIVRTriggerDetail=function(dial_plan, called_nbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/ivrtrigger/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getIVRTriggerDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateIVRTriggerDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    jsonStr += jsonEncodeString("desc", $("#desc").val())+",";
    jsonStr += jsonEncodeString("fileName", $("#fileName").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/ivrtrigger/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiIVRTrigger.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiIVRTrigger.html");
        }
    });
};

delIVRTrigger=function(dial_plan, called_nbr) {    
    var indexStr = buildIndexStr(dial_plan, called_nbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/ivrtrigger/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiIVRTriggerDlg.html");
};

editIVRTrigger=function(dial_plan, called_nbr) {
    var dataPost = "dialPlan="+encodeURIComponent(dial_plan);   
    dataPost += "&calledNbr="+encodeURIComponent(called_nbr); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiIVRTriggerDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiIVRTrigger.html");
};
