#!/bin/sh
case $# in
  1) installdir=$1/mexplorer;;
  *) installdir=/usr/local/mexplorer;;
esac
echo Remove old files...
if test -d $installdir
then rm -rf $installdir
fi
echo Copy installation files to $installdir ...
mkdir $installdir
mkdir $installdir/bin
mkdir $installdir/resource
tar xzf me-linux.tar.gz -C $installdir/bin
mv -f $installdir/bin/mexplorer /usr/local/bin
(
cd $installdir/bin;
mv mexplorer.png ../resource
ln -sf libCxImage.so.7.0.2 libCxImage.so;
ln -sf libproj.so.0.4.1 libproj.so.0;
ln -sf libproj.so.0 libproj.so;
ln -sf libwgrib.so.1.8 libwgrib.so.1;
ln -sf libwgrib.so.1 libwgrib.so;
ln -sf libdf.so.0.0.0 libdf.so.0;
ln -sf libdf.so.0 libdf.so;
ln -sf libmfhdf.so.0.0.0 libmfhdf.so.0;
ln -sf libmfhdf.so.0 libmfhdf.so;
ln -sf libhdf5.so.6.0.4 libhdf5.so.6;
ln -sf libhdf5.so.6 libhdf5.so;
ln -sf libnetcdf.so.7.1.1 libnetcdf.so.7;
ln -sf libnetcdf.so.7 libnetcdf.so;
ln -sf libsz.so.2.0.0 libsz.so.2
ln -sf libsz.so.2 libsz.so
ln -sf libQtCore.so.4.5.3 libQtCore.so.4
ln -sf libQtGui.so.4.5.3 libQtGui.so.4
ln -sf libQtNetwork.so.4.5.3 libQtNetwork.so.4
ln -sf libQtOpenGL.so.4.5.3 libQtOpenGL.so.4
tar xvzf zht.tar.gz > /dev/null 2>&1;
)
echo Done.
