/*
 * Simple Application.
 */
package com.example;

import com.license4j.License;
import com.license4j.LicenseValidator;
import com.license4j.ValidationStatus;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class MainJFrame extends javax.swing.JFrame {

    /**
     * Creates new form MainJFrame
     */
    public MainJFrame() {
        initComponents();
        
        setLocationRelativeTo(null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Netbeans Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenu2 = new javax.swing.JMenu();
        jMenu3 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Easy Validate Example");

        jMenu1.setText("File");
        jMenuBar1.add(jMenu1);

        jMenu2.setText("Edit");
        jMenuBar1.add(jMenu2);

        jMenu3.setText("Help");

        jMenuItem1.setText("Licensing");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenu3.add(jMenuItem1);

        jMenuBar1.add(jMenu3);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 499, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 344, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        // Run License key gui
        new LicenseKeyGUI(this, true).setVisible(true);
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        //<editor-fold defaultstate="collapsed" desc="Look and Feel Code">
        /* Set system default look and feel */
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                // First, we try to validate license if avaiable on disk.
                License license = LicenseValidator.easyValidateOnStartup("1c28t289t18897ksb2b17batsacckobm2m91kb8b36ko6k8kk91861oa8d62m2898d69kmst8m8mctkm678ctm9mms19ddst6t7tas216mdkd6dtoctstmscdo2878cb9mt166o1a76a27tsct2o2mosc9dd3ct86od3813od88abo8dc9d31t91886ok71ko6maos62t3b1mo3c1b762671tac613b1m977m163tbo23s7s66sdktms2tkoo7kmtt9966m9d93c2k32atsda21mk2dck92t22cm9atd1ct79b8bo3db8tbc7738681mmt89kdatm199oa1899kskko6a82612s2o63a98btta8ad8am767c962bc3a2admkodt3bm9ko382ct1aok2b18bscm1b9aamdb6m9c3ks62o8tckkkdbkt1k1damk2s3oct9kd376c36ka6s69ao3787s723daoao83t93bc1aa6mobbk122t13oto9sk8tmd8tt3o7o3m91s36mmbt262837d38t3mmk2s9sto3d67d8mab29c3233tso326td96a2m1k7m8tadc77m62kcdbs8msm2ak98o3bbkkc2d7dc6md1bas286a3mdo6cta19od2m17ot37sk3ma2s2mob92923ass2s7s899t1m7o7so6stkk961o6sc96692m6cc77d728sc3ob33s8ada917add89dc9379t7o68t761c33m6b8ttc6kk13sobok86t3t3b2bobot3dat2663t2o6ta1aaco1absko61a1sbmdoo92381a8ksa926ooc79bbmo7c6obd3moo118bo19skm9cbab3s9623ok93dst9kd9d9bo7s9oks61sbcttb1kt3csttb2b6t26t2dkkm1289bo1bbtoo2b763dm1m6269csk8bcak98m22tdm27c6kac17dbo127bkkb7k9d87kbsd31oo2cdsb8292mcasddd2skatmm83o6db8bctss71co2oscmko9koskm637998s1b6c93tdo6s3d8btmbkaa1cdt1m17bbd7mam2ccbms873d21s38b17boakb189dos88odk217d26oooa61m1a789ttbs2o2313kct26ks3s6228t2a9booa8dmo6kbad799a7");
                
                switch (license.getValidationStatus()) {
                    case LICENSE_VALID:
                        // license file exists and license is valid...
                        break;
                    default:
                        // license is not valid

                        // display a simple license error mrssage to user.
                        // you may directly display LicenseKeyGUI for a better experience...
                        JOptionPane.showMessageDialog(null, "License is not valid (" + license.getValidationStatus() + ")", "License Error", JOptionPane.ERROR_MESSAGE);

                        // then ask for a license in a simple way with input dialog.
                        String licenseString = JOptionPane.showInputDialog("Enter a valid license.");
                        
                        if (licenseString != null) {
                            // if user supplied a license, then validate it.
                            license = LicenseValidator.easyValidate(licenseString, "1c28t289t18897ksb2b17batsacckobm2m91kb8b36ko6k8kk91861oa8d62m2898d69kmst8m8mctkm678ctm9mms19ddst6t7tas216mdkd6dtoctstmscdo2878cb9mt166o1a76a27tsct2o2mosc9dd3ct86od3813od88abo8dc9d31t91886ok71ko6maos62t3b1mo3c1b762671tac613b1m977m163tbo23s7s66sdktms2tkoo7kmtt9966m9d93c2k32atsda21mk2dck92t22cm9atd1ct79b8bo3db8tbc7738681mmt89kdatm199oa1899kskko6a82612s2o63a98btta8ad8am767c962bc3a2admkodt3bm9ko382ct1aok2b18bscm1b9aamdb6m9c3ks62o8tckkkdbkt1k1damk2s3oct9kd376c36ka6s69ao3787s723daoao83t93bc1aa6mobbk122t13oto9sk8tmd8tt3o7o3m91s36mmbt262837d38t3mmk2s9sto3d67d8mab29c3233tso326td96a2m1k7m8tadc77m62kcdbs8msm2ak98o3bbkkc2d7dc6md1bas286a3mdo6cta19od2m17ot37sk3ma2s2mob92923ass2s7s899t1m7o7so6stkk961o6sc96692m6cc77d728sc3ob33s8ada917add89dc9379t7o68t761c33m6b8ttc6kk13sobok86t3t3b2bobot3dat2663t2o6ta1aaco1absko61a1sbmdoo92381a8ksa926ooc79bbmo7c6obd3moo118bo19skm9cbab3s9623ok93dst9kd9d9bo7s9oks61sbcttb1kt3csttb2b6t26t2dkkm1289bo1bbtoo2b763dm1m6269csk8bcak98m22tdm27c6kac17dbo127bkkb7k9d87kbsd31oo2cdsb8292mcasddd2skatmm83o6db8bctss71co2oscmko9koskm637998s1b6c93tdo6s3d8btmbkaa1cdt1m17bbd7mam2ccbms873d21s38b17boakb189dos88odk217d26oooa61m1a789ttbs2o2313kct26ks3s6228t2a9booa8dmo6kbad799a7");

                            // if given license is valid, it will be saved to file "<your home directory>.License4J Examples/license"
                            // e.g. on windows "C:\Users\<your username>\.License4J Examples\license"
                        }
                }

                // For information only, will be printed to stdout.
                System.out.println("License Validation Status: " + license.getValidationStatus());
                System.out.println("License Activation Status: " + license.getActivationStatus());
                
                if (license.getValidationStatus() == ValidationStatus.LICENSE_VALID) {
                    // if license is valid, display the main frame.
                    new MainJFrame().setVisible(true);
                }
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenu jMenu3;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    // End of variables declaration//GEN-END:variables
}
