/*
 * License Key GUI file, for license input.
 */
package com.example;

import com.license4j.License;
import com.license4j.LicenseValidator;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/**
 * LicenseKeyGUI.
 *
 */
public class LicenseKeyGUI extends javax.swing.JDialog {
    /* LicenseKeyGUI constructor. */

    public LicenseKeyGUI(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        // a status label, hidden at first.
        jLabel3.setVisible(false);

        this.setLocationRelativeTo(parent);

        // for simplicity we just revalidate license on disk, to display details on GUI
        // Usually, you dont need to revalidate, pass license object already validated.
        License license = LicenseValidator.easyValidateOnStartup("1c28t289t18897ksb2b17batsacckobm2m91kb8b36ko6k8kk91861oa8d62m2898d69kmst8m8mctkm678ctm9mms19ddst6t7tas216mdkd6dtoctstmscdo2878cb9mt166o1a76a27tsct2o2mosc9dd3ct86od3813od88abo8dc9d31t91886ok71ko6maos62t3b1mo3c1b762671tac613b1m977m163tbo23s7s66sdktms2tkoo7kmtt9966m9d93c2k32atsda21mk2dck92t22cm9atd1ct79b8bo3db8tbc7738681mmt89kdatm199oa1899kskko6a82612s2o63a98btta8ad8am767c962bc3a2admkodt3bm9ko382ct1aok2b18bscm1b9aamdb6m9c3ks62o8tckkkdbkt1k1damk2s3oct9kd376c36ka6s69ao3787s723daoao83t93bc1aa6mobbk122t13oto9sk8tmd8tt3o7o3m91s36mmbt262837d38t3mmk2s9sto3d67d8mab29c3233tso326td96a2m1k7m8tadc77m62kcdbs8msm2ak98o3bbkkc2d7dc6md1bas286a3mdo6cta19od2m17ot37sk3ma2s2mob92923ass2s7s899t1m7o7so6stkk961o6sc96692m6cc77d728sc3ob33s8ada917add89dc9379t7o68t761c33m6b8ttc6kk13sobok86t3t3b2bobot3dat2663t2o6ta1aaco1absko61a1sbmdoo92381a8ksa926ooc79bbmo7c6obd3moo118bo19skm9cbab3s9623ok93dst9kd9d9bo7s9oks61sbcttb1kt3csttb2b6t26t2dkkm1289bo1bbtoo2b763dm1m6269csk8bcak98m22tdm27c6kac17dbo127bkkb7k9d87kbsd31oo2cdsb8292mcasddd2skatmm83o6db8bctss71co2oscmko9koskm637998s1b6c93tdo6s3d8btmbkaa1cdt1m17bbd7mam2ccbms873d21s38b17boakb189dos88odk217d26oooa61m1a789ttbs2o2313kct26ks3s6228t2a9booa8dmo6kbad799a7");
        // update GUI with license.
        updateGUIFieldsWithLicenseObject(license);
    }

    /* This method updates fields on window with license object. */
    private void updateGUIFieldsWithLicenseObject(License license) {
        if (license != null) {
            switch (license.getValidationStatus()) {
                case LICENSE_VALID:
                    if (license.isActivationRequired()) {
                        if (license.isActivationCompleted()) {
                            licenseStatusjTextField.setText("VALID - ACTIVATED");
                            licenseStatusjTextField.setForeground(Color.BLUE);
                        } else {
                            licenseStatusjTextField.setText("VALID - NOT ACTIVATED");
                            licenseExpirationDatejTextField.setText("Days Left for Activation: " + license.getLicenseActivationDaysRemaining(null));
                            licenseStatusjTextField.setForeground(Color.red);
                            licenseExpirationDatejTextField.setForeground(Color.red);
                        }
                    } else {
                        licenseStatusjTextField.setText("VALID");
                        licenseStatusjTextField.setForeground(Color.BLUE);
                    }
                    break;
                default:
                    licenseStatusjTextField.setText(license.getValidationStatus().toString());
                    licenseStatusjTextField.setForeground(Color.red);
            }

            if (license.getLicenseText() != null) {
                if (license.getLicenseText().getLicenseExpireDate() != null) {
                    licenseExpirationDatejTextField.setText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(license.getLicenseText().getLicenseExpireDate()));

                    /* If license expire date is before current date, then set expiration date field color red. */
                    if (license.getLicenseText().getLicenseExpireDate().before(new Date())) {
                        licenseExpirationDatejTextField.setForeground(Color.red);
                    } else {
                        licenseExpirationDatejTextField.setForeground(Color.BLUE);
                    }
                }

                /* Here set user information fields if available in license. */
                namejTextField.setText(license.getLicenseText().getUserFullName() != null ? license.getLicenseText().getUserFullName() : "");
                emailjTextField.setText(license.getLicenseText().getUserEMail() != null ? license.getLicenseText().getUserEMail() : "");
                companyjTextField.setText(license.getLicenseText().getUserCompany() != null ? license.getLicenseText().getUserCompany() : "");
            } else {
                /**
                 * License Text is null, means it is not activated or activation
                 * return type is an activation code. So we clear GUI fields.
                 */
                licenseExpirationDatejTextField.setText("");
                namejTextField.setText("");
                emailjTextField.setText("");
                companyjTextField.setText("");
            }
        } else {
            licenseStatusjTextField.setText("NO LICENSE AVAILABLE");
            licenseStatusjTextField.setForeground(Color.red);

            /**
             * No license; clear GUI fields if some information left from
             * previous license...
             */
            namejTextField.setText("");
            emailjTextField.setText("");
            companyjTextField.setText("");
        }
    }

    /**
     * Following "Generated Code" is generated by Netbeans form editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        licenseExpirationDatejTextField = new javax.swing.JTextField();
        licenseStatusjTextField = new javax.swing.JTextField();
        closejButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        namejTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        emailjTextField = new javax.swing.JTextField();
        companyjTextField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        changeProductKeyjButton = new javax.swing.JButton();
        progressjLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Licensing");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Product License Information"));

        jLabel1.setText("License Status:");

        jLabel2.setText("License Expiration Date:");

        licenseExpirationDatejTextField.setEditable(false);

        licenseStatusjTextField.setEditable(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(20, 20, 20)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(licenseExpirationDatejTextField)
                    .addComponent(licenseStatusjTextField))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(licenseStatusjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(licenseExpirationDatejTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        closejButton.setText("Close");
        closejButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closejButtonActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Product is Licensed to"));

        jLabel4.setText("Name:");

        namejTextField.setEditable(false);

        jLabel5.setText("e-mail:");

        emailjTextField.setEditable(false);

        companyjTextField.setEditable(false);

        jLabel6.setText("Company:");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addGap(87, 87, 87)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel5, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel6, javax.swing.GroupLayout.Alignment.TRAILING))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(namejTextField, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(emailjTextField, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(companyjTextField, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(namejTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(emailjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(companyjTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        changeProductKeyjButton.setText("Change Product Key");
        changeProductKeyjButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                changeProductKeyjButtonActionPerformed(evt);
            }
        });

        progressjLabel.setForeground(java.awt.Color.red);
        progressjLabel.setText(" ");

        jLabel3.setForeground(java.awt.Color.red);
        jLabel3.setText("Validating License ...");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 167, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(progressjLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(175, 175, 175)
                        .addComponent(changeProductKeyjButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(closejButton))
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(closejButton)
                    .addComponent(changeProductKeyjButton)
                    .addComponent(progressjLabel)
                    .addComponent(jLabel3))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {changeProductKeyjButton, closejButton});

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void changeProductKeyjButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_changeProductKeyjButtonActionPerformed
        /**
         * Basically we show an input dialog to get license key. It will be
         * better to use a JDialog with required license key input fields.
         */
        final String key = JOptionPane.showInputDialog(null, "Enter License Key", "License Key", JOptionPane.QUESTION_MESSAGE);

        if (key != null) {
            /**
             * We use a SwingWorker here because it will connect to license
             * server for activation, and it may take 2-3 seconds.
             */
            SwingWorker<License, Void> worker = new SwingWorker<License, Void>() {
                @Override
                protected void done() {
                    try {
                        License license = (License) get();

                        // update GUI with license.
                        updateGUIFieldsWithLicenseObject(license);

                        // display Validating License...   label.
                        jLabel3.setVisible(false);
                    } catch (Exception ex) {
                        Logger.getLogger(LicenseKeyGUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }

                @Override
                protected License doInBackground() {
                    return LicenseValidator.easyValidate(key, "1c28t289t18897ksb2b17batsacckobm2m91kb8b36ko6k8kk91861oa8d62m2898d69kmst8m8mctkm678ctm9mms19ddst6t7tas216mdkd6dtoctstmscdo2878cb9mt166o1a76a27tsct2o2mosc9dd3ct86od3813od88abo8dc9d31t91886ok71ko6maos62t3b1mo3c1b762671tac613b1m977m163tbo23s7s66sdktms2tkoo7kmtt9966m9d93c2k32atsda21mk2dck92t22cm9atd1ct79b8bo3db8tbc7738681mmt89kdatm199oa1899kskko6a82612s2o63a98btta8ad8am767c962bc3a2admkodt3bm9ko382ct1aok2b18bscm1b9aamdb6m9c3ks62o8tckkkdbkt1k1damk2s3oct9kd376c36ka6s69ao3787s723daoao83t93bc1aa6mobbk122t13oto9sk8tmd8tt3o7o3m91s36mmbt262837d38t3mmk2s9sto3d67d8mab29c3233tso326td96a2m1k7m8tadc77m62kcdbs8msm2ak98o3bbkkc2d7dc6md1bas286a3mdo6cta19od2m17ot37sk3ma2s2mob92923ass2s7s899t1m7o7so6stkk961o6sc96692m6cc77d728sc3ob33s8ada917add89dc9379t7o68t761c33m6b8ttc6kk13sobok86t3t3b2bobot3dat2663t2o6ta1aaco1absko61a1sbmdoo92381a8ksa926ooc79bbmo7c6obd3moo118bo19skm9cbab3s9623ok93dst9kd9d9bo7s9oks61sbcttb1kt3csttb2b6t26t2dkkm1289bo1bbtoo2b763dm1m6269csk8bcak98m22tdm27c6kac17dbo127bkkb7k9d87kbsd31oo2cdsb8292mcasddd2skatmm83o6db8bctss71co2oscmko9koskm637998s1b6c93tdo6s3d8btmbkaa1cdt1m17bbd7mam2ccbms873d21s38b17boakb189dos88odk217d26oooa61m1a789ttbs2o2313kct26ks3s6228t2a9booa8dmo6kbad799a7");
                }
            };
            worker.execute();

            // display Validating License...   label.
            jLabel3.setVisible(true);
        }
    }//GEN-LAST:event_changeProductKeyjButtonActionPerformed

    private void closejButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closejButtonActionPerformed
        dispose();
    }//GEN-LAST:event_closejButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton changeProductKeyjButton;
    private javax.swing.JButton closejButton;
    private javax.swing.JTextField companyjTextField;
    private javax.swing.JTextField emailjTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField licenseExpirationDatejTextField;
    private javax.swing.JTextField licenseStatusjTextField;
    private javax.swing.JTextField namejTextField;
    private javax.swing.JLabel progressjLabel;
    // End of variables declaration//GEN-END:variables
}
