/*
 * Simple text editor application.
 * 
 * The licensing for this example is a license key with enabled activation; and
 * activation return type is a license text.
 */
package com.example.licensing.FloatingLicenseText;

import com.license4j.License;
import com.license4j.ValidationStatus;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;

/**
 *
 * Main JFrame.
 */
public class MyProductMainJFrame extends javax.swing.JFrame {

    /**
     * COPY THIS LINE.
     */
    private FloatingLicenseTextGUI licenseTextGUI;

    /**
     * Creates new form MyProductMainJFrame
     */
    public MyProductMainJFrame() {
        initComponents();

        this.setSize(600, 400);
        this.setLocationRelativeTo(null);

        /**
         * COPY THIS LINE.
         */
        licenseTextGUI = new FloatingLicenseTextGUI(this, true);
    }

    /**
     * Following "Generated Code" is generated by Netbeans form editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();
        jMenuBar1 = new javax.swing.JMenuBar();
        filejMenu = new javax.swing.JMenu();
        newjMenuItem = new javax.swing.JMenuItem();
        openjMenuItem = new javax.swing.JMenuItem();
        savejMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        exitjMenuItem = new javax.swing.JMenuItem();
        helpJMenu = new javax.swing.JMenu();
        licensejMenuItem = new javax.swing.JMenuItem();
        aboutjMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("My Product");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jScrollPane2.setViewportView(jEditorPane1);

        getContentPane().add(jScrollPane2, java.awt.BorderLayout.CENTER);

        filejMenu.setText("File");

        newjMenuItem.setText("New");
        newjMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newjMenuItemActionPerformed(evt);
            }
        });
        filejMenu.add(newjMenuItem);

        openjMenuItem.setText("Open");
        openjMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openjMenuItemActionPerformed(evt);
            }
        });
        filejMenu.add(openjMenuItem);

        savejMenuItem.setText("Save");
        savejMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                savejMenuItemActionPerformed(evt);
            }
        });
        filejMenu.add(savejMenuItem);
        filejMenu.add(jSeparator1);

        exitjMenuItem.setText("Exit");
        exitjMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitjMenuItemActionPerformed(evt);
            }
        });
        filejMenu.add(exitjMenuItem);

        jMenuBar1.add(filejMenu);

        helpJMenu.setText("Help");

        licensejMenuItem.setText("License");
        licensejMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                licensejMenuItemActionPerformed(evt);
            }
        });
        helpJMenu.add(licensejMenuItem);

        aboutjMenuItem.setText("About");
        aboutjMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutjMenuItemActionPerformed(evt);
            }
        });
        helpJMenu.add(aboutjMenuItem);

        jMenuBar1.add(helpJMenu);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitjMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitjMenuItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitjMenuItemActionPerformed

    private void savejMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savejMenuItemActionPerformed
        JFileChooser jFileChooser1 = new JFileChooser();
        int r = jFileChooser1.showSaveDialog(this);
        if (r == JFileChooser.APPROVE_OPTION) {
            try {
                FileUtils.writeStringToFile(jFileChooser1.getSelectedFile(), jEditorPane1.getText());
            } catch (IOException ex) {
                Logger.getLogger(MyProductMainJFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_savejMenuItemActionPerformed

    private void openjMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openjMenuItemActionPerformed
        JFileChooser jFileChooser1 = new JFileChooser();
        int r = jFileChooser1.showOpenDialog(this);
        if (r == JFileChooser.APPROVE_OPTION) {
            try {
                String text = FileUtils.readFileToString(jFileChooser1.getSelectedFile());
                jEditorPane1.setText(text);
            } catch (IOException ex) {
                Logger.getLogger(MyProductMainJFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_openjMenuItemActionPerformed

    private void newjMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newjMenuItemActionPerformed
        jEditorPane1.setText("");
    }//GEN-LAST:event_newjMenuItemActionPerformed

    private void aboutjMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutjMenuItemActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_aboutjMenuItemActionPerformed

    private void licensejMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_licensejMenuItemActionPerformed
        /**
         * COPY THIS LINE if you have a licensing menu item.
         */
        licenseTextGUI.setVisible(true);
    }//GEN-LAST:event_licensejMenuItemActionPerformed

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        /**
         * COPY THIS METHOD.
         *
         * We will check license here in "formWindowOpened" so that license
         * window will be displayed after user will see main product window.
         *
         * Depending license status, we will display license window.
         *
         * If a valid license cannot be obtained, display license info on
         * window. ALSO it is good to disable some features or menu items like
         * below; so that user will not be able to use product without a valid
         * license. OR software may be directly closed with an error.
         *
         * It is better to run this code in SwingWorker because may take 2-3
         * seconds to get license.
         */

        SwingWorker<License, Void> worker = new SwingWorker<License, Void>() {
            @Override
            protected void done() {
                try {
                    License license = get();

                    if (license != null) {
                        if (license.getValidationStatus() == ValidationStatus.LICENSE_VALID) {
                            /**
                             * License is valid, allow to run your software.
                             */
                        } else {
                            JOptionPane.showMessageDialog(null, "Your license is not valid (" + license.getValidationStatus() + ")", "License Error", WIDTH);

                            // This is an example, and we just disable main file menu.
                            filejMenu.setEnabled(false);

                            licenseTextGUI.setVisible(true);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "You should have a valid license to run this software.", "License Error", JOptionPane.ERROR_MESSAGE);

                        // This is an example, and we just disable main file menu.
                        filejMenu.setEnabled(false);

                        licenseTextGUI.setVisible(true);
                    }
                } catch (InterruptedException ex) {
                    Logger.getLogger(MyProductMainJFrame.class.getName()).log(Level.SEVERE, null, ex);
                } catch (ExecutionException ex) {
                    Logger.getLogger(MyProductMainJFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            protected License doInBackground() {
                License license = licenseTextGUI.checkLicense();

                return license;
            }
        };
        worker.execute();
    }//GEN-LAST:event_formWindowOpened

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set system default look and feel */
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(MyProductMainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(MyProductMainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(MyProductMainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(MyProductMainJFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new MyProductMainJFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem aboutjMenuItem;
    private javax.swing.JMenuItem exitjMenuItem;
    private javax.swing.JMenu filejMenu;
    private javax.swing.JMenu helpJMenu;
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JMenuItem licensejMenuItem;
    private javax.swing.JMenuItem newjMenuItem;
    private javax.swing.JMenuItem openjMenuItem;
    private javax.swing.JMenuItem savejMenuItem;
    // End of variables declaration//GEN-END:variables
}
