/*
 * Decompiled with CFR 0.152.
 */
package com.license4j;

import com.license4j.License;
import com.license4j.LicenseKey;
import com.license4j.LicenseKeyPair;
import com.license4j.LicenseText;
import com.license4j.LicenseValidator;
import com.license4j.exceptions.LicenseSecurityException;
import com.license4j.util.Base32;
import com.license4j.util.Crypto;
import com.license4j.util.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class LicenseManager {
    /*
     * WARNING - void declaration
     */
    public static LicenseKeyPair createKeyPair(String name, String description, String keypairAlgorithm, String signatureAlgorithm, int keysize) throws LicenseSecurityException {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            object4 = KeyPairGenerator.getInstance(keypairAlgorithm);
            ((KeyPairGenerator)object4).initialize(keysize);
            object3 = ((KeyPairGenerator)object4).genKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LicenseSecurityException("License security error. " + noSuchAlgorithmException.getLocalizedMessage());
        }
        object4 = "NOEC";
        String string2 = "NOEC";
        if ((System.getProperty("java.version").startsWith("1.7") || System.getProperty("java.version").startsWith("1.8")) && !System.getProperty("java.vm.name").contains("OpenJDK")) {
            try {
                object2 = KeyPairGenerator.getInstance(Crypto.decrypt("8e156e80d68a21e7"));
                ((KeyPairGenerator)object2).initialize(112);
                object = ((KeyPairGenerator)object2).genKeyPair();
            }
            catch (Exception exception) {
                throw new LicenseSecurityException("License security error. " + exception.getLocalizedMessage());
            }
            object4 = Hex.encodeHexString(((KeyPair)object).getPublic().getEncoded());
            string2 = Hex.encodeHexString(((KeyPair)object).getPrivate().getEncoded());
            object4 = LicenseManager.a("EC", "SHA512withECDSA", 112, (String)object4);
        }
        object = Hex.encodeHexString(((KeyPair)object3).getPublic().getEncoded());
        object2 = Hex.encodeHexString(((KeyPair)object3).getPrivate().getEncoded());
        object = LicenseManager.a(keypairAlgorithm, signatureAlgorithm, keysize, (String)object);
        object3 = ((String)object).substring(0, 50) + (String)object4 + "G" + ((String)object).substring(50, ((String)object).length());
        object4 = ((String)object2).substring(0, 50) + string2 + "G" + ((String)object2).substring(50, ((String)object2).length());
        string2 = String.valueOf(System.currentTimeMillis());
        return new LicenseKeyPair(string2, string, (String)var1_1, (String)object3, (String)object4, (String)var2_2, (String)var3_3, keysize);
    }

    public static LicenseKeyPair loadKeyPair(String keypairString) throws LicenseSecurityException {
        String string;
        Object object = new Properties();
        if (keypairString == null || keypairString.length() < 100) {
            throw new IllegalArgumentException("Keypair string error");
        }
        try {
            string = Crypto.decrypt(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LicenseSecurityException(noSuchAlgorithmException.getLocalizedMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new LicenseSecurityException(invalidKeySpecException.getLocalizedMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new LicenseSecurityException(noSuchPaddingException.getLocalizedMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new LicenseSecurityException(illegalBlockSizeException.getLocalizedMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new LicenseSecurityException(badPaddingException.getLocalizedMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new LicenseSecurityException(invalidKeyException.getLocalizedMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new LicenseSecurityException(invalidAlgorithmParameterException.getLocalizedMessage());
        }
        try {
            ((Properties)object).load(new ByteArrayInputStream(string.getBytes("UTF-8")));
        }
        catch (IOException iOException) {
            Logger.getLogger(LicenseManager.class.getName()).log(Level.FINE, null, iOException);
        }
        if (((Properties)object).getProperty("id") == null || ((Properties)object).getProperty("publickey") == null) {
            throw new IllegalArgumentException("Given key pair file content is invalid.");
        }
        String string2 = string = ((Properties)object).getProperty("publickey");
        if (string.indexOf("SHA512withECDSA") != -1) {
            string2 = string2.substring(0, 50) + string2.substring(string2.indexOf("G") + 1, string2.length());
        } else if (string2.indexOf("NOEC") != -1) {
            string2 = string2.replace("NOECG", "");
        }
        int n = string2.length() < 250 ? 25 : 250;
        int n2 = Integer.parseInt(string2.substring(n, n + 2));
        String string3 = string2.substring(n + 2, n + 2 + n2);
        int n3 = Integer.parseInt(string2.substring(n + 2 + n2, n + 2 + n2 + 1));
        int n4 = Integer.parseInt(string2.substring(n + 2 + n2 + 1, n + 2 + n2 + 1 + n3));
        int n5 = Integer.parseInt(string2.substring(n + 2 + n2 + 1 + n3, n + 2 + n2 + 1 + n3 + 2));
        string2 = string2.substring(n + 2 + n2 + 1 + n3 + 2, n + 2 + n2 + 1 + n3 + 2 + n5);
        String string4 = ((Properties)object).getProperty("id");
        String string5 = ((Properties)object).getProperty("privatekey");
        String string6 = ((Properties)object).getProperty("name");
        object = ((Properties)object).getProperty("description");
        return new LicenseKeyPair(string4, string6, (String)object, string, string5, string3, string2, n4);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateLicenseText(LicenseKeyPair keypair, LicenseText licenseTextObject) throws LicenseSecurityException {
        LicenseKeyPair licenseKeyPair;
        void var1_1;
        Signature signature;
        try {
            signature = Signature.getInstance(keypair.getLicenseTextSignatureAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LicenseSecurityException("License security error. " + noSuchAlgorithmException.getLocalizedMessage());
        }
        Object object = keypair.getPrivateKey();
        if (((String)object).indexOf("G") != -1) {
            object = ((String)object).substring(0, 50) + ((String)object).substring(((String)object).indexOf("G") + 1, ((String)object).length());
        }
        try {
            object = Hex.decodeHex(((String)object).toCharArray());
            KeyFactory keyFactory = KeyFactory.getInstance(keypair.getLicenseTextKeyPairAlgorithm());
            object = new PKCS8EncodedKeySpec((byte[])object);
            object = keyFactory.generatePrivate((KeySpec)object);
            signature.initSign((PrivateKey)object);
        }
        catch (Exception exception) {
            throw new LicenseSecurityException("License security error. " + exception.getLocalizedMessage());
        }
        if (!LicenseManager.a(licenseTextObject)) {
            return null;
        }
        if (licenseTextObject.getLicenseID() == 0L) {
            licenseTextObject.setLicenseID(System.currentTimeMillis());
        }
        if (licenseTextObject.getLicenseGenerationDateTime() == 0L) {
            licenseTextObject.setLicenseGenerationDateTime(licenseTextObject.getLicenseID());
        }
        if (licenseTextObject.getLicenseFileType() == 1) {
            licenseTextObject.setLicensePublicKey(keypair.getPublicKey());
        }
        try {
            signature.update(licenseTextObject.a().getBytes("UTF-8"));
        }
        catch (SignatureException signatureException) {
            throw new LicenseSecurityException("License security error. " + signatureException.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new LicenseSecurityException("License security error. " + unsupportedEncodingException.getLocalizedMessage());
        }
        try {
            object = Hex.encodeHexString(signature.sign());
        }
        catch (SignatureException signatureException) {
            throw new LicenseSecurityException("License security error. " + signatureException.getLocalizedMessage());
        }
        licenseTextObject.setLicenseSignature((String)object);
        if (licenseTextObject.getLicenseFileType() == 1) {
            return licenseTextObject.getContent(null);
        }
        return var1_1.getContent(licenseKeyPair.getPublicKey());
    }

    /*
     * WARNING - void declaration
     */
    public static String generateLicenseKey(LicenseKeyPair keypair, LicenseKey licenseKeyObject) throws LicenseSecurityException {
        void var1_4;
        Object object;
        Signature signature;
        if (keypair == null) {
            throw new IllegalArgumentException("Key pair must be not null.");
        }
        if (!System.getProperty("java.version").startsWith("1.7") && !System.getProperty("java.version").startsWith("1.8")) {
            throw new LicenseSecurityException("License security error. Oracle JDK 1.7+ is required for generating cryptographically secure license key.");
        }
        if (System.getProperty("java.vm.name").indexOf("OpenJDK") != -1) {
            System.err.println("License security error. Oracle JDK 1.7+ is required for validating cryptographically secure license key.");
        }
        try {
            signature = Signature.getInstance(keypair.getLicenseKeySignatureAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LicenseSecurityException("License security error. " + noSuchAlgorithmException.getLocalizedMessage());
        }
        Object object2 = keypair.getPrivateKey();
        Object object3 = null;
        if (((String)object2).indexOf("G") != -1) {
            object3 = ((String)object2).substring(50, ((String)object2).indexOf("G"));
        }
        object2 = object3;
        try {
            object2 = Hex.decodeHex(((String)object2).toCharArray());
            object = KeyFactory.getInstance(((LicenseKeyPair)object).getLicenseKeyKeyPairAlgorithm());
            object3 = new PKCS8EncodedKeySpec((byte[])object2);
            object = ((KeyFactory)object).generatePrivate((KeySpec)object3);
            signature.initSign((PrivateKey)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new LicenseSecurityException("License security error. " + noSuchAlgorithmException.getLocalizedMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new LicenseSecurityException("License security error. " + invalidKeyException.getLocalizedMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new LicenseSecurityException("License security error. " + invalidKeySpecException.getLocalizedMessage());
        }
        if (!LicenseManager.a(licenseKeyObject)) {
            return null;
        }
        if (licenseKeyObject.getNameforValidation() == null) {
            licenseKeyObject.setNameforValidation("");
        }
        if (licenseKeyObject.getCompanyforValidation() == null) {
            licenseKeyObject.setCompanyforValidation("");
        }
        if (licenseKeyObject.getHardwareID() == null) {
            licenseKeyObject.setHardwareID("");
        }
        object2 = "";
        if (licenseKeyObject.isActivationCompleted()) {
            object2 = "-ac";
        } else if (licenseKeyObject.isActivationRequired()) {
            object2 = "-ar-";
            object3 = new SimpleDateFormat("yyyy.MM.dd").format(licenseKeyObject.getGenerationDateTime());
            object2 = (String)object2 + String.valueOf(licenseKeyObject.getActivationPeriod()) + "-" + (String)object3;
        }
        object = String.valueOf((licenseKeyObject.getInternalString() + (String)object2 + licenseKeyObject.getNameforValidation() + licenseKeyObject.getCompanyforValidation() + var1_4.getHardwareID()).hashCode());
        try {
            signature.update(((String)object).getBytes("UTF-8"));
        }
        catch (SignatureException signatureException) {
            throw new LicenseSecurityException("License security error. " + signatureException.getLocalizedMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new LicenseSecurityException("License security error. " + unsupportedEncodingException.getLocalizedMessage());
        }
        try {
            object3 = Base32.encode(signature.sign());
            while (((String)object3).length() != 55) {
                try {
                    signature.update(((String)object).getBytes("UTF-8"));
                }
                catch (SignatureException signatureException) {
                    throw new LicenseSecurityException("License security error. " + signatureException.getLocalizedMessage());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new LicenseSecurityException("License security error. " + unsupportedEncodingException.getLocalizedMessage());
                }
                object3 = Base32.encode(signature.sign());
            }
        }
        catch (SignatureException signatureException) {
            throw new LicenseSecurityException("License security error. " + signatureException.getLocalizedMessage());
        }
        return LicenseManager.a((String)object3);
    }

    public static String generateLicenseKey(String publickey, LicenseKey licenseKeyObject) {
        Object object;
        Object object2;
        Object object3;
        if (publickey == null) {
            throw new IllegalArgumentException("Public key must be not null.");
        }
        if (publickey.length() < 100) {
            throw new IllegalArgumentException("Public key error.");
        }
        publickey = publickey.trim().replace("\n", "");
        Object object4 = "";
        if (licenseKeyObject.isActivationCompleted()) {
            object4 = "-ac";
        } else if (licenseKeyObject.isActivationRequired()) {
            object4 = "-ar";
            object3 = new SimpleDateFormat("yyyy.MM.dd").format(licenseKeyObject.getGenerationDateTime());
            object4 = (String)object4 + "-" + String.valueOf(licenseKeyObject.getActivationPeriod()) + "-" + (String)object3;
        }
        if (!LicenseManager.a(licenseKeyObject)) {
            return null;
        }
        if (licenseKeyObject.getNameforValidation() == null) {
            licenseKeyObject.setNameforValidation("");
        }
        if (licenseKeyObject.getCompanyforValidation() == null) {
            licenseKeyObject.setCompanyforValidation("");
        }
        if (licenseKeyObject.getHardwareID() == null) {
            licenseKeyObject.setHardwareID("");
        }
        Object object5 = String.valueOf((licenseKeyObject.getInternalString() + (publickey + ((String)object2).substring(16, 90)).hashCode() + (String)object4 + licenseKeyObject.getNameforValidation() + licenseKeyObject.getCompanyforValidation() + object.getHardwareID()).hashCode());
        object3 = new SecureRandom();
        object2 = null;
        try {
            object2 = Base32.encode(((String)object5).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        object = null;
        try {
            object = ((String)object2).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        object2 = new byte[15];
        ((SecureRandom)object3).nextBytes((byte[])object2);
        object4 = new byte[5 + ((byte[])object).length];
        System.arraycopy(object2, 0, object4, 0, 5);
        System.arraycopy(object, 0, object4, 5, ((byte[])object).length);
        try {
            object = object4;
            object5 = MessageDigest.getInstance("SHA-256");
            ((MessageDigest)object5).reset();
            System.arraycopy(((MessageDigest)object5).digest((byte[])object), 0, object2, 5, 10);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger(LicenseManager.class.getName()).log(Level.FINE, null, noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        int n = 17;
        for (int i = 0; i < ((Object)object4).length; ++i) {
            n += object4[i];
        }
        char[] cArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
        return LicenseManager.a(Base32.encode((byte[])object2) + cArray[n & 0x1F]);
    }

    private static String a(String string) {
        int n = (string = string.replace('0', '8').replace('O', '9')).length() == 55 ? 50 : 20;
        String string2 = string.substring(0, 5);
        int n2 = 0;
        if (string.length() == 55) {
            n2 = 10;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(10, 11));
        stringBuilder.append(string.substring(n2 + 13, n2 + 14));
        stringBuilder.append(string.substring(n2 + 17, n2 + 18));
        stringBuilder.append(string.substring(n2 + 20, n2 + 21));
        stringBuilder.append(string.substring(n2 + 23, n2 + 24));
        stringBuilder.append(string.substring(5, 10));
        stringBuilder.append(string2.substring(0, 1));
        stringBuilder.append(string.substring(11, n2 + 13));
        stringBuilder.append(string2.substring(1, 2));
        stringBuilder.append(string.substring(n2 + 14, n2 + 17));
        stringBuilder.append(string2.substring(2, 3));
        stringBuilder.append(string.substring(n2 + 18, n2 + 20));
        stringBuilder.append(string2.substring(3, 4));
        stringBuilder.append(string.substring(n2 + 21, n2 + 23));
        stringBuilder.append(string2.substring(4, 5));
        stringBuilder.append(string.substring(n2 + 24, string.length()));
        string = stringBuilder.toString();
        string2 = "";
        for (n2 = 0; n2 < n; n2 += 5) {
            string2 = string2 + string.substring(n2, n2 + 5) + "-";
        }
        return string2 + string.substring(n, n + 5);
    }

    private static String a(String string, String string2, int n, String string3) {
        int n2 = string.length();
        String string4 = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        n2 = string2.length();
        String string5 = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        String string6 = String.valueOf(n);
        String string7 = String.valueOf(string6.length());
        string4 = string4 + string + string7 + string6 + string5 + string2;
        int n3 = string3.length() < 250 ? 25 : 250;
        string2 = string3.substring(0, n3);
        String string8 = string3.substring(n3, string3.length());
        return string2 + string4 + string8;
    }

    public static String getLibraryVersion() {
        return "4.5.4";
    }

    private static boolean a(Object object) {
        block21: {
            String string;
            Object object2;
            block20: {
                object2 = System.getProperty("java.oss");
                if (object2 != null && ((String)object2).compareToIgnoreCase("java.oss") == 0) {
                    return true;
                }
                object2 = "30819f300d06092a864886f70d010101050003818d003081893032301006072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e00042f5625c362eca734e4060f274a02682174b667b84037c3a19ecea441G02818100c362c45032aadb5d289d0c9bd09bcfb1fd9918abbbc56b67f828f3dea0e1022813b6aa343b5433972d71c1131cbaabc0037ee291573d79d6fab1061ef5413086f1d905a278de04f8f7bed7f7a245947c2dcaa3332626527df188392fbfa85f4a03RSA4102413SHA512withRSAa2c0bd9f061ba5d5a30baa3668d4a937cd0b941c98d7c8c8d856d93a06be83310203010001";
                string = System.getProperty("license4j.license.key");
                String string2 = System.getProperty("license4j.license.text");
                if (string2 == null) break block20;
                object2 = LicenseValidator.validate(string2, (String)object2, "160928-0601-02-201101", null, null, null, new Date(1444089600000L));
                switch (((License)object2).getValidationStatus()) {
                    case LICENSE_VALID: {
                        if (((License)object2).getLicenseText().getCustomSignedFeature("t") != null && ((License)object2).getLicenseText().getCustomSignedFeature("t").compareTo("1") == 0) {
                            if (object instanceof LicenseText) {
                                ((LicenseText)object).setLicenseValidityPeriod(10);
                                ((LicenseText)object).setLicenseMaintenancePeriod(10);
                            } else if (object instanceof LicenseKey) {
                                ((LicenseKey)object).setNameforValidation("License4J Trial");
                            }
                            System.err.println("License4J License: Trial version running. License expire day and maintenance expire day will be set to 10 days.");
                            break;
                        }
                        break block21;
                    }
                    case LICENSE_INVALID: {
                        System.err.println("License4J License: Invalid.");
                        return false;
                    }
                    case LICENSE_EXPIRED: {
                        System.err.println("License4J License: Expired.");
                        return false;
                    }
                    case INCORRECT_SYSTEM_TIME: {
                        System.err.println("License4J License: System date/time is incorrect, change it before.");
                        return false;
                    }
                    case MISMATCH_HARDWARE_ID: {
                        System.err.println("License4J License: Hardware ID mismatch.");
                        return false;
                    }
                }
                break block21;
            }
            if (string != null) {
                object2 = LicenseValidator.validate(string, (String)object2, "license4j", null, null, 0);
                switch (((License)object2).getValidationStatus()) {
                    case LICENSE_VALID: {
                        if (((License)object2).getLicenseKey().getLicenseActivationDaysRemaining(null) > 0) break;
                        System.err.println("License4J License: Activation period expired. License key name will be set as 'License4J Trial'.");
                        ((LicenseKey)object).setNameforValidation("License4J Trial");
                        return false;
                    }
                    case LICENSE_INVALID: {
                        System.err.println("License4J License: Invalid.");
                        return false;
                    }
                    case LICENSE_EXPIRED: {
                        System.err.println("License4J License: Expired.");
                        return false;
                    }
                    case INCORRECT_SYSTEM_TIME: {
                        System.err.println("License4J License: System date/time is incorrect, change it before.");
                        return false;
                    }
                }
            } else {
                System.err.println("License4J License: No license found.");
                return false;
            }
        }
        return true;
    }
}

