/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class MethodDescriptorShrinker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraMemberVisitor;

    public MethodDescriptorShrinker() {
        this(null);
    }

    public MethodDescriptorShrinker(MemberVisitor memberVisitor) {
        this.extraMemberVisitor = memberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string;
        String string2 = programMethod.getDescriptor(programClass);
        if (!string2.equals(string = this.shrinkDescriptor(programMethod, string2))) {
            String string3;
            programMethod.attributesAccept(programClass, this);
            String string4 = string3 = programMethod.getName(programClass);
            if (!string3.equals("<init>")) {
                string4 = string4 + '$' + Long.toHexString(Math.abs(string2.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!string4.equals(string3)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            }
            programMethod.referencedClasses = this.shrinkReferencedClasses(programMethod, string2, programMethod.referencedClasses);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String string = signatureAttribute.getSignature(clazz);
        String string2 = this.shrinkDescriptor(method, string);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string2);
        signatureAttribute.referencedClasses = this.shrinkReferencedClasses(method, string, signatureAttribute.referencedClasses);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int[] nArray = parameterAnnotationsAttribute.u2parameterAnnotationsCount;
        Annotation[][] annotationArray = parameterAnnotationsAttribute.parameterAnnotations;
        int n = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
        int n2 = 0;
        int n3 = 0;
        String string = method.getDescriptor(clazz);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, n)) {
                nArray[n3] = nArray[n2];
                annotationArray[n3++] = annotationArray[n2];
            }
            ++n2;
            n += ClassUtil.isInternalCategory2Type(string2) ? 2 : 1;
        }
        parameterAnnotationsAttribute.u1parametersCount = n3;
        while (n3 < n2) {
            nArray[n3] = 0;
            annotationArray[n3++] = null;
        }
    }

    private String shrinkDescriptor(Method method, String string) {
        int n = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(internalTypeEnumeration.formalTypeParameters());
        stringBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, n)) {
                stringBuffer.append(string2);
            }
            n += ClassUtil.isInternalCategory2Type(string2) ? 2 : 1;
        }
        stringBuffer.append(')');
        stringBuffer.append(internalTypeEnumeration.returnType());
        return stringBuffer.toString();
    }

    private Clazz[] shrinkReferencedClasses(Method method, String string, Clazz[] clazzArray) {
        if (clazzArray != null) {
            int n;
            int n2 = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
            int n3 = 0;
            int n4 = 0;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            String string2 = internalTypeEnumeration.formalTypeParameters();
            int n5 = new DescriptorClassEnumeration(string2).classCount();
            for (n = 0; n < n5; ++n) {
                clazzArray[n4++] = clazzArray[n3++];
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                string2 = internalTypeEnumeration.nextType();
                n5 = new DescriptorClassEnumeration(string2).classCount();
                if (ParameterUsageMarker.isParameterUsed(method, n2)) {
                    for (n = 0; n < n5; ++n) {
                        clazzArray[n4++] = clazzArray[n3++];
                    }
                } else {
                    n3 += n5;
                }
                n2 += ClassUtil.isInternalCategory2Type(string2) ? 2 : 1;
            }
            string2 = internalTypeEnumeration.returnType();
            n5 = new DescriptorClassEnumeration(string2).classCount();
            for (n = 0; n < n5; ++n) {
                clazzArray[n4++] = clazzArray[n3++];
            }
            while (n4 < n3) {
                clazzArray[n4++] = null;
            }
        }
        return clazzArray;
    }
}

