/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ConstantPoolShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
ParameterInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private static final Object USED = new Object();
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        this.markConstant(programClass, programClass.u2thisClass);
        programClass.superClassConstantAccept(this);
        programClass.interfaceConstantsAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        int n = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        if (n < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = n;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        this.markConstant(programClass, programMember.u2nameIndex);
        this.markConstant(programClass, programMember.u2descriptorIndex);
        programMember.attributesAccept(programClass, this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.markAsUsed(constant);
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.markAsUsed(stringConstant);
        this.markConstant(clazz, stringConstant.u2stringIndex);
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.markAsUsed(invokeDynamicConstant);
        this.markConstant(clazz, invokeDynamicConstant.u2nameAndTypeIndex);
        clazz.attributesAccept(this);
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.markAsUsed(methodHandleConstant);
        this.markConstant(clazz, methodHandleConstant.u2referenceIndex);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.markAsUsed(refConstant);
        this.markConstant(clazz, refConstant.u2classIndex);
        this.markConstant(clazz, refConstant.u2nameAndTypeIndex);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.markAsUsed(classConstant);
        this.markConstant(clazz, classConstant.u2nameIndex);
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.markAsUsed(methodTypeConstant);
        this.markConstant(clazz, methodTypeConstant.u2descriptorIndex);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.markAsUsed(nameAndTypeConstant);
        this.markConstant(clazz, nameAndTypeConstant.u2nameIndex);
        this.markConstant(clazz, nameAndTypeConstant.u2descriptorIndex);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.markConstant(clazz, attribute.u2attributeNameIndex);
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        this.markConstant(clazz, bootstrapMethodsAttribute.u2attributeNameIndex);
        bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, this);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.markConstant(clazz, sourceFileAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceFileAttribute.u2sourceFileIndex);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.markConstant(clazz, sourceDirAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceDirAttribute.u2sourceDirIndex);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.markConstant(clazz, innerClassesAttribute.u2attributeNameIndex);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.markConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex);
        this.markConstant(clazz, enclosingMethodAttribute.u2classIndex);
        if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            this.markConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
        }
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.markConstant(clazz, signatureAttribute.u2attributeNameIndex);
        this.markConstant(clazz, signatureAttribute.u2signatureIndex);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.markConstant(clazz, constantValueAttribute.u2attributeNameIndex);
        this.markConstant(clazz, constantValueAttribute.u2constantValueIndex);
    }

    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        this.markConstant(clazz, methodParametersAttribute.u2attributeNameIndex);
        methodParametersAttribute.parametersAccept(clazz, method, this);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.markConstant(clazz, exceptionsAttribute.u2attributeNameIndex);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, this);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.markConstant(clazz, codeAttribute.u2attributeNameIndex);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.markConstant(clazz, stackMapAttribute.u2attributeNameIndex);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.markConstant(clazz, stackMapTableAttribute.u2attributeNameIndex);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.markConstant(clazz, localVariableTableAttribute.u2attributeNameIndex);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.markConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.markConstant(clazz, annotationsAttribute.u2attributeNameIndex);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.markConstant(clazz, parameterAnnotationsAttribute.u2attributeNameIndex);
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.markConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex);
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        this.markConstant(clazz, bootstrapMethodInfo.u2methodHandleIndex);
        bootstrapMethodInfo.methodArgumentsAccept(clazz, this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
        innerClassesInfo.innerNameConstantAccept(clazz, this);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (exceptionInfo.u2catchType != 0) {
            this.markConstant(clazz, exceptionInfo.u2catchType);
        }
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
        this.markConstant(clazz, objectType.u2classIndex);
    }

    public void visitParameterInfo(Clazz clazz, Method method, int n, ParameterInfo parameterInfo) {
        this.markConstant(clazz, parameterInfo.u2nameIndex);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.markConstant(clazz, localVariableInfo.u2nameIndex);
        this.markConstant(clazz, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markConstant(clazz, localVariableTypeInfo.u2nameIndex);
        this.markConstant(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.markConstant(clazz, annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        if (constantElementValue.u2elementNameIndex != 0) {
            this.markConstant(clazz, constantElementValue.u2elementNameIndex);
        }
        this.markConstant(clazz, constantElementValue.u2constantValueIndex);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (enumConstantElementValue.u2elementNameIndex != 0) {
            this.markConstant(clazz, enumConstantElementValue.u2elementNameIndex);
        }
        this.markConstant(clazz, enumConstantElementValue.u2typeNameIndex);
        this.markConstant(clazz, enumConstantElementValue.u2constantNameIndex);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        if (classElementValue.u2elementNameIndex != 0) {
            this.markConstant(clazz, classElementValue.u2elementNameIndex);
        }
        this.markConstant(clazz, classElementValue.u2classInfoIndex);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (annotationElementValue.u2elementNameIndex != 0) {
            this.markConstant(clazz, annotationElementValue.u2elementNameIndex);
        }
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (arrayElementValue.u2elementNameIndex != 0) {
            this.markConstant(clazz, arrayElementValue.u2elementNameIndex);
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.markConstant(clazz, constantInstruction.constantIndex);
    }

    private void markConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
    }

    private void markAsUsed(Constant constant) {
        constant.setVisitorInfo(USED);
    }

    private boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            this.constantIndexMap[i] = n2;
            Constant constant = constantArray[i];
            if (constant != null) {
                bl = this.isUsed(constant);
            }
            if (!bl) continue;
            constantArray[n2++] = constant;
        }
        Arrays.fill(constantArray, n2, n, null);
        return n2;
    }
}

