/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCollector;
import proguard.evaluation.value.ArrayReferenceValue;
import proguard.evaluation.value.DetailedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.ValueFactory;

public class TypedReferenceValue
extends ReferenceValue {
    private static final boolean DEBUG = false;
    protected final String type;
    protected final Clazz referencedClass;
    protected final boolean mayBeNull;

    public TypedReferenceValue(String string, Clazz clazz, boolean bl) {
        this.type = string;
        this.referencedClass = clazz;
        this.mayBeNull = bl;
    }

    public String getType() {
        return this.type;
    }

    public Clazz getReferencedClass() {
        return this.referencedClass;
    }

    public int isNull() {
        return this.type == null ? 1 : (this.mayBeNull ? 0 : -1);
    }

    public int instanceOf(String string, Clazz clazz) {
        String string2 = this.type;
        if (string2 == null) {
            return -1;
        }
        int n = ClassUtil.internalArrayTypeDimensionCount(string2);
        int n2 = ClassUtil.internalArrayTypeDimensionCount(string);
        int n3 = Math.min(n, n2);
        string2 = string2.substring(n3);
        string = string.substring(n3);
        if (n3 > 0 && (ClassUtil.isInternalPrimitiveType(string2.charAt(0)) || ClassUtil.isInternalPrimitiveType(string.charAt(0)))) {
            return !string2.equals(string) ? -1 : (this.mayBeNull ? 0 : 1);
        }
        if (n == n3) {
            string2 = ClassUtil.internalClassNameFromClassType(string2);
        }
        if (n2 == n3) {
            string = ClassUtil.internalClassNameFromClassType(string);
        }
        if (n > n2 && !ClassUtil.isInternalArrayInterfaceName(string)) {
            return -1;
        }
        if (n < n2 && !ClassUtil.isInternalArrayInterfaceName(string2)) {
            return -1;
        }
        if (this.mayBeNull) {
            return 0;
        }
        if (string2.equals(string) || "java/lang/Object".equals(string)) {
            return 1;
        }
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return 0;
        }
        return this.referencedClass != null && clazz != null && this.referencedClass.extendsOrImplements(clazz) ? 1 : 0;
    }

    public ReferenceValue generalizeMayBeNull(boolean bl) {
        return this.mayBeNull == bl ? this : new TypedReferenceValue(this.type, this.referencedClass, true);
    }

    public ReferenceValue referenceArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        return this.type == null ? ValueFactory.REFERENCE_VALUE_NULL : (!ClassUtil.isInternalArrayType(this.type) ? ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : valueFactory.createValue(this.type.substring(1), this.referencedClass, true).referenceValue());
    }

    public ReferenceValue generalize(ReferenceValue referenceValue) {
        return referenceValue.generalize(this);
    }

    public int equal(ReferenceValue referenceValue) {
        return referenceValue.equal(this);
    }

    public ReferenceValue generalize(TypedReferenceValue typedReferenceValue) {
        boolean bl;
        if (this.equals(typedReferenceValue)) {
            return this;
        }
        String string = this.type;
        String string2 = typedReferenceValue.type;
        if (string == null && string2 == null) {
            return ValueFactory.REFERENCE_VALUE_NULL;
        }
        if (string == null) {
            return typedReferenceValue.generalizeMayBeNull(true);
        }
        if (string2 == null) {
            return this.generalizeMayBeNull(true);
        }
        boolean bl2 = bl = this.mayBeNull || typedReferenceValue.mayBeNull;
        if (string.equals(string2)) {
            return TypedReferenceValue.typedReferenceValue(this, bl);
        }
        int n = ClassUtil.internalArrayTypeDimensionCount(string);
        int n2 = ClassUtil.internalArrayTypeDimensionCount(string2);
        int n3 = Math.min(n, n2);
        if (n == n2) {
            Clazz clazz = this.referencedClass;
            Clazz clazz2 = typedReferenceValue.referencedClass;
            if (clazz != null && clazz2 != null) {
                if (clazz.extendsOrImplements(clazz2)) {
                    return TypedReferenceValue.typedReferenceValue(typedReferenceValue, bl);
                }
                if (clazz2.extendsOrImplements(clazz)) {
                    return TypedReferenceValue.typedReferenceValue(this, bl);
                }
                HashSet hashSet = new HashSet();
                clazz.hierarchyAccept(false, true, true, false, new ClassCollector(hashSet));
                int n4 = hashSet.size();
                if (n4 == 0 && clazz.getSuperName() != null) {
                    throw new IllegalArgumentException("Can't find any super classes of [" + string + "] (not even immediate super class [" + clazz.getSuperName() + "])");
                }
                HashSet hashSet2 = new HashSet();
                clazz2.hierarchyAccept(false, true, true, false, new ClassCollector(hashSet2));
                int n5 = hashSet2.size();
                if (n5 == 0 && clazz2.getSuperName() != null) {
                    throw new IllegalArgumentException("Can't find any super classes of [" + string2 + "] (not even immediate super class [" + clazz2.getSuperName() + "])");
                }
                hashSet.retainAll(hashSet2);
                Clazz clazz3 = null;
                int n6 = -1;
                for (Clazz clazz4 : hashSet) {
                    int n7 = this.superClassCount(clazz4, hashSet);
                    if (n6 >= n7 && (n6 != n7 || clazz3 == null || clazz3.getName().compareTo(clazz4.getName()) <= 0)) continue;
                    clazz3 = clazz4;
                    n6 = n7;
                }
                if (clazz3 == null) {
                    throw new IllegalArgumentException("Can't find common super class of [" + string + "] (with " + n4 + " known super classes) and [" + string2 + "] (with " + n5 + " known super classes)");
                }
                return new TypedReferenceValue(n3 == 0 ? clazz3.getName() : ClassUtil.internalArrayTypeFromClassName(clazz3.getName(), n3), clazz3, bl);
            }
        } else if (n > n2) {
            if (ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(string2))) {
                return TypedReferenceValue.typedReferenceValue(typedReferenceValue, bl);
            }
        } else if (n < n2 && ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(string))) {
            return TypedReferenceValue.typedReferenceValue(this, bl);
        }
        if (n3 > 0 && ClassUtil.isInternalPrimitiveType(string2.charAt(n3)) || ClassUtil.isInternalPrimitiveType(string.charAt(n3))) {
            --n3;
        }
        return n3 == 0 ? (bl ? ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : ValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL) : new TypedReferenceValue(ClassUtil.internalArrayTypeFromClassName("java/lang/Object", n3), null, bl);
    }

    private static ReferenceValue typedReferenceValue(TypedReferenceValue typedReferenceValue, boolean bl) {
        return typedReferenceValue.getClass() == TypedReferenceValue.class ? typedReferenceValue.generalizeMayBeNull(bl) : new TypedReferenceValue(typedReferenceValue.type, typedReferenceValue.referencedClass, bl);
    }

    private int superClassCount(Clazz clazz, Set set) {
        int n = 0;
        for (Clazz clazz2 : set) {
            if (!clazz.extendsOrImplements(clazz2)) continue;
            ++n;
        }
        return n;
    }

    public int equal(TypedReferenceValue typedReferenceValue) {
        return this.type == null && typedReferenceValue.type == null ? 1 : 0;
    }

    public ReferenceValue generalize(IdentifiedReferenceValue identifiedReferenceValue) {
        return this.generalize((TypedReferenceValue)identifiedReferenceValue);
    }

    public int equal(IdentifiedReferenceValue identifiedReferenceValue) {
        return this.equal((TypedReferenceValue)identifiedReferenceValue);
    }

    public ReferenceValue generalize(ArrayReferenceValue arrayReferenceValue) {
        return this.generalize((TypedReferenceValue)arrayReferenceValue);
    }

    public int equal(ArrayReferenceValue arrayReferenceValue) {
        return this.equal((TypedReferenceValue)arrayReferenceValue);
    }

    public ReferenceValue generalize(IdentifiedArrayReferenceValue identifiedArrayReferenceValue) {
        return this.generalize((ArrayReferenceValue)identifiedArrayReferenceValue);
    }

    public int equal(IdentifiedArrayReferenceValue identifiedArrayReferenceValue) {
        return this.equal((ArrayReferenceValue)identifiedArrayReferenceValue);
    }

    public ReferenceValue generalize(DetailedArrayReferenceValue detailedArrayReferenceValue) {
        return this.generalize((IdentifiedArrayReferenceValue)detailedArrayReferenceValue);
    }

    public int equal(DetailedArrayReferenceValue detailedArrayReferenceValue) {
        return this.equal((IdentifiedArrayReferenceValue)detailedArrayReferenceValue);
    }

    public boolean isParticular() {
        return this.type == null;
    }

    public final String internalType() {
        return this.type == null ? "Ljava/lang/Object;" : (ClassUtil.isInternalArrayType(this.type) ? this.type : 'L' + this.type + ';');
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TypedReferenceValue typedReferenceValue = (TypedReferenceValue)object;
        return this.type == null ? typedReferenceValue.type == null : this.mayBeNull == typedReferenceValue.mayBeNull && this.type.equals(typedReferenceValue.type);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (this.type == null ? 0 : this.type.hashCode() ^ (this.mayBeNull ? 0 : 1));
    }

    public String toString() {
        return this.type == null ? "null" : this.type + (this.referencedClass == null ? "?" : "") + (this.mayBeNull ? "" : "!");
    }
}

