/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.KeepClassMemberChecker;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.EnumFieldReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class Initializer {
    private final Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = classPool2.size();
        WarningPrinter warningPrinter = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter2 = new WarningPrinter(System.out, this.configuration.note);
        new FullyQualifiedClassNameChecker(classPool, classPool2, warningPrinter).checkClassSpecifications(this.configuration.keep);
        new KeepClassMemberChecker(warningPrinter2).checkClassSpecifications(this.configuration.keep);
        ClassPool classPool3 = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningPrinter warningPrinter3 = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter4 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter3, null));
        classPool2.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, null, warningPrinter4));
        WarningPrinter warningPrinter5 = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter6 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassReferenceInitializer(classPool, classPool2, warningPrinter3, warningPrinter5, warningPrinter6, null));
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassPoolFiller(classPool3))));
            classPool3.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter3, null));
        }
        classPool.classesAccept(new AllAttributeVisitor(true, new AllElementValueVisitor(true, new EnumFieldReferenceInitializer())));
        WarningPrinter warningPrinter7 = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter8 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicClassReferenceInitializer(classPool, classPool2, warningPrinter7, null, warningPrinter8, this.createClassNoteExceptionMatcher(this.configuration.keep))))));
        WarningPrinter warningPrinter9 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicMemberReferenceInitializer(classPool, classPool2, warningPrinter9, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false))))));
        if (this.configuration.adaptClassStrings != null) {
            classPool.classesAccept(new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor(new StringReferenceInitializer(classPool, classPool2))));
        }
        WarningPrinter warningPrinter10 = new WarningPrinter(System.out, this.configuration.note);
        new DescriptorKeepChecker(classPool, classPool2, warningPrinter10).checkClassSpecifications(this.configuration.keep);
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool3))))));
            classPool3.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, null, warningPrinter4));
            classPool2.clear();
            classPool3.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2))), new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2)))))}));
        } else {
            classPool2.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, null, warningPrinter4));
        }
        classPool.classesAccept(new ClassSubHierarchyInitializer());
        classPool2.classesAccept(new ClassSubHierarchyInitializer());
        classPool.classesAccept(new StringSharer());
        classPool2.classesAccept(new StringSharer());
        int n11 = warningPrinter.getWarningCount();
        if (n11 > 0) {
            System.out.println("Note: there were " + n11 + " references to unknown classes.");
            System.out.println("      You should check your configuration for typos.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#unknownclass)");
        }
        if ((n9 = warningPrinter2.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n9 + " '-keepclassmembers' options that didn't specify class");
            System.out.println("      members. You should specify at least some class members or consider");
            System.out.println("      if you just need '-keep'.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#classmembers)");
        }
        if ((n8 = warningPrinter10.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n8 + " unkept descriptor classes in kept class members.");
            System.out.println("      You should consider explicitly keeping the mentioned classes");
            System.out.println("      (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#descriptorclass)");
        }
        if ((n7 = warningPrinter7.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n7 + " unresolved dynamic references to classes or interfaces.");
            System.out.println("      You should check if you need to specify additional program jars.");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclass)");
        }
        if ((n6 = warningPrinter8.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n6 + " class casts of dynamically created class instances.");
            System.out.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.out.println("      their implementations (using '-keep').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclasscast)");
        }
        if ((n5 = warningPrinter9.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n5 + " accesses to class members by means of introspection.");
            System.out.println("      You should consider explicitly keeping the mentioned class members");
            System.out.println("      (using '-keep' or '-keepclassmembers').");
            System.out.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#dynamicalclassmember)");
        }
        if ((n4 = warningPrinter3.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n4 + " unresolved references to classes or interfaces.");
            System.err.println("         You may need to add missing library jars or update their versions.");
            System.err.println("         If your code works fine without the missing classes, you can suppress");
            System.err.println("         the warnings with '-dontwarn' options.");
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedclass)");
        }
        if ((n3 = warningPrinter4.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n3 + " instances of library classes depending on program classes.");
            System.err.println("         You must avoid such dependencies, since the program classes will");
            System.err.println("         be processed, while the library classes will remain unchanged.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#dependency)");
        }
        if ((n2 = warningPrinter5.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n2 + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile the code.");
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedprogramclassmember)");
        }
        if ((n = warningPrinter6.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to library class members.");
            System.err.println("         You probably need to update the library versions.");
            if (!this.configuration.skipNonPublicLibraryClassMembers) {
                System.err.println("         Alternatively, you may have to specify the option ");
                System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
            }
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
            System.err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#unresolvedlibraryclassmember)");
        }
        if (!(n4 <= 0 && n3 <= 0 && n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            System.out.println("Note: You're ignoring all warnings!");
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + n10);
            System.out.println("  Final number of library classes:    " + classPool2.size());
        }
    }

    private StringMatcher createClassNoteExceptionMatcher(List list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                if (!keepClassSpecification.markClasses) continue;
                String string2 = keepClassSpecification.className;
                if (string2 != null) {
                    arrayList.add(string2);
                }
                if ((string = keepClassSpecification.extendsClassName) == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(arrayList);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List list, boolean bl) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                List list2;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                List list3 = list2 = bl ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (list2 == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    MemberSpecification memberSpecification = (MemberSpecification)list2.get(j);
                    String string = memberSpecification.name;
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
            if (arrayList.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(arrayList);
            }
        }
        return null;
    }
}

