/*
 * Decompiled with CFR 0.152.
 */
package com.license4j;

import com.license4j.License;
import com.license4j.LicenseValidator;
import com.license4j.ValidationStatus;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProductLicense {
    private String publicKey;
    private String internalHiddenString;
    private String productID;
    private String activationServer;
    private String licenseKey;
    private String licenseText;
    private String activatedLicenseText;
    private Properties properties = new Properties();
    private String trialLicenseKey;
    private String trialLicenseText;
    private String licenseFile;

    public ProductLicense(String fileToSaveLicense, String publicKey, String trialLicenseKey, String trialLicenseText, String internalHiddenString, String productID, String activationServer) {
        this.licenseFile = fileToSaveLicense;
        this.publicKey = publicKey;
        this.trialLicenseKey = trialLicenseKey;
        this.trialLicenseText = trialLicenseText;
        this.internalHiddenString = internalHiddenString;
        this.productID = productID;
        this.activationServer = activationServer;
        this.loadLicense();
    }

    public boolean validate() {
        License license = null;
        if (this.licenseKey != null) {
            license = this.validateLicenseKey();
        } else if (this.licenseText != null) {
            license = this.validateLicenseText();
        }
        if (license != null && license.getValidationStatus() == ValidationStatus.LICENSE_VALID) {
            if (license.isActivationRequired()) {
                License activatedLicense;
                if (this.activatedLicenseText != null && (activatedLicense = this.validateActivatedLicenseText()).getValidationStatus() == ValidationStatus.LICENSE_VALID) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public License getLicenseObject() {
        License license = null;
        if (this.licenseKey != null) {
            license = this.validateLicenseKey();
        } else if (this.licenseText != null) {
            license = this.validateLicenseText();
        }
        if (license != null && license.getValidationStatus() == ValidationStatus.LICENSE_VALID && license.isActivationRequired() && this.activatedLicenseText != null) {
            license = this.validateActivatedLicenseText();
        }
        return license;
    }

    public License validateLicenseKey() {
        License license = null;
        if (this.licenseKey != null) {
            license = LicenseValidator.validate((String)this.licenseKey, (String)this.publicKey, (String)this.internalHiddenString, null, null, (int)0);
        }
        return license;
    }

    public License validateLicenseText() {
        License license = null;
        if (this.licenseText != null) {
            license = LicenseValidator.validate((String)this.licenseText, (String)this.publicKey, (String)this.productID, null, null, null, null);
        }
        return license;
    }

    public License validateActivatedLicenseText() {
        License license = null;
        if (this.activatedLicenseText != null) {
            license = LicenseValidator.validate((String)this.activatedLicenseText, (String)this.publicKey, (String)this.productID, null, null, null, null);
        }
        return license;
    }

    public License activateLicense() {
        License license = null;
        if (this.licenseKey != null) {
            license = this.validateLicenseKey();
        } else if (this.licenseText != null) {
            license = this.validateLicenseText();
        }
        License activatedLicense = null;
        if (license != null && license.getValidationStatus() == ValidationStatus.LICENSE_VALID && license.isActivationRequired()) {
            activatedLicense = LicenseValidator.autoActivate((License)license, (String)this.activationServer);
        }
        return activatedLicense;
    }

    public boolean loadLicense() {
        try {
            this.properties.load(new FileInputStream(this.licenseFile));
            this.licenseKey = this.properties.getProperty("license-key");
            this.licenseText = this.properties.getProperty("license-text");
            this.activatedLicenseText = this.properties.getProperty("activated-license-text");
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ProductLicense.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean saveLicense() {
        try {
            if (this.licenseKey != null) {
                this.properties.setProperty("license-key", this.licenseKey);
            } else {
                this.properties.remove("license-key");
            }
            if (this.licenseText != null) {
                this.properties.setProperty("license-text", this.licenseText);
            } else {
                this.properties.remove("license-text");
            }
            if (this.activatedLicenseText != null) {
                this.properties.setProperty("activated-license-text", this.activatedLicenseText);
            } else {
                this.properties.remove("activated-license-text");
            }
            this.properties.store(new FileOutputStream(this.licenseFile, false), null);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(ProductLicense.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        this.licenseText = null;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
        this.licenseKey = null;
    }

    public String getActivatedLicenseText() {
        return this.activatedLicenseText;
    }

    public void setActivatedLicenseText(String activatedLicenseText) {
        this.activatedLicenseText = activatedLicenseText;
    }

    public String getTrialLicenseKey() {
        return this.trialLicenseKey;
    }

    public String getTrialLicenseText() {
        return this.trialLicenseText;
    }
}

