/*
 * Decompiled with CFR 0.152.
 */
package com.license4j;

import com.license4j.License;
import com.license4j.ProductLicense;
import com.license4j.UpperCaseDocumentFilter;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.AbstractDocument;

public class LicenseInputGUI
extends JDialog {
    private License license;
    private ProductLicense productLicense;
    private final JFileChooser jFileChooser;
    private ButtonGroup buttonGroup1;
    private JButton closejButton;
    private JRadioButton haveLicenseKeyjRadioButton;
    private JRadioButton haveLicenseTextjRadioButton;
    private JPanel jPanel1;
    private JTextField licenseFilejTextField;
    private JTextField licenseKeyjTextField;
    private JPanel mainjPanel;
    private JRadioButton startTrialjRadioButton;
    private JButton validatejButton;

    public LicenseInputGUI(Frame parent, boolean modal, ProductLicense productLicense) {
        super(parent, modal);
        this.setLookFeel();
        this.initComponents();
        this.productLicense = productLicense;
        this.setLocationRelativeTo(null);
        this.jFileChooser = new JFileChooser();
        this.jFileChooser.setMultiSelectionEnabled(false);
        this.jFileChooser.setFileSelectionMode(0);
        ((AbstractDocument)this.licenseKeyjTextField.getDocument()).setDocumentFilter(new UpperCaseDocumentFilter());
    }

    public License display() {
        super.setVisible(true);
        return this.license;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.mainjPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.haveLicenseKeyjRadioButton = new JRadioButton();
        this.haveLicenseTextjRadioButton = new JRadioButton();
        this.licenseKeyjTextField = new JTextField();
        this.licenseFilejTextField = new JTextField();
        this.startTrialjRadioButton = new JRadioButton();
        this.validatejButton = new JButton();
        this.closejButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("License Validation");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Licensing"));
        this.buttonGroup1.add(this.haveLicenseKeyjRadioButton);
        this.haveLicenseKeyjRadioButton.setText("I have a license key:");
        this.haveLicenseKeyjRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LicenseInputGUI.this.haveLicenseKeyjRadioButtonItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.haveLicenseTextjRadioButton);
        this.haveLicenseTextjRadioButton.setText("I have a license text:");
        this.haveLicenseTextjRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LicenseInputGUI.this.haveLicenseTextjRadioButtonItemStateChanged(evt);
            }
        });
        this.licenseKeyjTextField.setEnabled(false);
        this.licenseFilejTextField.setEditable(false);
        this.licenseFilejTextField.setEnabled(false);
        this.licenseFilejTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LicenseInputGUI.this.licenseFilejTextFieldMouseClicked(evt);
            }
        });
        this.buttonGroup1.add(this.startTrialjRadioButton);
        this.startTrialjRadioButton.setSelected(true);
        this.startTrialjRadioButton.setText("I want to use trial license");
        this.startTrialjRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LicenseInputGUI.this.startTrialjRadioButtonItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startTrialjRadioButton).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.haveLicenseTextjRadioButton).addComponent(this.haveLicenseKeyjRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.licenseKeyjTextField, -1, 259, Short.MAX_VALUE).addComponent(this.licenseFilejTextField)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.startTrialjRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.haveLicenseKeyjRadioButton).addComponent(this.licenseKeyjTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.haveLicenseTextjRadioButton).addComponent(this.licenseFilejTextField, -2, -1, -2)).addGap(15, 15, 15)));
        jPanel1Layout.linkSize(1, this.licenseFilejTextField, this.licenseKeyjTextField);
        this.validatejButton.setText("Validate");
        this.validatejButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInputGUI.this.validatejButtonActionPerformed(evt);
            }
        });
        this.closejButton.setText("Close");
        this.closejButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInputGUI.this.closejButtonActionPerformed(evt);
            }
        });
        GroupLayout mainjPanelLayout = new GroupLayout(this.mainjPanel);
        this.mainjPanel.setLayout(mainjPanelLayout);
        mainjPanelLayout.setHorizontalGroup(mainjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainjPanelLayout.createSequentialGroup().addGroup(mainjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainjPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.validatejButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closejButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainjPanelLayout.linkSize(0, this.closejButton, this.validatejButton);
        mainjPanelLayout.setVerticalGroup(mainjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainjPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(mainjPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validatejButton).addComponent(this.closejButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainjPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainjPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatejButtonActionPerformed(ActionEvent evt) {
        if (this.startTrialjRadioButton.isSelected()) {
            if (this.productLicense.getTrialLicenseKey() != null) {
                this.productLicense.setLicenseKey(this.productLicense.getTrialLicenseKey());
                this.license = this.productLicense.validateLicenseKey();
            } else if (this.productLicense.getTrialLicenseText() != null) {
                this.productLicense.setLicenseText(this.productLicense.getTrialLicenseText());
                this.license = this.productLicense.validateLicenseKey();
            }
        } else if (this.haveLicenseKeyjRadioButton.isSelected()) {
            this.productLicense.setLicenseKey(this.licenseKeyjTextField.getText().trim());
            this.license = this.productLicense.validateLicenseKey();
        } else if (this.haveLicenseTextjRadioButton.isSelected()) {
            StringBuilder buf = new StringBuilder();
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(this.licenseFilejTextField.getText()));
                while ((line = br.readLine()) != null) {
                    buf.append(line);
                    buf.append("\n");
                }
                this.productLicense.setLicenseText(buf.toString());
                this.license = this.productLicense.validateLicenseText();
            }
            catch (IOException ex) {
                Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.dispose();
    }

    private void startTrialjRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.startTrialjRadioButton.isSelected()) {
            this.licenseKeyjTextField.setEnabled(false);
            this.licenseFilejTextField.setEnabled(false);
            this.licenseKeyjTextField.setText("");
            this.licenseFilejTextField.setText("");
        }
    }

    private void haveLicenseKeyjRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.haveLicenseKeyjRadioButton.isSelected()) {
            this.licenseKeyjTextField.setEnabled(true);
            this.licenseFilejTextField.setEnabled(false);
            this.licenseKeyjTextField.setText("");
            this.licenseFilejTextField.setText("");
        }
    }

    private void haveLicenseTextjRadioButtonItemStateChanged(ItemEvent evt) {
        if (this.haveLicenseTextjRadioButton.isSelected()) {
            this.licenseKeyjTextField.setEnabled(false);
            this.licenseFilejTextField.setEnabled(true);
            this.licenseKeyjTextField.setText("");
            this.licenseFilejTextField.setForeground(Color.DARK_GRAY);
            this.licenseFilejTextField.setText("double click here to select license file");
        }
    }

    private void licenseFilejTextFieldMouseClicked(MouseEvent evt) {
        int s;
        if (this.haveLicenseTextjRadioButton.isSelected() && evt.getClickCount() == 2 && (s = this.jFileChooser.showOpenDialog(this)) == 0) {
            this.licenseFilejTextField.setForeground(this.licenseKeyjTextField.getForeground());
            this.licenseFilejTextField.setText(this.jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void closejButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void setLookFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LicenseInputGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

