/*
 * Decompiled with CFR 0.152.
 */
package com.license4j;

import com.license4j.License;
import com.license4j.LicenseInputGUI;
import com.license4j.ProductLicense;
import com.license4j.ProgressDialog;
import com.license4j.ValidationStatus;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LicenseInformationGUI
extends JDialog {
    private ProductLicense productLicense;
    private boolean returnValue;
    private final JFileChooser jFileChooser;
    private JButton activatejButton;
    private JButton changeLicensejButton;
    private JButton closejButton;
    private JTextField companyjTextField;
    private JTextField emailjTextField;
    private JTextField expirationDatejTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField licenseStatusjTextField;
    private JTextField licensejTextField;
    private JTextField namejTextField;
    private JPanel step1jPanel;

    public LicenseInformationGUI(Frame parent, boolean modal, ProductLicense productLicense) {
        super(parent, modal);
        this.setLookFeel();
        this.initComponents();
        this.productLicense = productLicense;
        this.setLocationRelativeTo(null);
        this.jFileChooser = new JFileChooser();
        this.jFileChooser.setMultiSelectionEnabled(false);
        this.jFileChooser.setFileSelectionMode(0);
    }

    public boolean check() {
        if (this.productLicense.validate()) {
            this.returnValue = true;
        } else {
            this.display();
        }
        return this.returnValue;
    }

    public void display() {
        this.updateGUI(this.productLicense.getLicenseObject());
        super.setVisible(true);
        this.productLicense.saveLicense();
    }

    private void updateGUI(License license) {
        this.licensejTextField.setText("");
        this.licenseStatusjTextField.setText("");
        this.expirationDatejTextField.setText("");
        this.namejTextField.setText("");
        this.emailjTextField.setText("");
        this.companyjTextField.setText("");
        this.licenseStatusjTextField.setDisabledTextColor(this.licensejTextField.getDisabledTextColor());
        this.expirationDatejTextField.setDisabledTextColor(this.licensejTextField.getDisabledTextColor());
        if (license != null) {
            if (license.getLicenseKey() != null) {
                if (this.productLicense.getLicenseKey() == this.productLicense.getTrialLicenseKey()) {
                    this.licensejTextField.setText("XXXXX-XXXXX-XXXXX-XXXXX" + license.getLicenseKey().getTheKey().substring(license.getLicenseKey().getTheKey().lastIndexOf("-"), license.getLicenseKey().getTheKey().length()) + " TRIAL");
                } else {
                    this.licensejTextField.setText("XXXXX-XXXXX-XXXXX-XXXXX" + license.getLicenseKey().getTheKey().substring(license.getLicenseKey().getTheKey().lastIndexOf("-"), license.getLicenseKey().getTheKey().length()));
                }
            } else {
                if (license.getLicenseText().getLicenseExpireDate() != null) {
                    this.expirationDatejTextField.setText(license.getLicenseText().getLicenseExpireDate().toString());
                }
                this.licensejTextField.setText("License Text (ID: " + license.getLicenseText().getLicenseID() + ")");
                this.namejTextField.setText(license.getLicenseText().getUserFullName());
                this.emailjTextField.setText(license.getLicenseText().getUserEMail());
                this.companyjTextField.setText(license.getLicenseText().getUserCompany());
            }
            this.licenseStatusjTextField.setText(license.getValidationStatus().toString());
            if (license.getValidationStatus() != ValidationStatus.LICENSE_VALID) {
                this.licenseStatusjTextField.setDisabledTextColor(Color.RED);
            }
            if (license.isActivationRequired()) {
                this.licenseStatusjTextField.setText(this.licenseStatusjTextField.getText() + " - ACTIVATION REQUIRED");
                this.expirationDatejTextField.setText(license.getLicenseActivationDaysRemaining(null) + " days left for activation");
                this.licenseStatusjTextField.setDisabledTextColor(Color.RED);
                this.activatejButton.setEnabled(true);
                if (license.getLicenseActivationDaysRemaining(null) <= 0) {
                    this.returnValue = false;
                    this.expirationDatejTextField.setDisabledTextColor(Color.RED);
                }
            } else {
                this.activatejButton.setEnabled(false);
            }
            if (license.isActivationCompleted()) {
                this.licenseStatusjTextField.setText(this.licenseStatusjTextField.getText() + " - ACTIVATION COMPLETED");
                this.activatejButton.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.step1jPanel = new JPanel();
        this.closejButton = new JButton();
        this.activatejButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.licensejTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.expirationDatejTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.licenseStatusjTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.emailjTextField = new JTextField();
        this.companyjTextField = new JTextField();
        this.namejTextField = new JTextField();
        this.changeLicensejButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("License Validation");
        this.closejButton.setText("Close");
        this.closejButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInformationGUI.this.closejButtonActionPerformed(evt);
            }
        });
        this.activatejButton.setText("Activate");
        this.activatejButton.setEnabled(false);
        this.activatejButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInformationGUI.this.activatejButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("License Information"));
        this.jLabel1.setText("License:");
        this.licensejTextField.setFont(new Font("Verdana", 0, 10));
        this.licensejTextField.setEnabled(false);
        this.jLabel2.setText("Expiration Date:");
        this.expirationDatejTextField.setFont(new Font("Verdana", 0, 10));
        this.expirationDatejTextField.setEnabled(false);
        this.jLabel6.setText("License Status:");
        this.licenseStatusjTextField.setFont(new Font("Verdana", 0, 10));
        this.licenseStatusjTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel2, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.licenseStatusjTextField).addComponent(this.licensejTextField).addComponent(this.expirationDatejTextField, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel6);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.licensejTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.licenseStatusjTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expirationDatejTextField, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Licensee Information"));
        this.jLabel3.setText("Name:");
        this.jLabel4.setText("E-mail:");
        this.jLabel5.setText("Company:");
        this.emailjTextField.setFont(new Font("Verdana", 0, 10));
        this.emailjTextField.setEnabled(false);
        this.companyjTextField.setFont(new Font("Verdana", 0, 10));
        this.companyjTextField.setEnabled(false);
        this.namejTextField.setFont(new Font("Verdana", 0, 10));
        this.namejTextField.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel3, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.emailjTextField).addComponent(this.namejTextField).addComponent(this.companyjTextField)).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jLabel3, this.jLabel4, this.jLabel5);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.namejTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.emailjTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.companyjTextField, -2, -1, -2)).addContainerGap(15, Short.MAX_VALUE)));
        this.changeLicensejButton.setText("Change License");
        this.changeLicensejButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInformationGUI.this.changeLicensejButtonActionPerformed(evt);
            }
        });
        GroupLayout step1jPanelLayout = new GroupLayout(this.step1jPanel);
        this.step1jPanel.setLayout(step1jPanelLayout);
        step1jPanelLayout.setHorizontalGroup(step1jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1jPanelLayout.createSequentialGroup().addContainerGap().addGroup(step1jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(step1jPanelLayout.createSequentialGroup().addComponent(this.activatejButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 222, Short.MAX_VALUE).addComponent(this.changeLicensejButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closejButton, -2, 75, -2)).addGroup(step1jPanelLayout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        step1jPanelLayout.setVerticalGroup(step1jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, step1jPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(step1jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closejButton).addComponent(this.activatejButton).addComponent(this.changeLicensejButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.step1jPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.step1jPanel, -2, -1, -2));
        this.pack();
    }

    private void closejButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void activatejButtonActionPerformed(ActionEvent evt) {
        final ProgressDialog progress = new ProgressDialog(null, true);
        SwingWorker worker = new SwingWorker(){
            License license = null;

            @Override
            protected void done() {
                progress.setVisible(false);
                switch (this.license.getActivationStatus()) {
                    case ACTIVATION_COMPLETED: {
                        LicenseInformationGUI.this.productLicense.setActivatedLicenseText(this.license.getLicenseString());
                        LicenseInformationGUI.this.updateGUI(this.license);
                        if (this.license.getValidationStatus() == ValidationStatus.LICENSE_VALID) {
                            LicenseInformationGUI.this.returnValue = true;
                        } else {
                            LicenseInformationGUI.this.returnValue = false;
                        }
                        JOptionPane.showMessageDialog(null, this.license.getActivationStatus(), "License Activation OK", 1);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(null, this.license.getActivationStatus(), "License Activation Error", 0);
                    }
                }
            }

            protected Object doInBackground() {
                this.license = LicenseInformationGUI.this.productLicense.activateLicense();
                return null;
            }
        };
        worker.execute();
        progress.setVisible(true);
    }

    private void changeLicensejButtonActionPerformed(ActionEvent evt) {
        LicenseInputGUI licenseInputGUI = new LicenseInputGUI(null, true, this.productLicense);
        License license = licenseInputGUI.display();
        if (license != null) {
            switch (license.getValidationStatus()) {
                case LICENSE_VALID: {
                    this.returnValue = true;
                    this.productLicense.setActivatedLicenseText(null);
                    this.updateGUI(license);
                    JOptionPane.showMessageDialog(null, license.getValidationStatus(), "License OK", 1);
                    break;
                }
                default: {
                    this.returnValue = false;
                    JOptionPane.showMessageDialog(null, license.getValidationStatus(), "License Error", 0);
                }
            }
        }
    }

    private void setLookFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(LicenseInformationGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(LicenseInformationGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(LicenseInformationGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LicenseInformationGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

