/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.plaf.GlobaliskPanelUI;
import com.globalisk.util.Dialogs;
import com.globalisk.util.Lang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WizardDialog
extends JPanel {
    public JDialog dial;
    JFrame owner;
    Image iconImage;
    String title;
    public JPanel contents = new JPanel(new GridLayout(1, 0));
    public ArrayList<Form> forms = new ArrayList();
    public JButton backButton = new JButton(new AbstractAction("  < " + Lang.get("Back") + "  "){

        public void actionPerformed(ActionEvent e) {
            WizardDialog.this.back();
        }
    });
    public JButton nextButton = new JButton(new AbstractAction("  " + Lang.get("Next") + " >  "){

        public void actionPerformed(ActionEvent e) {
            WizardDialog.this.next();
        }
    });
    public JButton cancelButton = new JButton(new AbstractAction("  " + Lang.get("Cancel") + "  "){

        public void actionPerformed(ActionEvent e) {
            WizardDialog.this.cancel();
        }
    });
    int currentPanel = -1;
    boolean finish = false;
    public static int fontAscent = 0;
    WindowListener listener;

    public WizardDialog(JFrame owner, Image iconImage, String title, WindowListener listener) {
        this.owner = owner;
        this.iconImage = iconImage;
        this.title = title;
        this.listener = listener;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WizardDialog.this.init();
            }
        });
    }

    public void finish() {
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public void setFinished(boolean b) {
        this.finish = b;
        if (b) {
            this.nextButton.setText("  " + Lang.get("Finish") + "  ");
        } else {
            this.nextButton.setText("  " + Lang.get("Next") + " >  ");
        }
    }

    public void addForm(Form p) {
        this.forms.add(p);
        if (this.currentPanel < 0) {
            this.next(0);
        }
    }

    private void back() {
        this.unInit();
        this.contents.removeAll();
        Form form = this.forms.get(--this.currentPanel);
        this.contents.add(form);
        this.contents.updateUI();
        this.updateButtonState(0);
        form.initForm();
    }

    private void unInit() {
        Form o;
        if (this.currentPanel > -1 && (o = this.forms.get(this.currentPanel)) != null) {
            o.unInitForm();
        }
    }

    private void next() {
        this.next(1);
    }

    private void next(int adj) {
        if (this.finish) {
            this.finish();
        } else {
            this.unInit();
            this.contents.removeAll();
            Form form = this.forms.get(++this.currentPanel);
            this.contents.add(form);
            this.contents.updateUI();
            this.updateButtonState(adj);
            form.initForm();
        }
    }

    private void updateButtonState(int adj) {
        if (this.currentPanel > 0) {
            this.backButton.setEnabled(true);
        } else {
            this.backButton.setEnabled(false);
        }
        if (this.currentPanel < this.forms.size() - adj) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
    }

    protected void cancel() {
        this.dial.dispose();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        FontMetrics fm = this.contents.getFontMetrics(this.contents.getFont());
        fontAscent = fm.getAscent();
        this.backButton.setEnabled(false);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.backButton);
        buttons.add(this.nextButton);
        buttons.add(Box.createHorizontalStrut(fm.getAscent() / 2));
        buttons.add(this.cancelButton);
        int pad = (int)((double)fontAscent / 1.74);
        buttons.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        this.contents.setBorder(BorderFactory.createEmptyBorder(fontAscent, fontAscent, fontAscent, fontAscent));
        this.contents.setOpaque(false);
        buttons.setOpaque(false);
        GlobaliskPanelUI.applyBackgroundGradient(this);
        this.add((Component)this.contents, "Center");
        this.add((Component)buttons, "South");
        this.dial = new JDialog(this.owner);
        if (this.listener != null) {
            this.dial.addWindowListener(this.listener);
        }
        this.dial.setContentPane(this);
        if (this.iconImage != null) {
            this.dial.setIconImage(this.iconImage);
        }
        this.dial.setTitle(this.title);
        this.dial.setResizable(false);
        this.dial.pack();
        this.dial.setSize(new Dimension(fm.getAscent() * 34, fm.getAscent() * 26));
        Dialogs.centerDialogInAvailableSpace(this.dial, true);
        this.dial.setVisible(true);
        this.dial.toFront();
        this.dial.requestFocusInWindow();
    }

    public static class Form
    extends JPanel {
        public Form() {
            this.setOpaque(false);
        }

        public Form(LayoutManager l) {
            super(l);
        }

        public void initForm() {
        }

        public void unInitForm() {
        }
    }
}

