/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.GlobaliskPanelUI;
import com.globalisk.util.Dialogs;
import com.globalisk.util.Lang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class TipOfTheDayDialog
extends JPanel {
    static App app;
    JDialog dial;
    JScrollPane sp;
    JCheckBox check;
    JButton previousButton;
    JButton nextButton;
    static JButton currentButton;
    OurEditorPane editorPane = new OurEditorPane();
    Image tipIcon;
    String[] tips;
    int i;
    Image dialogIcon;
    boolean showTipsBool;
    Frame owner;
    public static int ICON_MARG;
    public static int ICON_HEIGHT;

    public TipOfTheDayDialog(Frame owner, String[] tips, App app, Image dialogIcon, Image tipIcon, boolean showTipsBool) {
        this.tips = tips;
        this.tipIcon = tipIcon;
        TipOfTheDayDialog.app = app;
        this.dialogIcon = dialogIcon;
        this.showTipsBool = showTipsBool;
        this.owner = owner;
        this.preinit();
    }

    private void preinit() {
        InitDialog id = new InitDialog();
        id.start();
    }

    private void init() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.i = (int)(Math.random() * (double)this.tips.length);
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.setLayout(new BorderLayout());
        this.editorPane.setPreferredSize(new Dimension(fm.getAscent() * 24, fm.getAscent() * 18));
        JPanel editorPanel = new JPanel(new BorderLayout());
        GlobaliskPanelUI.applyBackgroundGradient(editorPanel);
        editorPanel.setBorder(BorderFactory.createEmptyBorder(17, 14, 14, 14));
        this.sp = new JScrollPane(this.editorPane);
        editorPanel.add((Component)this.sp, "Center");
        this.add((Component)editorPanel, "Center");
        this.previousButton = new JButton(new AbstractAction("< " + Lang.get("Previous")){

            public void actionPerformed(ActionEvent e) {
                TipOfTheDayDialog.this.showPrevious();
            }
        });
        this.previousButton.setMnemonic('P');
        this.previousButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TipOfTheDayDialog.this.showPrevious();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.nextButton = new JButton(new AbstractAction(Lang.get("Next") + " >"){

            public void actionPerformed(ActionEvent e) {
                TipOfTheDayDialog.this.showNext();
            }
        });
        this.nextButton.setMnemonic('N');
        this.nextButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TipOfTheDayDialog.this.showNext();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JButton closeButton = new JButton(new AbstractAction(Lang.get("Close")){

            public void actionPerformed(ActionEvent e) {
                TipOfTheDayDialog.this.dial.dispose();
            }
        });
        closeButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TipOfTheDayDialog.this.dial.dispose();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(Box.createHorizontalStrut(11));
        buttons.add(this.previousButton);
        buttons.add(this.nextButton);
        buttons.add(Box.createHorizontalStrut(fm.getAscent() / 2));
        buttons.add(closeButton);
        this.check = new JCheckBox(new AbstractAction(Lang.get("Show tips at startup")){

            public void actionPerformed(ActionEvent e) {
                app.showTipsAtStartup(TipOfTheDayDialog.this.check.isSelected());
            }
        });
        this.check.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TipOfTheDayDialog.this.check.setSelected(!TipOfTheDayDialog.this.check.isSelected());
                    app.showTipsAtStartup(TipOfTheDayDialog.this.check.isSelected());
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.check.setMnemonic('S');
        this.check.setSelected(this.showTipsBool);
        JPanel navPanel = new JPanel(new BorderLayout());
        navPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 9, 9));
        navPanel.add((Component)this.check, "West");
        navPanel.add((Component)buttons, "East");
        this.add((Component)navPanel, "South");
        this.dial = new JDialog(this.owner);
        this.dial.setContentPane(this);
        if (this.dialogIcon != null) {
            this.dial.setIconImage(this.dialogIcon);
        }
        this.dial.setTitle(Lang.get("Tip of the Day"));
        this.dial.setResizable(false);
        this.dial.pack();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TipOfTheDayDialog.this.showNext();
            }
        });
        this.dial.toFront();
        this.dial.requestFocusInWindow();
        this.nextButton.requestFocusInWindow();
        Dialogs.centerDialogInAvailableSpace(this.dial, true);
        this.dial.setVisible(true);
    }

    private void showPrevious() {
        --this.i;
        if (this.i < 0) {
            this.i = this.tips.length - 1;
        }
        this.showBlurb();
        currentButton = this.previousButton;
    }

    private void showNext() {
        ++this.i;
        if (this.i >= this.tips.length) {
            this.i = 0;
        }
        this.showBlurb();
        currentButton = this.nextButton;
    }

    private void showBlurb() {
        int marg = this.tipIcon.getHeight(this) / 2 + 4;
        if (ICON_MARG > 0) {
            marg = ICON_MARG;
        }
        int pad = marg / 4;
        int pad2 = (int)((double)pad * 0.88);
        int height = this.tipIcon.getHeight(this) + 2;
        if (ICON_HEIGHT > 0) {
            height = ICON_HEIGHT;
        }
        this.editorPane.setText("<html><div style='color: #" + GlobaliskLookAndFeel.textForegroundHexCol + "; font-family: Arial; font-size: 110%; font-weight: bold; " + "margin-left: " + marg + "px; " + "padding-left: " + marg + "px; height: " + height + "px; padding-top: " + pad + "px; margin-top: " + pad + "px; padding-bottom: 5px;'>" + Lang.get("Did you know...") + "</div><div style='color: #" + GlobaliskLookAndFeel.textForegroundHexCol + "; font-family: Arial; padding: " + pad2 + "px; margin: " + pad2 + "px;'>" + this.tips[this.i] + "</div></html>");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                TipOfTheDayDialog.this.dial.toFront();
                TipOfTheDayDialog.this.dial.requestFocusInWindow();
                TipOfTheDayDialog.this.sp.getVerticalScrollBar().setValue(0);
                currentButton.requestFocusInWindow();
            }
        });
    }

    static {
        ICON_MARG = 0;
        ICON_HEIGHT = 0;
    }

    class OurEditorPane
    extends JEditorPane {
        OurEditorPane() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(TipOfTheDayDialog.this.tipIcon, 13, 12, this);
        }
    }

    class InitDialog
    extends Thread {
        InitDialog() {
        }

        public void run() {
            TipOfTheDayDialog.this.init();
        }
    }

    public static interface App {
        public void showTipsAtStartup(boolean var1);
    }
}

