/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.Dialogs;
import com.globalisk.util.Files;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;

public class SystemOutputFrame
extends JFrame
implements KeyListener {
    private static String fileName;
    private TextArea text = new TextArea();
    private PrintStream stream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
    public static SystemOutputFrame outputFrame;
    public static boolean aborted;

    public static void initOutput(String title) {
        outputFrame = new SystemOutputFrame(null, 800, 600, 1, title);
    }

    public static void initOutput(String title, String logFilename) {
        outputFrame = new SystemOutputFrame(logFilename, 800, 600, 1, title);
    }

    public static void showOutput() {
        outputFrame.setVisible(true);
        outputFrame.toFront();
        outputFrame.requestFocusInWindow();
    }

    public static void hideOutput() {
        outputFrame.setVisible(false);
    }

    public static void toggleOutput() {
        if (outputFrame.isVisible()) {
            SystemOutputFrame.hideOutput();
        } else {
            SystemOutputFrame.showOutput();
        }
    }

    public SystemOutputFrame(String fileName, int width, int height, int closeOp, String title) {
        this.init(fileName, width, height, closeOp, title);
    }

    public SystemOutputFrame(int width, int height, int closeOp, String title) {
        this.init(fileName, width, height, closeOp, title);
    }

    private void init(String fileName, int width, int height, int closeOp, String title) {
        SystemOutputFrame.fileName = fileName;
        if (fileName != null) {
            Files.writeFile(fileName, "");
        }
        this.text.addKeyListener(this);
        this.text.setForeground(Color.BLACK);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.text);
        this.setSize(width, height);
        this.setTitle(title);
        Dialogs.centerFrameInAvailableSpace(this);
        System.setOut(this.stream);
        System.setErr(this.stream);
        this.setDefaultCloseOperation(closeOp);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            aborted = !aborted;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    static {
        aborted = false;
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            if (!aborted) {
                this.writeLog(new String(b));
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (!aborted) {
                this.writeLog(new String(b, off, len));
            }
        }

        private void writeLog(String str) throws IOException {
            SystemOutputFrame.this.text.append(str);
            if (fileName != null) {
                FileWriter fw = new FileWriter(fileName, true);
                fw.write(str);
                fw.close();
            }
        }
    }
}

