/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.GlobaliskPanelUI;
import com.globalisk.util.Dialogs;
import com.globalisk.util.Files;
import com.globalisk.util.Lang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SuppressibleMessageDialog
extends Thread {
    public JDialog dial = new JDialog();
    int width;
    int height;
    String checkBoxLabel = Lang.get("Don't show this message in the future");
    String dialogTitle = "";
    String messageText = "";
    Image dialogIcon;
    JCheckBox chk;
    String stateFile;
    String okButtonText = " " + Lang.get("OK") + " ";

    public SuppressibleMessageDialog(String stateFile, int width, int height, Image dialogIcon, String dialogTitle, String messageText, String checkBoxLabel, String okButtonText) {
        this.init(stateFile, width, height, dialogIcon, dialogTitle, messageText, checkBoxLabel, okButtonText);
    }

    public SuppressibleMessageDialog(String stateFile, int width, int height, Image dialogIcon, String dialogTitle, String messageText, String checkBoxLabel) {
        this.init(stateFile, width, height, dialogIcon, dialogTitle, messageText, checkBoxLabel, this.okButtonText);
    }

    public SuppressibleMessageDialog(String stateFile, int width, int height, Image dialogIcon, String dialogTitle, String messageText) {
        this.init(stateFile, width, height, dialogIcon, dialogTitle, messageText, this.checkBoxLabel, this.okButtonText);
    }

    private void init(String stateFile, int width, int height, Image dialogIcon, String dialogTitle, String messageText, String checkBoxLabel, String okButtonText) {
        this.stateFile = stateFile;
        this.width = width;
        this.height = height;
        this.dialogIcon = dialogIcon;
        this.dialogTitle = dialogTitle;
        this.messageText = messageText;
        this.checkBoxLabel = checkBoxLabel;
        this.okButtonText = okButtonText;
        if (!new File(stateFile).exists()) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        JPanel p = new JPanel(new BorderLayout());
        GlobaliskPanelUI.applyBackgroundGradient(p);
        try {
            JEditorPane msg = new JEditorPane();
            msg.setOpaque(false);
            msg.setContentType("text/html");
            msg.setEditable(false);
            msg.setOpaque(false);
            msg.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            msg.setPreferredSize(new Dimension(this.width, this.height - 120));
            msg.setText("<html><body style='margin: 0px; padding: 0px;'><div style='font-family: Arial; padding: 10px; color: " + GlobaliskLookAndFeel.foregroundHexCol + "'>" + this.messageText + "</body></html>");
            p.add((Component)msg, "Center");
            JPanel btns = new JPanel();
            btns.setOpaque(false);
            btns.setBorder(BorderFactory.createEmptyBorder(4, 12, 4, 12));
            btns.setLayout(new BorderLayout());
            this.chk = new JCheckBox(this.checkBoxLabel);
            this.chk.setBorder(BorderFactory.createEmptyBorder(0, 2, 16, 2));
            JButton btn = new JButton(new AbstractAction(this.okButtonText){

                public void actionPerformed(ActionEvent e) {
                    if (SuppressibleMessageDialog.this.chk.isSelected()) {
                        Files.writeFile(SuppressibleMessageDialog.this.stateFile, "");
                    }
                    SuppressibleMessageDialog.this.dial.dispose();
                }
            });
            JPanel sp = new JPanel(new FlowLayout(1));
            sp.setOpaque(false);
            sp.add(btn);
            btns.add((Component)this.chk, "North");
            btns.add((Component)sp, "South");
            p.add((Component)btns, "South");
            this.dial.setContentPane(p);
            this.dial.setSize(this.width, this.height);
            this.dial.pack();
            this.dial.setIconImage(this.dialogIcon);
            Dialogs.centerDialogInAvailableSpace(this.dial);
            this.dial.setTitle(this.dialogTitle);
            this.dial.setAlwaysOnTop(true);
            this.dial.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Dialogs.alert(e.getMessage());
        }
    }
}

