/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class RunSystemCommandThreaded
extends Thread {
    String command;
    int wait = 0;
    String[] args;

    public RunSystemCommandThreaded(String command) {
        this.runCommand(command);
    }

    public RunSystemCommandThreaded(String command, int wait) {
        this.wait = wait;
        this.runCommand(command);
    }

    public RunSystemCommandThreaded(String command, int wait, String[] args) {
        this.wait = wait;
        this.args = args;
        this.runCommand(command);
    }

    public RunSystemCommandThreaded(String[] args) {
        this.init(args, 0);
    }

    public RunSystemCommandThreaded(String[] args, int wait) {
        this.init(args, wait);
    }

    private void init(String[] args, int wait) {
        this.args = args;
        this.wait = wait;
        for (String s : args) {
            System.out.println("->" + s);
        }
    }

    private void runCommand(String cmd) {
        this.command = cmd;
        this.start();
    }

    public void run() {
        try {
            if (this.wait > 0) {
                RunSystemCommandThreaded.sleep(this.wait);
            }
            String sin = null;
            Process p = Runtime.getRuntime().exec(this.command, this.args);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((sin = stdInput.readLine()) != null) {
                System.out.println(sin);
            }
            while ((sin = stdError.readLine()) != null) {
                System.out.println(sin);
            }
        }
        catch (Exception e) {
            System.out.println("Error running system command: ");
            e.printStackTrace(System.err);
        }
    }
}

