/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.GlobaliskPanelUI;
import com.globalisk.util.ColorChooserDialog;
import com.globalisk.util.Dialogs;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.JShadowLabel;
import com.globalisk.util.Lang;
import com.globalisk.util.Options;
import com.globalisk.util.OptionsApp;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class OptionsDialog
extends JPanel
implements ActionListener,
WindowListener {
    public static int TEXT_HEIGHT = 24;
    public JFrame frame;
    JTabbedPane main;
    JPanel currentGroup = null;
    JPanel currentRow = null;
    Font bold = Lang.getInternationalizedFont(new Font("Arial", 1, 13));
    Font nonBold = Lang.getInternationalizedFont(new Font("Arial", 0, 13));
    public JButton ok;
    public Options opts;
    protected Options savedOpts;
    HashMap<String, JSpinner> spinners = new HashMap();
    HashMap<String, JComboBox> comboboxes = new HashMap();
    HashMap<String, JCheckBox> checkboxes = new HashMap();
    HashMap<String, Integer> selectedComboBoxIndex = new HashMap();
    HashMap<String, JTextField> textfields = new HashMap();
    HashMap<String, JPasswordField> passwordfields = new HashMap();
    HashMap<String, JButton> colorbuttons = new HashMap();
    HashMap<String, JSlider> sliders = new HashMap();
    HashMap<String, Color> colors = new HashMap();
    ArrayList<JPanel> panels = new ArrayList();
    ArrayList<String> titles = new ArrayList();
    protected ArrayList<JButton> userButtons = new ArrayList();
    private static String OK = "ok";
    private static String CANCEL = "cancel";
    static int GAP_WIDTH = 8;
    int groupPadding = 8;
    int mainPadding = 4;
    protected static boolean done = false;
    public static OptionsDialog optionsDialog;
    String frameTitle;
    public static boolean APPLY_BACKGROUND_GRADIENT;
    private static HashMap<String, String> comboBoxKeys;
    public static ColorChooserDialog ccdBack;
    public static ColorChooserDialog ccdFor;
    static UsesColorChanger usesColorChanger;
    static final float[] dashes;
    static final Stroke dash;
    private static HashMap<String, JLabel> labels;

    public void init(Options opts, String frameTitle, String okText, String cancelText) {
        this.opts = opts;
        optionsDialog = this;
        Color b = GlobaliskLookAndFeel.backgroundCol;
        float r = 0.82f;
        this.setBackground(new Color((int)((float)b.getRed() * r), (int)((float)b.getGreen() * r), (int)((float)b.getBlue() * r)));
        new Init(opts, frameTitle, okText, cancelText).start();
    }

    public void init() {
    }

    public void save(Options opts) {
    }

    public void cancel() {
        this.shutDown(true);
    }

    public void addHorizontalGap(int width) {
        this.currentRow.add(Box.createRigidArea(new Dimension(width, 2)));
    }

    public void addHorizontalGap() {
        this.addHorizontalGap(GAP_WIDTH);
    }

    public JButton addButtonOption(Action act) {
        JButton ret = new JButton(act);
        this.currentRow.add(ret);
        this.addHorizontalGap();
        return ret;
    }

    public JComboBox addStringComboBoxOption(String name, String[] values, String initialValue) {
        return this.addStringComboBoxOption(name, name, values, initialValue);
    }

    public JComboBox addStringComboBoxOption(String name, String label, String[] values, String initialValue) {
        String[] valLabels = new String[values.length];
        int wide = 20;
        JComboBox fntCombo = new JComboBox();
        FontMetrics fm = fntCombo.getFontMetrics(fntCombo.getFont());
        for (int i = 0; i < values.length; ++i) {
            valLabels[i] = Lang.get(values[i]);
            comboBoxKeys.put(valLabels[i], values[i]);
            int ll = (int)fm.getStringBounds(valLabels[i], fntCombo.getGraphics()).getWidth() + GlobaliskLookAndFeel.comboBoxButtonWidth + 15;
            wide = Math.max(wide, ll);
        }
        JComboBox<String> ret = new JComboBox<String>(valLabels);
        ret.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Dimension d = new Dimension(wide, TEXT_HEIGHT);
        ret.getEditor().getEditorComponent().setPreferredSize(d);
        ret.setPreferredSize(d);
        if (this.opts.strings.get(name) != null) {
            int sel = this.getIndexOf(values, this.opts.strings.get(name));
            ret.setSelectedIndex(sel);
            this.selectedComboBoxIndex.put(name, new Integer(sel));
        } else {
            int sel = this.getIndexOf(values, initialValue);
            ret.setSelectedIndex(sel);
            this.selectedComboBoxIndex.put(name, new Integer(sel));
        }
        if (!label.equals("")) {
            this.currentRow.add(this.getLabeledBox(label, ret));
        } else {
            this.currentRow.add(ret);
        }
        this.comboboxes.put(name, ret);
        this.addHorizontalGap();
        return ret;
    }

    private int getIndexOf(String[] values, String initialValue) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(initialValue)) continue;
            return i;
        }
        return 0;
    }

    public JTextField addStringTextFieldOption(String name, String initialValue) {
        JTextField field = new JTextField();
        field.setSize(new Dimension(10, TEXT_HEIGHT));
        if (this.opts.strings.get(name) != null) {
            field.setText(this.opts.strings.get(name));
        } else {
            field.setText(initialValue);
        }
        this.currentRow.add(this.getLabeledBox(name, field));
        this.textfields.put(name, field);
        this.addHorizontalGap();
        return field;
    }

    public JTextField addStringBrowsableTextFieldOption(String name, String initialValue, int fileSelectionMode) {
        JTextField field = new JTextField();
        field.setMinimumSize(new Dimension(10, TEXT_HEIGHT));
        if (this.opts.strings.get(name) != null) {
            field.setText(this.opts.strings.get(name));
        } else {
            field.setText(initialValue);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JButton fileChooserButton = new JButton();
        fileChooserButton.setAction(new BrowseSelectionAction(Lang.get("Browse..."), field, fileSelectionMode));
        fileChooserButton.setMargin(new Insets(0, 4, 0, 4));
        JPanel bPanel = new JPanel(new BorderLayout());
        bPanel.setOpaque(false);
        bPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JLabel fmLab = new JLabel(" ");
        bPanel.add(Box.createVerticalStrut(fmLab.getFontMetrics(fmLab.getFont()).getHeight() + 5));
        bPanel.add((Component)fileChooserButton, "South");
        panel.add((Component)field, "Center");
        panel.add((Component)fileChooserButton, "East");
        this.currentRow.add(this.getLabeledBox(name, panel, fileChooserButton));
        this.textfields.put(name, field);
        this.addHorizontalGap();
        return field;
    }

    public void addComponent(JComponent comp) {
        this.currentRow.add(this.getLabeledBox("", comp));
    }

    public JPasswordField addPasswordFieldOption(String name) {
        JPasswordField field = new JPasswordField();
        field.setSize(new Dimension(10, TEXT_HEIGHT));
        this.currentRow.add(this.getLabeledBox(name, field));
        this.passwordfields.put(name, field);
        this.addHorizontalGap();
        return field;
    }

    public JCheckBox addBooleanCheckBoxOption(String name, boolean initialValue) {
        JCheckBox check = new JCheckBox();
        if (this.opts.booleans.get(name) != null) {
            check.setSelected(this.opts.booleans.get(name));
        } else {
            check.setSelected(initialValue);
        }
        check.setFont(this.nonBold);
        check.setText(Lang.get(name));
        this.currentRow.add(check);
        this.checkboxes.put(name, check);
        this.addHorizontalGap();
        return check;
    }

    public JSlider addIntegerSliderOption(String name, int min, int max, int defaultValue) {
        int initVal = defaultValue;
        if (this.opts.integers.get(name) != null) {
            initVal = this.opts.integers.get(name);
        }
        JSlider slide = new JSlider(0, min, max, OptionsDialog.correctedMinMaxVal(min, max, initVal));
        slide.setOpaque(false);
        slide.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.currentRow.add(this.getLabeledBox(name, slide));
        this.sliders.put(name, slide);
        this.addHorizontalGap();
        return slide;
    }

    private static int correctedMinMaxVal(int min, int max, int val) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public JSpinner addIntegerSpinnerOption(String name, String postfix, int min, int max, int step, int initialValue, Font f) {
        return this.addIntegerSpinnerOption(name, null, postfix, min, max, step, initialValue, f);
    }

    public JSpinner addIntegerSpinnerOption(String name, String prefix, String postfix, int min, int max, int step, int initialValue, Font f) {
        int setVal = initialValue;
        if (this.opts.integers.get(name) != null) {
            setVal = this.opts.integers.get(name);
        }
        JSpinner spin = new JSpinner(new SpinnerNumberModel(OptionsDialog.correctedMinMaxVal(min, max, setVal), min, max, step));
        if (f != null) {
            spin.setFont(f);
        } else {
            f = spin.getFont();
        }
        int maxWide = (int)this.getFontMetrics(f).getStringBounds(new Integer(max).toString(), this.main.getGraphics()).getWidth() + 30;
        int maxHigh = TEXT_HEIGHT;
        spin.setMaximumSize(new Dimension(maxWide, maxHigh));
        spin.setPreferredSize(new Dimension(maxWide, maxHigh));
        Box spinBox = Box.createHorizontalBox();
        if (prefix != null) {
            Box b = Box.createHorizontalBox();
            JLabel preLabel = new JLabel(Lang.get(prefix) + " ");
            preLabel.setFont(this.nonBold);
            spinBox.add(preLabel);
            spinBox.add(b);
            new DisableLabelThread(preLabel, spin).start();
        }
        spinBox.add(spin);
        spinBox.add(Box.createRigidArea(new Dimension(3, 1)));
        JLabel postLabel = new JLabel(Lang.get(postfix));
        postLabel.setFont(this.nonBold);
        if (postfix != null) {
            spinBox.add(postLabel);
        }
        new DisableLabelThread(postLabel, spin).start();
        if (prefix != null) {
            this.currentRow.add(spinBox);
        } else {
            this.currentRow.add(this.getLabeledBox(name, spinBox, spin));
        }
        this.spinners.put(name, spin);
        this.addHorizontalGap();
        return spin;
    }

    public JButton addColorChooserOption(String nameBackground, String nameForeground, String bannerLabel, Options opts, boolean isBackground, Image dialogIcon, UsesColorChanger usesColorChanger) {
        return this.addColorChooserOption(nameBackground, nameForeground, bannerLabel, opts, isBackground, dialogIcon, usesColorChanger, 1.0f);
    }

    public JButton addColorChooserOption(String nameBackground, String nameForeground, String bannerLabel, Options opts, boolean isBackground, Image dialogIcon, UsesColorChanger usesColorChanger, float buttonHeight) {
        OptionsDialog.usesColorChanger = usesColorChanger;
        JxColorButton colButton = isBackground ? new JxColorButton(nameBackground) : new JxColorButton(nameForeground);
        colButton.addActionListener(new ColorChooserActionListener(optionsDialog, nameBackground, nameForeground, bannerLabel, isBackground, dialogIcon));
        if (isBackground) {
            this.currentRow.add(this.getLabeledBox(nameBackground, colButton));
            this.colorbuttons.put(nameBackground, colButton);
            this.colors.put(nameBackground, opts.colors.get(nameBackground));
        } else {
            this.currentRow.add(this.getLabeledBox(nameForeground, colButton));
            this.colorbuttons.put(nameForeground, colButton);
            this.colors.put(nameForeground, opts.colors.get(nameForeground));
        }
        this.addHorizontalGap();
        JTextField tmp = new JTextField();
        int sizer = (int)this.getFontMetrics(tmp.getFont()).getStringBounds("", null).getHeight();
        colButton.setPreferredSize(new Dimension(sizer * 4, (int)(buttonHeight * (float)(sizer + 2 * tmp.getBorder().getBorderInsets((Component)tmp).top))));
        return colButton;
    }

    public void setColor(String name, Color value) {
        this.colors.put(name, value);
    }

    private JPanel getLabeledBox(String name, Component comp) {
        return this.getLabeledBox(name, comp, comp);
    }

    private JPanel getLabeledBox(String name, Component comp, Component widget) {
        JShadowLabel lab = new JShadowLabel(Lang.get(name));
        labels.put(name, lab);
        lab.setFont(this.bold);
        lab.setAlignmentX(0.0f);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 10));
        JPanel ret = new JPanel(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout());
        ret.setOpaque(false);
        north.setOpaque(false);
        ret.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        north.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        north.add((Component)lab, "West");
        ret.add((Component)north, "North");
        ret.add(comp, "Center");
        new DisableLabelThread(lab, comp, widget).start();
        return ret;
    }

    public static JLabel getLabelOf(String name) {
        String str = "";
        if (labels.get(name) != null) {
            return labels.get(name);
        }
        JLabel ret = new JLabel(str);
        if (Lang.weAreChinese()) {
            ret.setFont(Lang.chineseFont);
        } else if (Lang.weAreJapanese()) {
            ret.setFont(Lang.japaneseFont);
        } else if (Lang.weAreHindi()) {
            ret.setFont(Lang.hindiFont);
        }
        return ret;
    }

    public void newGroup() {
        this.newGroup(null, 0);
    }

    public void newGroup(String groupLabel) {
        this.newGroup(groupLabel, 0);
    }

    public void newGroup(String groupLabel, int vgap) {
        if (this.currentGroup != null) {
            this.endGroup(vgap);
        }
        this.currentGroup = new JPanel();
        if (APPLY_BACKGROUND_GRADIENT) {
            GlobaliskPanelUI.applyBackgroundGradient(this.currentGroup);
        }
        this.currentGroup.setAlignmentY(0.0f);
        this.currentGroup.setAlignmentX(0.0f);
        this.currentGroup.setLayout(new BoxLayout(this.currentGroup, 1));
        this.currentGroup.setBorder(BorderFactory.createEmptyBorder(this.groupPadding, this.groupPadding, this.groupPadding, this.groupPadding));
        this.titles.add(Lang.get(groupLabel));
    }

    public void endGroup() {
        this.endGroup(0);
    }

    public void endGroup(int vgap) {
        this.endRow(0);
        this.newRow(0);
        this.endRow(0);
        if (this.currentGroup != null) {
            this.currentGroup.add(Box.createVerticalGlue());
            this.panels.add(this.currentGroup);
        }
        this.newRow(vgap);
    }

    public void newRow() {
        this.newRow(0);
    }

    public void newRow(int topGap) {
        if (this.currentRow != null) {
            this.endRow(topGap);
        }
        this.currentRow = new JPanel(new FlowLayout(0));
        this.currentRow.setOpaque(false);
        this.currentRow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public void endRow(int topGap) {
        if (this.currentRow != null) {
            this.currentRow.setMaximumSize(new Dimension(Integer.MAX_VALUE, 12));
            this.currentRow.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.currentGroup.add(this.currentRow);
            if (topGap > 0) {
                this.currentGroup.add(Box.createRigidArea(new Dimension(2, topGap)));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK)) {
            this.shutDown(false);
        } else if (cmd.equals(CANCEL)) {
            this.shutDown(true);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.shutDown(true);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    protected void shutDown(boolean isCancel) {
        if (!done) {
            done = true;
            if (isCancel) {
                this.save(this.savedOpts);
            }
            new ShutDownThread(isCancel).start();
        }
    }

    public void saveValues() {
        for (String optName : this.spinners.keySet()) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinners.get(optName).getModel();
            this.opts.integers.put(optName, new Integer(model.getNumber().intValue()));
        }
        for (String optName : this.sliders.keySet()) {
            this.opts.integers.put(optName, this.sliders.get(optName).getValue());
        }
        for (String optName : this.checkboxes.keySet()) {
            this.opts.booleans.put(optName, this.checkboxes.get(optName).isSelected());
        }
        for (String optName : this.comboboxes.keySet()) {
            this.opts.strings.put(optName, comboBoxKeys.get(this.comboboxes.get(optName).getSelectedItem().toString()));
        }
        for (String optName : this.textfields.keySet()) {
            this.opts.strings.put(optName, this.textfields.get(optName).getText());
        }
        for (String optName : this.colors.keySet()) {
            this.opts.colors.put(optName, this.colors.get(optName));
        }
        this.save(this.opts);
    }

    public void restoreValues(OptionsApp optsApp) {
        new RestoreValuesThread(optsApp).start();
    }

    public static Options copyOptions(Options from) {
        Options to = new Options();
        to.integers = new HashMap();
        for (String key : from.integers.keySet()) {
            to.integers.put(key, from.integers.get(key));
        }
        to.booleans = new HashMap();
        for (String key : from.booleans.keySet()) {
            to.booleans.put(key, from.booleans.get(key));
        }
        to.doubles = new HashMap();
        for (String key : from.doubles.keySet()) {
            to.doubles.put(key, from.doubles.get(key));
        }
        to.floats = new HashMap();
        for (String key : from.floats.keySet()) {
            to.floats.put(key, from.floats.get(key));
        }
        to.strings = new HashMap();
        for (String key : from.strings.keySet()) {
            to.strings.put(key, from.strings.get(key));
        }
        to.colors = new HashMap();
        for (String key : from.colors.keySet()) {
            to.colors.put(key, from.colors.get(key));
        }
        to.other = new HashMap();
        for (String key : from.other.keySet()) {
            to.other.put(key, from.other.get(key));
        }
        return to;
    }

    static {
        APPLY_BACKGROUND_GRADIENT = true;
        comboBoxKeys = new HashMap();
        usesColorChanger = null;
        dashes = new float[]{1.0f};
        dash = new BasicStroke(1.0f, 0, 2, 1.0f, dashes, 1.0f);
        labels = new HashMap();
    }

    class RestoreValuesThread
    extends Thread {
        OptionsApp optsApp;

        public RestoreValuesThread(OptionsApp optsApp) {
            this.optsApp = optsApp;
        }

        public void run() {
            Options restoreOpts = this.optsApp.getRestoreOptions();
            for (String optName : OptionsDialog.this.spinners.keySet()) {
                OptionsDialog.this.spinners.get(optName).setValue(restoreOpts.integers.get(optName));
                OptionsDialog.this.spinners.get(optName).repaint();
            }
            for (String optName : OptionsDialog.this.sliders.keySet()) {
                OptionsDialog.this.sliders.get(optName).setValue(restoreOpts.integers.get(optName));
                OptionsDialog.this.sliders.get(optName).repaint();
            }
            for (String optName : OptionsDialog.this.checkboxes.keySet()) {
                OptionsDialog.this.checkboxes.get(optName).setSelected(restoreOpts.booleans.get(optName));
                OptionsDialog.this.checkboxes.get(optName).repaint();
            }
            for (String optName : OptionsDialog.this.comboboxes.keySet()) {
                OptionsDialog.this.comboboxes.get(optName).setSelectedIndex(OptionsDialog.this.selectedComboBoxIndex.get(optName));
                OptionsDialog.this.comboboxes.get(optName).repaint();
            }
            for (String optName : OptionsDialog.this.textfields.keySet()) {
                OptionsDialog.this.textfields.get(optName).setText(restoreOpts.strings.get(optName));
                OptionsDialog.this.textfields.get(optName).repaint();
            }
            for (String optName : OptionsDialog.this.colors.keySet()) {
                OptionsDialog.this.colors.put(optName, restoreOpts.colors.get(optName));
            }
            Iterator<String> i = OptionsDialog.this.colorbuttons.keySet().iterator();
            while (i.hasNext()) {
                OptionsDialog.this.colorbuttons.get(i.next()).repaint();
            }
            OptionsDialog.this.opts = this.optsApp.getRestoreOptions();
            OptionsDialog.this.save(OptionsDialog.this.opts);
        }
    }

    class ShutDownThread
    extends Thread {
        boolean isCancel = false;

        public ShutDownThread(boolean isCancel) {
            this.isCancel = isCancel;
        }

        public void run() {
            OptionsDialog.this.frame.setVisible(false);
            if (this.isCancel) {
                OptionsDialog.this.cancel();
            } else {
                OptionsDialog.this.saveValues();
            }
            OptionsDialog.this.frame.dispose();
        }
    }

    class DisableLabelThread
    extends Thread {
        JLabel lab;
        Component comp;
        Component comp2 = null;
        boolean areDone = false;

        public DisableLabelThread(JLabel lab, Component comp, Component comp2) {
            this.lab = lab;
            this.comp = comp;
            this.comp2 = comp2;
            this.setPriority(1);
        }

        public DisableLabelThread(JLabel lab, Component comp) {
            this.lab = lab;
            this.comp = comp;
            this.setPriority(1);
        }

        public void run() {
            boolean save = this.comp.isEnabled();
            boolean init = true;
            while (!this.areDone) {
                Component test = this.comp2 != null && this.comp2 instanceof JSpinner ? this.comp2 : this.comp;
                if (init || test.isEnabled() != save) {
                    init = false;
                    this.lab.setEnabled(test.isEnabled());
                    if (this.comp2 != null) {
                        this.comp2.setEnabled(test.isEnabled());
                    }
                }
                save = test.isEnabled();
                this.pause(250);
            }
        }

        private void pause(int ms) {
            try {
                DisableLabelThread.sleep(ms);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static interface UsesColorChanger {
        public void colorChanged();
    }

    class JxColorButton
    extends JButton {
        String name;

        public JxColorButton(String name) {
            this.name = name;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isEnabled()) {
                g.setColor(OptionsDialog.this.opts.colors.get(this.name));
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillRect(6, 5, this.getWidth() - 13, this.getHeight() - 11);
            g.draw3DRect(6, 5, this.getWidth() - 13, this.getHeight() - 11, false);
            if (this.hasFocus()) {
                Graphics2D g2 = (Graphics2D)g;
                Color c = Color.BLACK;
                if (GraphicsOps.isDarkCol(g.getColor())) {
                    c = Color.WHITE;
                }
                g2.setColor(c);
                g2.setStroke(dash);
                g2.drawRect(8, 7, this.getWidth() - 17, this.getHeight() - 15);
            }
        }
    }

    class ColorChooserActionListener
    implements ActionListener {
        OptionsDialog optionsDialog;
        Image dialogIcon;
        String nameBack;
        String nameFor;
        String bannerLabel;
        boolean isBackground;

        public ColorChooserActionListener(OptionsDialog optionsDialog2, String nameBack, String nameFor, String bannerLabel, boolean isBackground, Image dialogIcon) {
            this.optionsDialog = optionsDialog2;
            this.dialogIcon = dialogIcon;
            this.nameBack = nameBack;
            this.nameFor = nameFor;
            this.isBackground = isBackground;
            this.bannerLabel = bannerLabel;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isBackground) {
                if (ccdBack != null) {
                    OptionsDialog.ccdBack.frame.toFront();
                } else {
                    ccdBack = new ColorChooserDialog(this.optionsDialog, this.nameBack, this.nameFor, this.bannerLabel, this.isBackground, this.dialogIcon);
                }
            } else if (ccdFor != null) {
                OptionsDialog.ccdFor.frame.toFront();
            } else {
                ccdFor = new ColorChooserDialog(this.optionsDialog, this.nameBack, this.nameFor, this.bannerLabel, this.isBackground, this.dialogIcon);
            }
            if (usesColorChanger != null) {
                usesColorChanger.colorChanged();
            }
        }
    }

    class BrowseSelectionAction
    extends AbstractAction {
        JTextField field;
        int fileSelectionMode;

        public BrowseSelectionAction(String bText, JTextField field, int fileSelectionMode) {
            super(bText);
            this.field = field;
            this.fileSelectionMode = fileSelectionMode;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(this.fileSelectionMode);
            String lab = "Select folder";
            if (this.fileSelectionMode == 2) {
                lab = "Select file/folder";
            } else if (this.fileSelectionMode == 0) {
                lab = "Select file";
            }
            int ret = fileChooser.showDialog(OptionsDialog.this.main, Lang.get(lab));
            if (ret == 0) {
                File file = fileChooser.getSelectedFile();
                this.field.setText(file.getAbsolutePath());
            }
        }
    }

    class Init
    extends Thread {
        Options opts;
        String frameTitle;
        String okText;
        String cancelText;

        public Init(Options opts, String frameTitle, String okText, String cancelText) {
            this.opts = opts;
            this.frameTitle = frameTitle;
            this.okText = okText;
            this.cancelText = cancelText;
        }

        public void run() {
            OptionsDialog.this.main = new JTabbedPane();
            OptionsDialog.this.frame = new JFrame(this.frameTitle);
            OptionsDialog.this.savedOpts = OptionsDialog.copyOptions(this.opts);
            OptionsDialog.this.setLayout(new BorderLayout());
            done = false;
            OptionsDialog.this.main.setBorder(BorderFactory.createEmptyBorder(OptionsDialog.this.mainPadding, OptionsDialog.this.mainPadding, OptionsDialog.this.mainPadding, OptionsDialog.this.mainPadding));
            OptionsDialog.this.ok = new JButton(Lang.get(this.okText));
            OptionsDialog.this.newRow(0);
            OptionsDialog.this.init();
            OptionsDialog.this.endRow(0);
            OptionsDialog.this.endGroup();
            for (int i = 0; i < OptionsDialog.this.panels.size(); ++i) {
                OptionsDialog.this.main.addTab(OptionsDialog.this.titles.get(i), OptionsDialog.this.panels.get(i));
            }
            OptionsDialog.this.add((Component)OptionsDialog.this.main, "Center");
            JPanel bottom = new JPanel(new BorderLayout());
            bottom.setOpaque(false);
            OptionsDialog.this.ok.setActionCommand(OK);
            OptionsDialog.this.ok.addActionListener(optionsDialog);
            JButton cancel = new JButton(Lang.get(this.cancelText));
            cancel.setActionCommand(CANCEL);
            cancel.addActionListener(optionsDialog);
            bottom.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            JPanel okCancelPanel = new JPanel(new FlowLayout(2));
            okCancelPanel.setOpaque(false);
            okCancelPanel.add(OptionsDialog.this.ok);
            okCancelPanel.add(cancel);
            bottom.add((Component)okCancelPanel, "East");
            JPanel userButtonsPanel = new JPanel(new FlowLayout(0));
            userButtonsPanel.setOpaque(false);
            for (int i = 0; i < OptionsDialog.this.userButtons.size(); ++i) {
                userButtonsPanel.add(OptionsDialog.this.userButtons.get(i));
            }
            bottom.add((Component)userButtonsPanel, "West");
            OptionsDialog.this.add((Component)bottom, "South");
            OptionsDialog.this.frame.addWindowListener(optionsDialog);
            OptionsDialog.this.setOpaque(true);
            OptionsDialog.this.frame.setContentPane(optionsDialog);
            OptionsDialog.this.frame.pack();
            Dialogs.centerFrameInAvailableSpace(OptionsDialog.this.frame);
            OptionsDialog.this.frame.setVisible(true);
            OptionsDialog.this.frame.requestFocus();
        }
    }
}

