/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.Files;
import com.globalisk.util.RunSystemCommandThreaded;
import java.io.File;
import java.io.InputStream;

public class OS {
    public static String NAME = System.getProperty("os.name");
    public static boolean IS_UNIX = false;
    public static boolean IS_WINDOWS = true;
    public static boolean IS_MAC = false;
    public static String EXE_DIR = System.getProperty("user.home");
    public static String attribEXE = null;
    public static String CP = "";
    public static String CP_SEP = ";";
    static boolean jarSuccess = true;

    public static void unHideFile(String filename) {
        OS.hideFile(filename, "-");
    }

    public static void hideFile(String filename) {
        OS.hideFile(filename, "+");
    }

    public static void hideFile(String filename, String pm) {
        filename = filename.replaceAll("/", "\\\\");
        if (OS.hasAttrib()) {
            try {
                Runtime.getRuntime().exec(attribEXE + " " + pm + "H \"" + filename + "\"");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static boolean hasAttrib() {
        attribEXE = "C:\\WINDOWS\\System64\\ATTRIB.EXE";
        if (new File(attribEXE).exists()) {
            return true;
        }
        attribEXE = "C:\\WINDOWS\\System32\\ATTRIB.EXE";
        if (new File(attribEXE).exists()) {
            return true;
        }
        attribEXE = "C:\\WINDOWS\\System\\ATTRIB.EXE";
        return new File(attribEXE).exists();
    }

    public OS(String appName) {
        System.out.println("OS.NAME: " + NAME);
        if (NAME.startsWith("Mac ")) {
            IS_UNIX = true;
            IS_MAC = true;
            IS_WINDOWS = false;
        } else if (NAME.startsWith("Windows ")) {
            IS_UNIX = false;
            IS_MAC = false;
            IS_WINDOWS = true;
            CP = "\"";
        }
        if (IS_UNIX) {
            CP_SEP = ":";
        }
        String home = System.getProperty("user.home");
        String sub = "Applications";
        File f = new File(home + "/" + sub);
        if (!f.exists()) {
            sub = "AppData";
            f = new File(home + "/" + sub);
            if (!f.exists()) {
                sub = "";
            }
        }
        OS.establishExeDir(home + "/" + sub + "/" + appName);
    }

    public static void establishExeDir(String str) {
        EXE_DIR = str;
        File f = new File(EXE_DIR);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    public static String filepathNormalize(String n) {
        return n.replaceAll("\\\\", "/").replaceAll("\\/\\.\\/", "/");
    }

    public boolean deployJARs(String[] jars) {
        System.out.println("deployJARs: " + EXE_DIR);
        File exeDir = new File(EXE_DIR);
        if (!exeDir.exists()) {
            exeDir.mkdir();
        }
        for (String s : jars) {
            this.unpackJAR(s);
        }
        if (IS_WINDOWS) {
            CP = CP + "\"";
        }
        return jarSuccess;
    }

    private void unpackJAR(String name) {
        String pre = EXE_DIR + "/";
        System.out.println("unpackJAR: " + pre + name);
        InputStream is = this.getClass().getResourceAsStream("res/" + name);
        File jar = new File(pre + name);
        if (jar.exists()) {
            jar.delete();
        }
        try {
            Files.writeStreamToFile(is, jar);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            jarSuccess = false;
        }
        CP = CP + pre + name + CP_SEP;
    }

    public void executeShell(String mainClass) {
        String ext = ".sh";
        if (IS_WINDOWS) {
            ext = ".bat";
        }
        String cmd = "java -cp " + CP + " " + mainClass;
        String sh = EXE_DIR + "/run" + ext;
        Files.writeFile(sh, cmd);
        if (IS_UNIX) {
            new RunSystemCommandThreaded(new String[]{"chmod", "777", sh}).start();
        }
        new RunSystemCommandThreaded(new String[]{sh}, 50).start();
    }

    public void executeApp(String mainClass) {
        new RunSystemCommandThreaded(new String[]{"java", "-cp", CP, mainClass}).start();
    }
}

