/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Lang {
    private static String currentLanguageCode = "en";
    private static HashMap<String, String> currentLang = new HashMap();
    public static boolean initialized = false;
    public static Font chineseFont = null;
    public static Font japaneseFont = null;
    public static Font hindiFont = null;
    static HashMap<String, Boolean> reported = new HashMap();

    public static void setCurrentLanguageCode(String code, InputStream is) {
        currentLanguageCode = code;
        Lang.init(is);
        if (Lang.weAreChinese()) {
            Lang.turnChinese();
        } else if (Lang.weAreJapanese()) {
            Lang.turnJapanese();
        } else if (Lang.weAreHindi()) {
            Lang.turnHindi();
        }
    }

    public static String getCurrentLanguageCode() {
        return currentLanguageCode;
    }

    public static Font getInternationalizedFont(Font src) {
        if (Lang.weAreChinese()) {
            return new Font(chineseFont.getFontName(), src.getStyle(), src.getSize());
        }
        if (Lang.weAreJapanese()) {
            return new Font(japaneseFont.getFontName(), src.getStyle(), src.getSize());
        }
        if (Lang.weAreHindi()) {
            return new Font(hindiFont.getFontName(), src.getStyle(), src.getSize() + 1);
        }
        return src;
    }

    public static boolean weAreChinese() {
        return Lang.getCurrentLanguageCode().startsWith("zh");
    }

    public static boolean weAreJapanese() {
        return Lang.getCurrentLanguageCode().startsWith("ja");
    }

    public static boolean weAreHindi() {
        return Lang.getCurrentLanguageCode().startsWith("hi");
    }

    private static String turn(String langChar) {
        String ret = "";
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < allFonts.length; ++i) {
            if (allFonts[i].canDisplayUpTo(langChar) != -1) continue;
            ret = allFonts[i].getFontName();
            i = allFonts.length;
        }
        return ret;
    }

    public static void turnChinese() {
        chineseFont = new Font(Lang.turn("\u4e00"), 0, 13);
    }

    public static void turnJapanese() {
        japaneseFont = new Font(Lang.turn("\u304f"), 0, 13);
    }

    public static void turnHindi() {
        hindiFont = new Font(Lang.turn("\u0921"), 0, 14);
    }

    public static String get(String appKey) {
        if (currentLang.get(appKey) != null) {
            return currentLang.get(appKey);
        }
        if (reported.get(appKey) == null) {
            reported.put(appKey, Boolean.TRUE);
        }
        return appKey;
    }

    private static void init(InputStream is) {
        currentLang = new HashMap();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        XMLParser handler = new XMLParser();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        initialized = true;
    }

    static class XMLParser
    extends DefaultHandler {
        String currentName;
        String currentKey;
        StringBuffer currentChars;

        XMLParser() {
        }

        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            this.currentName = qName;
            this.currentChars = new StringBuffer();
        }

        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (!this.currentChars.toString().trim().equals("")) {
                if (qName.equals("key")) {
                    this.currentKey = this.currentChars.toString();
                } else if (this.currentName.equals(currentLanguageCode)) {
                    currentLang.put(this.currentKey, this.currentChars.toString());
                }
            }
        }

        public void characters(char[] buf, int offset, int len) throws SAXException {
            this.currentChars.append(new String(buf, offset, len).replaceAll("-LT-", "<").replaceAll("-GT-", ">"));
        }
    }
}

