/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.GraphicsOps;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JShadowLabel
extends JLabel {
    public static final Color BLACK = new Color(0, 0, 0, 174);
    public static final Color WHITE = new Color(255, 255, 255, 174);
    int depth = 1;
    JComponent backgroundComp = this;
    private int alignX = 2;

    public JShadowLabel(JComponent backgroundComp, String str) {
        super(str);
        this.backgroundComp = backgroundComp;
        this.init();
    }

    public JShadowLabel(JComponent backgroundComp, String str, int depth) {
        super(str);
        this.depth = depth;
        this.backgroundComp = backgroundComp;
        this.init();
    }

    public JShadowLabel(JComponent backgroundComp, String str, int align, int depth) {
        super(str, align);
        this.depth = depth;
        this.backgroundComp = backgroundComp;
        this.init();
    }

    public JShadowLabel(String str) {
        super(str);
        this.init();
    }

    public JShadowLabel(String str, int align) {
        super(str, align);
        this.init();
    }

    public JShadowLabel(String str, int align, int depth) {
        super(str, align);
        this.depth = depth;
        this.init();
    }

    private void init() {
        this.setAlignmentX(2);
    }

    public void setAlignmentX(int align) {
        this.alignX = align;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color fg = this.getForeground();
        boolean wasOp = this.isOpaque();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.setOpaque(false);
        g2.translate(this.depth, this.depth);
        g2.setComposite(AlphaComposite.getInstance(3, GraphicsOps.SHADOW_ALPHA));
        g2.setFont(this.getFont());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle2D textRect = fm.getStringBounds(this.getText(), g2);
        int x = 1;
        if (this.alignX == 0) {
            x = (int)(((double)this.getWidth() - textRect.getWidth()) / 2.0);
        }
        int y = (int)(((double)this.getHeight() - textRect.getHeight()) / 2.0) + (int)textRect.getHeight() - 2;
        if (GraphicsOps.isDarkCol(fg)) {
            g2.setColor(Color.LIGHT_GRAY);
        } else {
            g2.setColor(Color.BLACK);
        }
        g2.drawString(this.getText(), x, y);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setColor(fg);
        g2.translate(-this.depth, -this.depth);
        g2.drawString(this.getText(), x, y);
        this.setOpaque(wasOp);
    }
}

