/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GraphicsOps {
    public static float SHADOW_ALPHA = 0.25f;

    public static void drawImageWithDropShadow(Graphics g, Image img, int x, int y, ImageObserver io) {
        GraphicsOps.drawImageWithDropShadow(g, img, x, y, 1, SHADOW_ALPHA, io);
    }

    public static void drawImageWithDropShadow(Graphics g, Image img, int x, int y, int depth, float alpha, ImageObserver io) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.drawImage(img, x + depth, y + depth, io);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawImage(img, x, y, io);
    }

    public static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage ret = gc.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics2D g = ret.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return ret;
    }

    public static void paintTransparentRoundedBackground(Graphics g, Color col, float alpha, float shadowAlpha, int shadowDepth, int x, int y, int width, int height, int c1, int c2) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.BLACK);
        g2.setComposite(AlphaComposite.getInstance(3, shadowAlpha));
        g2.fillRoundRect(x + shadowDepth, y + shadowDepth, width, height, c1, c2);
        g2.setComposite(AlphaComposite.getInstance(3, Math.min(1.0f, shadowAlpha * 2.0f)));
        g2.drawRoundRect(x + shadowDepth, y + shadowDepth, width, height, c1, c2);
        g2.setColor(col);
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.fillRoundRect(x, y, width, height, c1, c2);
        g2.setComposite(AlphaComposite.getInstance(3, Math.min(alpha * 2.0f, 1.0f)));
        g2.drawRoundRect(x, y, width, height, c1, c2);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public static void paintHorizontalGradient(Graphics g, Color col, int x, int y, int width, int height, float start, float alpha, float degrade, boolean leftLight) {
        for (int i = x; i < x + width; ++i) {
            int comp = i - x;
            if (leftLight) {
                comp = width - i;
            }
            float a = start - degrade * (float)comp;
            g.setColor(GraphicsOps.getRatioCol(col, alpha, a));
            g.drawLine(i, y, i, y + height);
        }
    }

    public static void paintVerticalGradient(Graphics g, Color col, int x, int y, int width, int height, float start, float alpha, float degrade, boolean topLight) {
        for (int i = y; i < y + height; ++i) {
            int comp = i - y;
            if (topLight) {
                comp = height - i;
            }
            float a = start - degrade * (float)comp;
            g.setColor(GraphicsOps.getRatioCol(col, alpha, a));
            g.drawLine(x, i, x + width, i);
        }
    }

    public static Color getRatioCol(Color c, float perc, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (c == null) {
            return Color.BLACK;
        }
        return new Color(GraphicsOps.colNum((double)c.getRed() * (double)perc), GraphicsOps.colNum((double)c.getGreen() * (double)perc), GraphicsOps.colNum((double)c.getBlue() * (double)perc), (int)(255.0f * alpha));
    }

    public static int colNum(double c) {
        if (c < 0.0) {
            return 0;
        }
        if (c > 255.0) {
            return 255;
        }
        return (int)c;
    }

    public static boolean isDarkCol(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int thresh = 174;
        if (r > thresh) {
            return false;
        }
        if (g > thresh) {
            return false;
        }
        return b <= thresh;
    }

    public static boolean isLightCol(Color c) {
        return !GraphicsOps.isDarkCol(c);
    }
}

