/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.Dialogs;
import com.globalisk.util.Lang;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class Files {
    public static boolean puttingSerializedObject = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void appendToFile(String filename, String text) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(filename, true));
            bw.write(text);
            bw.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    public static synchronized boolean writeFile(String filename, String text) {
        return Files.writeFile(filename, text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean writeFile(String filename, String text, boolean writePermission) {
        FileWriter file = null;
        try {
            file = new FileWriter(filename);
            file.write(text, 0, text.length());
            file.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        file = null;
        if (writePermission) {
            File f = new File(filename);
            f.setWritable(true);
            f.setReadable(true);
        }
        return true;
    }

    public static void writeStreamToFile(InputStream in, File dst) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static String getFileContents(String filename) {
        return Files.getFileContents(filename, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(String filename, boolean reportError) {
        File readFile = new File(filename);
        StringBuilder contents = new StringBuilder("");
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(readFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException ex) {
            if (reportError) {
                ex.printStackTrace(System.err);
            }
        }
        catch (IOException ex) {
            if (reportError) {
                ex.printStackTrace(System.err);
            }
        }
        finally {
            block20: {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    if (!reportError) break block20;
                    ex.printStackTrace(System.err);
                }
            }
        }
        return contents.toString();
    }

    public static Object getSerializedObject(String fileName) {
        return Files.getSerializedObject(fileName, 0);
    }

    public static Object getSerializedObject(String fileName, int tryCt) {
        while (puttingSerializedObject) {
            Files.pause(50);
        }
        Object ret = null;
        try {
            FileInputStream f_in = new FileInputStream(fileName);
            ObjectInputStream obj_in = null;
            try {
                obj_in = new ObjectInputStream(f_in);
                ret = obj_in.readObject();
                obj_in.close();
                f_in.close();
            }
            catch (EOFException e) {
                try {
                    if (obj_in != null) {
                        obj_in.close();
                    }
                    f_in.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                if (tryCt++ > 10) {
                    System.out.println("EOF, returning NULL: " + fileName);
                    return null;
                }
                return Files.getSerializedObject(fileName, tryCt);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Files.getSerializedObject() failed:");
            e.printStackTrace(System.err);
        }
        return ret;
    }

    public static synchronized boolean putSerializedObject(String fileName, Object obj) {
        return Files.putSerializedObject(fileName, obj, false);
    }

    public static synchronized boolean putSerializedObject(String fileName, Object obj, boolean exitUponError) {
        puttingSerializedObject = true;
        try {
            FileOutputStream f_out = new FileOutputStream(fileName);
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(obj);
            obj_out.close();
            f_out.close();
        }
        catch (Exception e) {
            System.out.println("Files.putSerializedObject( '" + fileName + "' ) failed: " + e.getMessage());
            if (exitUponError) {
                Dialogs.alert(Lang.get("Object serialization failed: ") + e.getMessage());
                System.exit(1);
            }
            return false;
        }
        puttingSerializedObject = false;
        return true;
    }

    public static boolean tryToMakeDir(File dir) {
        if (dir.exists()) {
            return false;
        }
        if (!dir.mkdir()) {
            JOptionPane.showMessageDialog(null, "There was an error trying to create directory:\n\n" + dir.getName(), "Error creating directory", 0);
            return false;
        }
        return true;
    }

    public static boolean moveFile(String fromFile, String toDir) {
        File file = new File(fromFile);
        File dir = new File(toDir);
        return file.renameTo(new File(dir, file.getName()));
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void copyDirectoryFiles(File src, File dst) throws IOException {
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File destFile = new File(dst.getAbsolutePath() + "/" + files[i].getName());
            Files.copyFile(files[i], destFile);
        }
    }

    public static boolean deleteFilesInDirectory(String dir, boolean deleteDir) {
        File dirFile = new File(dir);
        File[] files = dirFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                int tryCt = 0;
                if (files[i].isDirectory()) {
                    Files.deleteFilesInDirectory(files[i].getAbsolutePath(), true);
                }
                while (!files[i].delete() && tryCt < 42) {
                    ++tryCt;
                    Files.pause(66);
                }
            }
        }
        if (deleteDir) {
            return dirFile.delete();
        }
        return true;
    }

    private static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void bindCheckBoxComponent(String appDataFilename, JCheckBox tc) {
        Boolean b;
        tc.addChangeListener(new CheckBoxComponentListener(tc, appDataFilename));
        if (new File(appDataFilename).exists() && (b = (Boolean)Files.getSerializedObject(appDataFilename)) != null) {
            tc.setSelected(b);
        }
    }

    public static void bindTextComponent(String appDataFilename, String dataKey, JTextComponent tc) {
        tc.getDocument().addDocumentListener(new TextComponentDocumentListener(appDataFilename, dataKey, tc));
        AppData ad = (AppData)Files.getSerializedObject(appDataFilename);
        if (ad != null) {
            tc.setText(ad.map.get(dataKey));
        }
        if (tc instanceof JTextArea) {
            ((JTextArea)tc).setCaretPosition(0);
        }
    }

    public static String getSHA1Checksum(String filename) throws Exception {
        byte[] b = Files.makeChecksum(filename);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            ret.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return ret.toString();
    }

    private static byte[] makeChecksum(String filename) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest md = MessageDigest.getInstance("SHA1");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            md.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return md.digest();
    }

    public static class AppData
    implements Serializable {
        public HashMap<String, String> map = new HashMap();
    }

    static class TextComponentDocumentListener
    implements DocumentListener {
        String appDataFilename;
        String dataKey;
        JTextComponent tf;

        public TextComponentDocumentListener(String appDataFilename, String dataKey, JTextComponent tf) {
            this.appDataFilename = appDataFilename;
            this.tf = tf;
            this.dataKey = dataKey;
        }

        private void changeUpdate() {
            AppData ad = (AppData)Files.getSerializedObject(this.appDataFilename);
            if (ad == null) {
                ad = new AppData();
            }
            ad.map.put(this.dataKey, this.tf.getText());
            Files.putSerializedObject(this.appDataFilename, ad);
        }

        public void insertUpdate(DocumentEvent e) {
            this.changeUpdate();
        }

        public void removeUpdate(DocumentEvent e) {
            this.changeUpdate();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    static class CheckBoxComponentListener
    implements ChangeListener {
        JCheckBox cb;
        String appDataFilename;

        public CheckBoxComponentListener(JCheckBox cb, String appDataFilename) {
            this.cb = cb;
            this.appDataFilename = appDataFilename;
        }

        public void stateChanged(ChangeEvent e) {
            Boolean b = this.cb.isSelected();
            Files.putSerializedObject(this.appDataFilename, b);
        }
    }
}

