/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOQueue<Item>
implements Iterable<Item> {
    private int size;
    private Node first = null;
    private Node last = null;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.size;
    }

    public void add(Item item) {
        Node x = new Node();
        x.item = item;
        if (this.isEmpty()) {
            this.first = x;
            this.last = x;
        } else {
            this.last.next = x;
            this.last = x;
        }
        ++this.size;
    }

    public Item remove() {
        if (this.isEmpty()) {
            throw new RuntimeException("Attempt to remove item from empty FIFOQueue");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.size;
        if (this.isEmpty()) {
            this.last = null;
        }
        return (Item)item;
    }

    @Override
    public Iterator<Item> iterator() {
        return new FIFOIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FIFOIterator
    implements Iterator<Item> {
        private Node current;

        private FIFOIterator() {
            this.current = FIFOQueue.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }
}

