/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.Lang;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Dialogs {
    static final String defaultTitle = Lang.get("Alert");

    public static void alert(String msg) {
        Dialogs.alert(defaultTitle, msg);
    }

    public static void alert(String title, String msg) {
        Dialogs.alert(null, title, msg);
    }

    public static void alert(Component parentComp, String msg) {
        JOptionPane.showMessageDialog(parentComp, msg, defaultTitle, -1);
    }

    public static void alert(Component parentComp, String title, String msg) {
        JOptionPane.showMessageDialog(parentComp, msg, title, -1);
    }

    public static void alertLater(final String alertTitle, final String alertMsg, int msdelay) {
        try {
            Thread.sleep(msdelay);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Dialogs.alert(alertTitle, alertMsg);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static boolean confirm(Component parentComp, String query, String title) {
        return JOptionPane.showConfirmDialog(parentComp, query, title, 0) == 0;
    }

    public static void centerFrameInAvailableSpace(Frame frame) {
        Dialogs.centerFrameInAvailableSpace(frame, false);
    }

    public static void centerFrameInAvailableSpace(Frame frame, boolean thirdHeight) {
        Rectangle av = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (thirdHeight) {
            frame.setLocation((int)((av.getWidth() - (double)frame.getWidth()) / 2.0), (int)((av.getHeight() - (double)frame.getHeight()) / 3.0));
        } else {
            frame.setLocation((int)((av.getWidth() - (double)frame.getWidth()) / 2.0), (int)((av.getHeight() - (double)frame.getHeight()) / 2.0));
        }
    }

    public static void centerDialogInAvailableSpace(Dialog dialog) {
        Dialogs.centerDialogInAvailableSpace(dialog, false);
    }

    public static void centerDialogInAvailableSpace(Dialog dialog, boolean thirdHeight) {
        Rectangle av = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (thirdHeight) {
            dialog.setLocation((int)((av.getWidth() - (double)dialog.getWidth()) / 2.0), (int)((av.getHeight() - (double)dialog.getHeight()) / 3.0));
        } else {
            dialog.setLocation((int)((av.getWidth() - (double)dialog.getWidth()) / 2.0), (int)((av.getHeight() - (double)dialog.getHeight()) / 2.0));
        }
    }
}

