/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.util;

import com.globalisk.util.Dialogs;
import com.globalisk.util.Lang;
import com.globalisk.util.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooserDialog
extends JPanel
implements ChangeListener {
    JFrame frame;
    protected JColorChooser chooser;
    protected JLabel banner;
    boolean isBack = true;
    boolean done = false;
    OptionsDialog optionsDialog;
    String bannerLabel = "";
    String nameBack;
    String nameFor;
    Color newColor;
    Color saveColor;
    Image dialogIcon;

    public ColorChooserDialog(OptionsDialog optionsDialog, String nameBack, String nameFor, String bannerLabel, boolean isBack, Image dialogIcon) {
        super(new BorderLayout());
        this.nameBack = nameBack;
        this.nameFor = nameFor;
        this.isBack = isBack;
        this.optionsDialog = optionsDialog;
        this.bannerLabel = Lang.get(bannerLabel);
        this.dialogIcon = dialogIcon;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ColorChooserDialog.this.init();
            }
        });
    }

    private void init() {
        this.chooser = new JColorChooser();
        this.saveColor = this.isBack ? this.optionsDialog.opts.colors.get(this.nameBack) : this.optionsDialog.opts.colors.get(this.nameFor);
        this.chooser.setColor(this.saveColor);
        this.banner = new JLabel(this.bannerLabel, 0);
        this.banner.setBackground(this.optionsDialog.opts.colors.get(this.nameBack));
        this.banner.setForeground(this.optionsDialog.opts.colors.get(this.nameFor));
        this.banner.setOpaque(true);
        this.banner.setFont(Lang.getInternationalizedFont(new Font("Arial", 1, 24)));
        this.banner.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel bannerPanel = new JPanel(new BorderLayout());
        JPanel padPanel = new JPanel(new BorderLayout());
        padPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 6, 6));
        padPanel.add((Component)this.banner, "Center");
        bannerPanel.add((Component)padPanel, "Center");
        bannerPanel.setBorder(BorderFactory.createTitledBorder(Lang.get("Sample")));
        this.chooser.getSelectionModel().addChangeListener(this);
        this.chooser.setPreviewPanel(new JPanel());
        this.add((Component)bannerPanel, "Center");
        JPanel chooserBox = new JPanel(new BorderLayout());
        JPanel navBar = new JPanel(new BorderLayout());
        navBar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonsBox = new JPanel(new FlowLayout());
        JButton okButton = new JButton();
        okButton.setAction(new SaveNewColorAction());
        okButton.setText(Lang.get("OK"));
        JButton cancelButton = new JButton();
        cancelButton.setAction(new CancelAction());
        cancelButton.setText(Lang.get("Cancel"));
        buttonsBox.add(okButton);
        buttonsBox.add(cancelButton);
        navBar.add((Component)buttonsBox, "East");
        chooserBox.add((Component)this.chooser, "Center");
        chooserBox.add((Component)navBar, "South");
        this.add((Component)chooserBox, "Last");
        new CreateAndShowThread(this, this.optionsDialog, this.nameBack, this.nameFor, this.isBack, this.dialogIcon).start();
    }

    public void dispose() {
        this.done = true;
        this.frame.dispose();
        if (this.isBack) {
            OptionsDialog.ccdBack = null;
        } else {
            OptionsDialog.ccdFor = null;
        }
    }

    private void cancel() {
        if (this.isBack) {
            this.optionsDialog.setColor(this.nameBack, this.saveColor);
        } else {
            this.optionsDialog.setColor(this.nameFor, this.saveColor);
        }
        this.optionsDialog.saveValues();
        if (OptionsDialog.usesColorChanger != null) {
            OptionsDialog.usesColorChanger.colorChanged();
        }
        this.dispose();
    }

    public void stateChanged(ChangeEvent e) {
        this.newColor = this.chooser.getColor();
        if (this.isBack) {
            this.banner.setBackground(this.newColor);
            this.optionsDialog.setColor(this.nameBack, this.newColor);
        } else {
            this.banner.setForeground(this.newColor);
            this.optionsDialog.setColor(this.nameFor, this.newColor);
        }
        this.optionsDialog.saveValues();
        if (OptionsDialog.usesColorChanger != null) {
            OptionsDialog.usesColorChanger.colorChanged();
        }
    }

    class FrameListen
    implements WindowListener {
        FrameListen() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            if (!ColorChooserDialog.this.done) {
                ColorChooserDialog.this.cancel();
            }
        }

        public void windowOpened(WindowEvent e) {
        }
    }

    class CreateAndShowThread
    extends Thread {
        OptionsDialog optionsDialog;
        String nameBack;
        String nameFor;
        boolean isBack;
        JPanel contentPanel;
        Image dialogIcon;

        public CreateAndShowThread(JPanel contentPanel, OptionsDialog optionsDialog, String nameBack, String nameFor, boolean isBack, Image dialogIcon) {
            this.contentPanel = contentPanel;
            this.optionsDialog = optionsDialog;
            this.nameBack = nameBack;
            this.nameFor = nameFor;
            this.isBack = isBack;
            this.dialogIcon = dialogIcon;
        }

        public void run() {
            ColorChooserDialog.this.frame = new JFrame(ColorChooserDialog.this.bannerLabel);
            ColorChooserDialog.this.frame.setAlwaysOnTop(true);
            ColorChooserDialog.this.frame.addWindowListener(new FrameListen());
            ColorChooserDialog.this.frame.setIconImage(this.dialogIcon);
            this.contentPanel.setOpaque(true);
            ColorChooserDialog.this.frame.setContentPane(this.contentPanel);
            ColorChooserDialog.this.frame.pack();
            Dialogs.centerFrameInAvailableSpace(ColorChooserDialog.this.frame);
            ColorChooserDialog.this.frame.setVisible(true);
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorChooserDialog.this.cancel();
        }
    }

    class SaveNewColorAction
    extends AbstractAction {
        SaveNewColorAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorChooserDialog.this.dispose();
        }
    }
}

