/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskButtonUI;
import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.GraphicsOps;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.plaf.basic.BasicArrowButton;

public class JGlobaliskArrowButton
extends BasicArrowButton
implements MouseListener {
    int dir = 1;
    boolean mouseIsOver = false;
    boolean mouseIsDown = false;
    JComponent comp;
    ArrowButtonColors buttonColors;

    public JGlobaliskArrowButton(int dir, JComponent comp) {
        super(dir);
        this.dir = dir;
        this.comp = comp;
        this.buttonColors = new ArrowButtonColors();
        this.init();
    }

    public JGlobaliskArrowButton(int dir, JComponent comp, ArrowButtonColors buttonColors) {
        super(dir);
        this.dir = dir;
        this.comp = comp;
        this.buttonColors = buttonColors == null ? new ArrowButtonColors() : buttonColors;
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
        this.setOpaque(false);
    }

    public void paint(Graphics g) {
        Rectangle area = new Rectangle(0, 2, this.getWidth() - 2, this.getHeight() - 5);
        if (this.comp instanceof JSpinner) {
            area.height += 2;
            if (this.dir == 5) {
                area.y -= 2;
            }
        } else if (this.comp instanceof JScrollBar) {
            area = new Rectangle(-1, 0, this.getWidth() + 1, this.getHeight() - 1);
        }
        Color col = this.buttonColors.getBackgroundCol();
        if (this.mouseIsDown) {
            col = this.buttonColors.getBackgroundPressedCol();
        } else if (this.mouseIsOver) {
            col = this.buttonColors.getBackgroundHoverCol();
        }
        if (!this.comp.isEnabled()) {
            col = this.buttonColors.getDisabledBackgroundCol();
        }
        GlobaliskButtonUI.paintButtonBackground(g, area, this, this.mouseIsOver, this.mouseIsDown, col);
        int d = this.dir;
        if (this.comp instanceof JComboBox) {
            d = 0;
        }
        col = this.buttonColors.getBorderCol();
        if (!this.comp.isEnabled()) {
            col = this.buttonColors.getDisabledBorderCol();
        }
        GlobaliskButtonUI.paintButtonBorder(g, area, this, d, col);
        int w = this.getWidth() - 9;
        if (w < 2) {
            w = 2;
        }
        if (w % 2 != 0) {
            ++w;
        }
        col = this.buttonColors.getForegroundCol();
        if (!this.comp.isEnabled()) {
            col = this.buttonColors.getDisabledForegroundCol();
        }
        Image arrowImg = JGlobaliskArrowButton.getArrowIcon(w, this.dir, col);
        int arrowX = (int)((float)(this.getWidth() - arrowImg.getWidth(this)) / 2.0f) - 1;
        int arrowY = (int)((float)(this.getHeight() - arrowImg.getHeight(this)) / 2.0f);
        if (this.comp instanceof JSpinner) {
            arrowY = this.dir == 5 ? --arrowY : ++arrowY;
        }
        if (this.comp instanceof JScrollBar) {
            ++arrowX;
        }
        g.drawImage(arrowImg, arrowX, arrowY, this);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIsOver = false;
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseIsOver = true;
    }

    public void mousePressed(MouseEvent e) {
        this.mouseIsDown = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseIsDown = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public static Image getArrowIcon(int width, int dir, Color col) {
        int w = width;
        int h = w / 2;
        if (dir == 3 || dir == 7) {
            w = h;
            h = width;
        }
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g2 = bi.createGraphics();
        JGlobaliskArrowButton.drawArrow(g2, w, h, dir, col);
        g2.dispose();
        return bi;
    }

    private static void drawArrow(Graphics g, int w, int h, int dir, Color col) {
        g.setColor(col);
        Color col1 = GraphicsOps.getRatioCol(col, 0.88f, 1.0f);
        Color col2 = GraphicsOps.getRatioCol(col, 1.24f, 1.0f);
        Color col3 = GraphicsOps.getRatioCol(col, 0.74f, 1.0f);
        Color c1 = col1;
        Color c2 = col2;
        Color c3 = col3;
        Point a = new Point(1, h - 1);
        Point b = new Point(w - 1, h - 1);
        Point c = new Point(w / 2, 0);
        if (dir == 1) {
            for (int y = h; y >= 0; --y) {
                g.drawLine(h - y, y, w - (h - y), y);
            }
        } else if (dir == 5) {
            for (int y = h; y >= 0; --y) {
                g.drawLine(y + 1, y, w - y - 1, y);
            }
            a = new Point(w - 1, 0);
            b = new Point(1, 0);
            c = new Point(w / 2, h - 1);
            c1 = col1;
            c2 = col3;
            c3 = col2;
        } else if (dir == 3) {
            for (int x = 0; x <= w; ++x) {
                g.drawLine(x, x + 1, x, h - x - 1);
            }
            a = new Point(0, h - 1);
            b = new Point(0, 1);
            c = new Point(w - 1, h / 2);
            c1 = col1;
            c2 = col3;
            c3 = col2;
        } else if (dir == 7) {
            for (int x = 0; x <= w; ++x) {
                g.drawLine(x, w - x, x, h - (w - x));
            }
            a = new Point(w - 1, 1);
            b = new Point(w - 1, h - 1);
            c = new Point(0, h / 2);
        }
        g.setColor(c1);
        g.drawLine(b.x, b.y, c.x, c.y);
        g.setColor(c2);
        g.drawLine(a.x, a.y, c.x, c.y);
        g.setColor(c3);
        g.drawLine(a.x, a.y, b.x, b.y);
        g.setColor(c1);
        g.drawLine(a.x, a.y, a.x, a.y);
    }

    public static class ArrowButtonColors {
        public Color getBackgroundCol() {
            return GlobaliskLookAndFeel.buttonBackgroundCol;
        }

        public Color getBackgroundHoverCol() {
            return GlobaliskLookAndFeel.buttonHoverCol;
        }

        public Color getBackgroundPressedCol() {
            return GlobaliskLookAndFeel.buttonPressedCol;
        }

        public Color getDisabledBackgroundCol() {
            return GlobaliskLookAndFeel.buttonBackgroundDisabledCol;
        }

        public Color getForegroundCol() {
            return GlobaliskLookAndFeel.buttonForegroundCol;
        }

        public Color getDisabledForegroundCol() {
            return GlobaliskLookAndFeel.buttonForegroundDisabledCol;
        }

        public Color getBorderCol() {
            return GlobaliskLookAndFeel.buttonBorderCol;
        }

        public Color getDisabledBorderCol() {
            return GlobaliskLookAndFeel.buttonBorderDisabledCol;
        }
    }
}

