/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskButtonUI;
import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class GlobaliskToggleButtonUI
extends BasicToggleButtonUI {
    protected static GlobaliskToggleButtonUI buttonUI;
    protected static HashMap<AbstractButton, MouseListener> addedMouse;
    protected static HashMap<AbstractButton, Boolean> down;
    protected static HashMap<AbstractButton, Boolean> hovering;
    protected static Color hoverColor;
    protected static Color focusColor;
    protected static Color disabledTextColor;
    protected static Color backgroundColor;
    protected static Color selectedColor;

    public GlobaliskToggleButtonUI() {
        focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        selectedColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        backgroundColor = UIManager.getColor(this.getPropertyPrefix() + "background");
        hoverColor = UIManager.getColor(this.getPropertyPrefix() + "hoverBackground");
    }

    public static ComponentUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.buttonFont));
        c.setBorder(GlobaliskLookAndFeel.buttonBorder);
        if (buttonUI == null) {
            buttonUI = new GlobaliskToggleButtonUI();
        }
        return buttonUI;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (addedMouse.get(b) == null) {
            OurMouseListener ml = new OurMouseListener(b);
            b.addMouseListener(ml);
            addedMouse.put(b, ml);
            b.setRolloverEnabled(true);
        }
        Rectangle area = b.getBounds();
        GlobaliskButtonUI.paintButtonBackground(g, new Rectangle(0, 0, area.width - 1, area.height - 1), b, b.isRolloverEnabled() && hovering.get(b) != null, false);
        super.paint(g, c);
        GlobaliskButtonUI.paintButtonBorder(g, new Rectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1), b, 0);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        GlobaliskButtonUI.paintButtonBackground(g, new Rectangle(0, 0, b.getWidth() - 1, b.getHeight() - 1), b, false, true);
        GlobaliskButtonUI.paintButtonBorder(g, new Rectangle(0, 0, b.getWidth() - 1, b.getHeight() - 1), b, 0);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isEnabled() && b.hasFocus() && b.isFocusPainted() && down.get(b) == null) {
            Color savedColor = g.getColor();
            g.setColor(focusColor);
            Rectangle focusRect = iconRect.union(textRect);
            g.drawRect(focusRect.x - 3, focusRect.y, focusRect.width + 5, focusRect.height - 1);
            g.setColor(savedColor);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle area, String text) {
        AbstractButton b = (AbstractButton)c;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            g.setColor(Color.BLACK);
            g.drawString(text, area.x + 1, area.y + fm.getAscent());
            g.setColor(b.getForeground());
            g.drawString(text, area.x, area.y + fm.getAscent() - 1);
        } else {
            g.setColor(Color.BLACK);
            g.drawString(text, area.x + 1, area.y + fm.getAscent());
            g.setColor(Color.GRAY);
            g.drawString(text, area.x, area.y + fm.getAscent() - 1);
        }
    }

    static {
        addedMouse = new HashMap();
        down = new HashMap();
        hovering = new HashMap();
        hoverColor = Color.GRAY;
        focusColor = Color.WHITE;
        disabledTextColor = Color.GRAY;
        backgroundColor = Color.BLACK;
        selectedColor = GlobaliskLookAndFeel.selectionBackgroundCol;
    }

    class OurMouseListener
    implements MouseListener {
        AbstractButton b;

        public OurMouseListener(AbstractButton b) {
            this.b = b;
        }

        public void mouseExited(MouseEvent e) {
            hovering.remove(this.b);
            this.b.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            hovering.put(this.b, true);
            this.b.repaint();
        }

        public void mousePressed(MouseEvent e) {
            down.put(this.b, true);
        }

        public void mouseReleased(MouseEvent e) {
            down.remove(this.b);
        }

        public void mouseClicked(MouseEvent e) {
        }
    }
}

