/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class GlobaliskTextFieldUI
extends BasicTextFieldUI {
    JComponent ourTextField;

    public GlobaliskTextFieldUI(JComponent c) {
        this.ourTextField = c;
        c.setOpaque(false);
    }

    public static GlobaliskTextFieldUI createUI(JComponent c) {
        c.setBorder(GlobaliskLookAndFeel.textBorder);
        return new GlobaliskTextFieldUI(c);
    }

    protected void paintBackground(Graphics g) {
        GlobaliskTextFieldUI.paintTextBackAndBorder(g, this.ourTextField);
    }

    public void update(Graphics g, JComponent c) {
        if (c.getParent() == null || c.getParent().getParent() == null || !(c.getParent().getParent() instanceof JSpinner)) {
            GlobaliskTextFieldUI.paintTextBackAndBorder(g, this.ourTextField);
        }
        super.paint(g, c);
    }

    public static void paintTextBackAndBorder(Graphics g, JComponent c) {
        GlobaliskTextFieldUI.paintTextBack(g, c);
        GlobaliskTextFieldUI.paintTextBorder(g, c);
    }

    public static void paintTextBack(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(GlobaliskLookAndFeel.textBackgroundCol);
        g2.fillRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, GlobaliskLookAndFeel.textCornerRoundSize, GlobaliskLookAndFeel.textCornerRoundSize);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void paintTextBorder(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!c.isEnabled()) {
            g2.setColor(GlobaliskLookAndFeel.textDisabledBorderCol);
        } else {
            g2.setColor(GlobaliskLookAndFeel.textBorderCol);
        }
        g2.drawRoundRect(0, 0, c.getWidth() - 1, c.getHeight() - 1, GlobaliskLookAndFeel.textCornerRoundSize, GlobaliskLookAndFeel.textCornerRoundSize);
        if (!GlobaliskLookAndFeel.textAntiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }
}

