/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class GlobaliskTabbedPaneUI
extends MetalTabbedPaneUI {
    private Rectangle tempTextRect = new Rectangle();
    private Rectangle tempIconRect = new Rectangle();
    private static FontMetrics fm;
    HashMap<Integer, Integer> textX = new HashMap();
    protected static Font iFont;

    public static ComponentUI createUI(JComponent c) {
        iFont = Lang.getInternationalizedFont(GlobaliskLookAndFeel.tabbedPaneFont);
        return new GlobaliskTabbedPaneUI();
    }

    private void paintTextCenteredInRect(Graphics g, int tabIndex, String text, Rectangle rect, boolean dropShadow, Icon icon) {
        if (fm == null) {
            fm = this.tabPane.getFontMetrics(this.tabPane.getFont());
        }
        int x = rect.x + (int)(((double)rect.width - fm.getStringBounds(text, this.tabPane.getGraphics()).getWidth()) / 2.0);
        int h = (int)fm.getStringBounds(text, this.tabPane.getGraphics()).getHeight();
        int off = 2;
        int y = rect.y + rect.height - (rect.height - fm.getMaxAscent()) / 2 - off;
        if (icon != null) {
            x += icon.getIconWidth() / 2 + 2;
        }
        if (dropShadow) {
            Color fc = g.getColor();
            if (GraphicsOps.isDarkCol(fc)) {
                g.setColor(Color.LIGHT_GRAY);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString(text, x + 1, y + 1);
            g.setColor(fc);
        }
        g.drawString(text, x, y);
        this.textX.put(tabIndex, x);
    }

    private static void drawDot(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    private static Color getRatioCol(Color c, float r) {
        return GraphicsOps.getRatioCol(c, r, 1.0f);
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (tabPlacement == 1) {
            int tabCount = this.tabPane.getTabCount();
            if (selectedIndex >= 0) {
                this.paintTab(g, tabPlacement, this.rects, selectedIndex, this.tempIconRect, this.tempTextRect, true);
            }
            for (int i = this.runCount - 1; i >= 0; --i) {
                int start = this.tabRuns[i];
                int next = i == this.runCount - 1 ? this.tabRuns[0] : this.tabRuns[i + 1];
                int end = next != 0 ? next - 1 : tabCount - 1;
                for (int j = start; j <= end; ++j) {
                    if (j == selectedIndex) continue;
                    this.paintTab(g, tabPlacement, this.rects, j, this.tempIconRect, this.tempTextRect, true);
                }
            }
            if (selectedIndex >= 0) {
                this.paintTab(g, tabPlacement, this.rects, selectedIndex, this.tempIconRect, this.tempTextRect, false);
            }
        } else {
            super.paintTabArea(g, tabPlacement, selectedIndex);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean fill) {
        if (tabPlacement == 1) {
            boolean isSel = tabIndex == this.tabPane.getSelectedIndex();
            Graphics2D g2 = (Graphics2D)g;
            if (tabIndex == this.tabPane.getSelectedIndex()) {
                g2.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
            } else {
                g2.setColor(GlobaliskLookAndFeel.backgroundCol);
            }
            if (fill) {
                g2.fillRect(rects[tabIndex].x + 1, rects[tabIndex].y + 1, rects[tabIndex].width - 2, rects[tabIndex].height + 1);
            }
            g2.setFont(iFont);
            if (isSel) {
                g2.setColor(GlobaliskLookAndFeel.tabbedPaneContentBorderGrey);
            } else {
                g2.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 1.14f, 1.0f));
            }
            int offy = 0;
            if (!isSel || fill) {
                offy = 1;
            }
            g2.drawLine(rects[tabIndex].x, rects[tabIndex].y + 2, rects[tabIndex].x, rects[tabIndex].y + rects[tabIndex].height + offy);
            GlobaliskTabbedPaneUI.drawDot(g2, rects[tabIndex].x + 1, rects[tabIndex].y + 1);
            if (tabIndex != this.tabPane.getSelectedIndex()) {
                g2.setColor(GlobaliskTabbedPaneUI.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 1.0f));
            }
            g2.drawLine(rects[tabIndex].x + 2, rects[tabIndex].y, rects[tabIndex].x + rects[tabIndex].width - 3, rects[tabIndex].y);
            GlobaliskTabbedPaneUI.drawDot(g2, rects[tabIndex].x + rects[tabIndex].width - 2, rects[tabIndex].y + 1);
            if (!isSel) {
                g2.setColor(GlobaliskTabbedPaneUI.getRatioCol(g2.getColor(), 0.74f));
            }
            int rightOffY = -1;
            if (fill) {
                rightOffY = 1;
            }
            g2.drawLine(rects[tabIndex].x + rects[tabIndex].width - 1, rects[tabIndex].y + 2, rects[tabIndex].x + rects[tabIndex].width - 1, rects[tabIndex].y + rects[tabIndex].height + rightOffY);
            g2.setColor(Color.WHITE);
            if (!isSel) {
                g2.setColor(GlobaliskTabbedPaneUI.getRatioCol(g2.getColor(), 0.66f));
            }
            g2.drawLine(rects[tabIndex].x + 1, rects[tabIndex].y + 2, rects[tabIndex].x + 1, rects[tabIndex].y + rects[tabIndex].height);
            g2.drawLine(rects[tabIndex].x + rects[tabIndex].width - 2, rects[tabIndex].y + 2, rects[tabIndex].x + rects[tabIndex].width - 2, rects[tabIndex].y + rects[tabIndex].height + rightOffY);
            g2.drawLine(rects[tabIndex].x + 2, rects[tabIndex].y + 1, rects[tabIndex].x + rects[tabIndex].width - 3, rects[tabIndex].y + 1);
            Color grad = Color.WHITE;
            if (!isSel) {
                grad = GraphicsOps.getRatioCol(Color.WHITE, 0.54f, 1.0f);
            }
            if (fill) {
                GraphicsOps.paintVerticalGradient(g, grad, rects[tabIndex].x + 1, rects[tabIndex].y + 2, rects[tabIndex].width - 2, rects[tabIndex].height - 1, 0.66f, 1.0f, 0.042f * (28.0f / (float)rects[tabIndex].height), false);
            }
            if (tabIndex == this.tabPane.getSelectedIndex()) {
                g2.setColor(GlobaliskLookAndFeel.selectionForegroundCol);
            } else {
                g2.setColor(GlobaliskLookAndFeel.foregroundCol);
            }
            Icon icon = this.getIconForTab(tabIndex);
            this.paintTextCenteredInRect(g, tabIndex, this.tabPane.getTitleAt(tabIndex), rects[tabIndex], !isSel, icon);
            if (icon != null) {
                iconRect = new Rectangle(this.textX.get(tabIndex) - icon.getIconWidth() - 5, rects[tabIndex].y + rects[tabIndex].height / 2 - icon.getIconHeight() / 2 + 1, icon.getIconWidth(), icon.getIconHeight());
                this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSel);
            }
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabPlacement() == 1) {
            boolean leftToRight = this.tabPane.getComponentOrientation().isLeftToRight();
            int right = x + w - 1;
            Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
            g.setColor(GlobaliskLookAndFeel.tabbedPaneContentBorderGrey);
            if (tabPlacement != 1 || selectedIndex < 0 || selRect.y + selRect.height + 1 < y || selRect.x < x || selRect.x > x + w) {
                g.drawLine(x, y, x + w - 2, y);
                if (tabPlacement == 1) {
                    g.setColor(MetalLookAndFeel.getWhite());
                    g.drawLine(x, y + 1, x + w - 2, y + 1);
                }
            } else {
                boolean lastInRun = this.isLastInRun(selectedIndex);
                if (leftToRight || lastInRun) {
                    g.drawLine(x, y, selRect.x + 1, y);
                } else {
                    g.drawLine(x, y, selRect.x, y);
                }
                if (selRect.x + selRect.width < right - 1) {
                    g.drawLine(selRect.x + selRect.width - 2, y, right - 1, y);
                } else {
                    g.setColor(this.shadow);
                    g.drawLine(x + w - 2, y, x + w - 2, y);
                }
                g.setColor(MetalLookAndFeel.getWhite());
                g.drawLine(x, y + 1, selRect.x + 1, y + 1);
                GlobaliskTabbedPaneUI.drawDot(g, selRect.x + 1, y);
                if (selRect.x + selRect.width < right - 1) {
                    g.drawLine(selRect.x + selRect.width - 2, y + 1, right - 1, y + 1);
                    GlobaliskTabbedPaneUI.drawDot(g, selRect.x + selRect.width - 2, y);
                } else {
                    g.setColor(this.shadow);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                }
            }
        } else {
            this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabPlacement() == 1) {
            g.setColor(GlobaliskLookAndFeel.tabbedPaneContentBorderGrey);
            g.drawLine(x, y, x, y + h - 1);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        } else {
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabPlacement() != 1) {
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (this.tabPane.getTabPlacement() != 1) {
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    static {
        iFont = null;
    }
}

