/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.GlobaliskTextFieldUI;
import com.globalisk.plaf.JGlobaliskArrowButton;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.InternationalFormatter;

public class GlobaliskSpinnerUI
extends BasicSpinnerUI {
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    JComponent spin;
    JGlobaliskArrowButton.ArrowButtonColors arrowButtonColors;
    EditorTextColors editorTextColors;
    JComponent editorText;

    public GlobaliskSpinnerUI(JComponent spin) {
        this.spin = spin;
        this.editorTextColors = new EditorTextColors();
    }

    public GlobaliskSpinnerUI(JComponent spin, JGlobaliskArrowButton.ArrowButtonColors arrowButtonColors, EditorTextColors editorTextColors) {
        this.spin = spin;
        this.arrowButtonColors = arrowButtonColors;
        this.editorTextColors = editorTextColors;
        if (editorTextColors == null) {
            this.editorTextColors = new EditorTextColors();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setBorder(GlobaliskLookAndFeel.spinnerBorder);
        return new GlobaliskSpinnerUI(c);
    }

    protected Component createPreviousButton() {
        return this.createArrowButton(5, previousButtonHandler);
    }

    protected Component createNextButton() {
        return this.createArrowButton(1, nextButtonHandler);
    }

    private Component createArrowButton(int direction, ArrowButtonHandler handler) {
        JGlobaliskArrowButton b = new JGlobaliskArrowButton(direction, this.spin, this.arrowButtonColors);
        b.addActionListener(handler);
        b.addMouseListener(handler);
        return b;
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        editor.setOpaque(false);
        editor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (editor instanceof JSpinner.NumberEditor) {
            this.editorText = ((JSpinner.NumberEditor)editor).getTextField();
        } else if (editor instanceof JSpinner.DateEditor) {
            this.editorText = ((JSpinner.DateEditor)editor).getTextField();
        } else if (editor instanceof JSpinner.ListEditor) {
            this.editorText = ((JSpinner.ListEditor)editor).getTextField();
        } else if (editor instanceof JSpinner.DefaultEditor) {
            this.editorText = ((JSpinner.DefaultEditor)editor).getTextField();
        }
        if (this.editorText != null) {
            this.editorText.setOpaque(false);
            this.editorText.setBorder(GlobaliskLookAndFeel.spinnerEditorBorder);
            this.editorText.setForeground(this.editorTextColors.getEnabledTextCol());
        }
        return editor;
    }

    public void paint(Graphics g, JComponent c) {
        if (this.editorText != null) {
            this.editorText.setForeground(this.editorTextColors.getEnabledTextCol());
        }
        GlobaliskTextFieldUI.paintTextBackAndBorder(g, c);
    }

    public static class EditorTextColors {
        public Color getEnabledTextCol() {
            return GlobaliskLookAndFeel.textForegroundCol;
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        public void actionPerformed(ActionEvent e) {
            JSpinner spin = this.spinner;
            if (!(e.getSource() instanceof Timer)) {
                spin = this.eventToSpinner(e);
            }
            if (spin != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(spin);
                    spin.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)spin.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? spin.getNextValue() : spin.getPreviousValue();
                    if (value != null) {
                        spin.setValue(value);
                        this.select(spin);
                    }
                }
                catch (IllegalArgumentException iae) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spin);
                }
                catch (ParseException pe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spin);
                }
            }
        }

        private void select(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        iae.printStackTrace(System.err);
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    for (int counter = 0; counter < fields.length; ++counter) {
                        int calendarField;
                        if (!(fields[counter] instanceof DateFormat.Field) || (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) == -1) continue;
                        return calendarField;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus();
                }
            }
        }
    }
}

