/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.Lang;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class GlobaliskSliderUI
extends MetalSliderUI {
    static Image thumb;
    static Image thumbVert;
    protected static Font iFont;

    public GlobaliskSliderUI(JSlider slider) {
        thumb = GlobaliskSliderUI.getThumb(false);
        thumbVert = GlobaliskSliderUI.getThumb(true);
        slider.setBackground(UIManager.getColor("Slider.background"));
        if (!GlobaliskLookAndFeel.translucentMenus) {
            slider.setForeground(Color.BLACK);
        } else {
            slider.setForeground(UIManager.getColor("Slider.foreground"));
        }
        iFont = Lang.getInternationalizedFont(GlobaliskLookAndFeel.labelFont);
        slider.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        slider.setFont(iFont);
    }

    public static ComponentUI createUI(JComponent b) {
        return new GlobaliskSliderUI((JSlider)b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFont(iFont);
    }

    public void paintThumb(Graphics g) {
        if (this.slider.getOrientation() == 0) {
            g.drawImage(thumb, this.thumbRect.x, this.thumbRect.y + 1, this.slider);
        } else {
            g.drawImage(thumbVert, this.thumbRect.x + 1, this.thumbRect.y, this.slider);
        }
    }

    public static Image getThumb(boolean vert) {
        int w = 11;
        int h = 15;
        if (vert) {
            w = 15;
            h = 11;
        }
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(GlobaliskLookAndFeel.foregroundCol);
        GlobaliskSliderUI.drawLine(g, 0, 0, 10, 0, vert);
        GlobaliskSliderUI.drawLine(g, 0, 1, 0, 6, vert);
        GlobaliskSliderUI.drawLine(g, 10, 1, 10, 6, vert);
        GlobaliskSliderUI.drawLine(g, 1, 7, 1, 8, vert);
        GlobaliskSliderUI.drawLine(g, 9, 7, 9, 8, vert);
        GlobaliskSliderUI.drawLine(g, 2, 9, 2, 10, vert);
        GlobaliskSliderUI.drawLine(g, 8, 9, 8, 10, vert);
        GlobaliskSliderUI.drawLine(g, 3, 11, 3, 12, vert);
        GlobaliskSliderUI.drawLine(g, 7, 11, 7, 12, vert);
        GlobaliskSliderUI.drawLine(g, 4, 13, 5, 14, vert);
        GlobaliskSliderUI.drawLine(g, 6, 13, 6, 13, vert);
        if (GraphicsOps.isDarkCol(GlobaliskLookAndFeel.foregroundCol)) {
            g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.foregroundCol, 1.5f, 1.0f));
        } else {
            g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.foregroundCol, 0.5f, 1.0f));
        }
        GlobaliskSliderUI.drawLine(g, 1, 1, 9, 1, vert);
        GlobaliskSliderUI.drawLine(g, 1, 2, 1, 6, vert);
        GlobaliskSliderUI.drawLine(g, 9, 2, 9, 6, vert);
        GlobaliskSliderUI.drawLine(g, 2, 7, 2, 8, vert);
        GlobaliskSliderUI.drawLine(g, 8, 7, 8, 8, vert);
        GlobaliskSliderUI.drawLine(g, 3, 9, 3, 10, vert);
        GlobaliskSliderUI.drawLine(g, 7, 9, 7, 10, vert);
        GlobaliskSliderUI.drawLine(g, 4, 11, 4, 12, vert);
        GlobaliskSliderUI.drawLine(g, 6, 11, 6, 12, vert);
        GlobaliskSliderUI.drawLine(g, 5, 13, 5, 12, vert);
        g.setColor(Color.BLACK);
        GlobaliskSliderUI.drawLine(g, 2, 2, 8, 2, vert);
        GlobaliskSliderUI.drawLine(g, 2, 2, 2, 6, vert);
        GlobaliskSliderUI.drawLine(g, 8, 2, 8, 6, vert);
        GlobaliskSliderUI.drawLine(g, 3, 7, 3, 8, vert);
        GlobaliskSliderUI.drawLine(g, 7, 7, 7, 8, vert);
        GlobaliskSliderUI.drawLine(g, 4, 9, 4, 10, vert);
        GlobaliskSliderUI.drawLine(g, 6, 9, 6, 10, vert);
        GlobaliskSliderUI.drawLine(g, 5, 11, 5, 12, vert);
        g.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
        GlobaliskSliderUI.drawLine(g, 4, 4, 4, 6, vert);
        GlobaliskSliderUI.drawLine(g, 5, 4, 5, 8, vert);
        GlobaliskSliderUI.drawLine(g, 6, 4, 6, 6, vert);
        g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 1.25f, 1.0f));
        GlobaliskSliderUI.drawLine(g, 3, 3, 6, 3, vert);
        GlobaliskSliderUI.drawLine(g, 3, 4, 3, 6, vert);
        GlobaliskSliderUI.drawLine(g, 4, 7, 4, 8, vert);
        g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 1.1f, 1.0f));
        GlobaliskSliderUI.drawLine(g, 5, 9, 5, 9, vert);
        g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 0.9f, 1.0f));
        GlobaliskSliderUI.drawLine(g, 5, 10, 5, 10, vert);
        GlobaliskSliderUI.drawLine(g, 6, 7, 6, 8, vert);
        GlobaliskSliderUI.drawLine(g, 7, 3, 7, 3, vert);
        g.setColor(GraphicsOps.getRatioCol(GlobaliskLookAndFeel.selectionBackgroundCol, 0.75f, 1.0f));
        GlobaliskSliderUI.drawLine(g, 7, 4, 7, 6, vert);
        return bi;
    }

    private static void drawLine(Graphics g, int x, int y, int x2, int y2, boolean vert) {
        if (vert) {
            g.drawLine(y, x, y2, x2);
        } else {
            g.drawLine(x, y, x2, y2);
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        if (this.slider.getParent() instanceof JPopupMenu && GraphicsOps.isLightCol(GlobaliskLookAndFeel.popupMenuBackgroundCol)) {
            label.setForeground(Color.BLACK);
        }
        super.paintHorizontalLabel(g, value, label);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        if (this.slider.getParent() instanceof JPopupMenu && GraphicsOps.isLightCol(GlobaliskLookAndFeel.popupMenuBackgroundCol)) {
            label.setForeground(Color.BLACK);
        }
        super.paintVerticalLabel(g, value, label);
    }

    public void paint(Graphics g, JComponent c) {
        g.setFont(iFont);
        c.setFont(iFont);
        super.paint(g, c);
    }

    public void paintTrack(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(1, 1);
        g2.setColor(Color.BLACK);
        g2.setComposite(AlphaComposite.getInstance(3, 0.74f));
        int off = Math.round(this.trackRect.height / 4);
        int halfHeight = Math.round(this.trackRect.height / 2) - 1;
        g2.drawLine(this.trackRect.x, this.trackRect.y + halfHeight, this.trackRect.x + (int)this.trackRect.getWidth() - 1, this.trackRect.y + halfHeight);
        g2.drawLine(this.trackRect.x, this.trackRect.y + off, this.trackRect.x, this.trackRect.y + this.trackRect.height - off - 1);
        g2.drawLine(this.trackRect.x + this.trackRect.width - 1, this.trackRect.y + off, this.trackRect.x + this.trackRect.width - 1, this.trackRect.y + this.trackRect.height - off - 1);
        g2.translate(-1, -1);
        g2.setColor(Color.LIGHT_GRAY);
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawLine(this.trackRect.x, this.trackRect.y + halfHeight, this.trackRect.x + (int)this.trackRect.getWidth() - 1, this.trackRect.y + halfHeight);
        g2.drawLine(this.trackRect.x, this.trackRect.y + off, this.trackRect.x, this.trackRect.y + this.trackRect.height - off - 1);
        g2.drawLine(this.trackRect.x + this.trackRect.width - 1, this.trackRect.y + off, this.trackRect.x + this.trackRect.width - 1, this.trackRect.y + this.trackRect.height - off - 1);
    }

    static {
        iFont = null;
    }
}

