/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.JGlobaliskArrowButton;
import com.globalisk.util.GraphicsOps;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class GlobaliskScrollBarUI
extends MetalScrollBarUI {
    public static Color thumbBackgroundCol = GlobaliskLookAndFeel.buttonBackgroundCol;
    JComponent comp;

    public GlobaliskScrollBarUI(JComponent comp) {
        this.comp = comp;
        comp.setOpaque(false);
    }

    public static ComponentUI createUI(JComponent comp) {
        return new GlobaliskScrollBarUI(comp);
    }

    protected JButton createIncreaseButton(int orientation) {
        return new JGlobaliskArrowButton(orientation, this.comp);
    }

    protected JButton createDecreaseButton(int orientation) {
        return new JGlobaliskArrowButton(orientation, this.comp);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        g.setColor(thumbBackgroundCol);
        g.fillRect(0, 1, thumbBounds.width, thumbBounds.height - 2);
        if (this.scrollbar.getOrientation() == 1) {
            GraphicsOps.paintHorizontalGradient(g, Color.WHITE, 1, 1, thumbBounds.width - 2, thumbBounds.height - 2, 0.66f, 1.0f, 0.054f, false);
        } else {
            GraphicsOps.paintVerticalGradient(g, Color.WHITE, 1, 1, thumbBounds.width - 2, thumbBounds.height - 2, 0.66f, 1.0f, 0.054f, false);
        }
        g.setColor(GlobaliskLookAndFeel.buttonBorderCol);
        g.draw3DRect(0, 0, thumbBounds.width - 1, thumbBounds.height - 1, true);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Color bc = Color.BLACK;
        if (GraphicsOps.isDarkCol(thumbBackgroundCol)) {
            bc = Color.WHITE;
        }
        g.setColor(bc);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width - 1, trackBounds.height - 1);
        if (this.scrollbar.getOrientation() == 1) {
            if (GraphicsOps.isDarkCol(thumbBackgroundCol)) {
                GraphicsOps.paintHorizontalGradient(g, thumbBackgroundCol, trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height, 0.66f, 1.0f, 0.0242f, false);
            } else {
                GraphicsOps.paintHorizontalGradient(g, thumbBackgroundCol, trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height, 0.66f, 1.0f, 0.01974f, true);
            }
        } else if (GraphicsOps.isDarkCol(thumbBackgroundCol)) {
            GraphicsOps.paintVerticalGradient(g, thumbBackgroundCol, trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height, 0.66f, 1.0f, 0.0242f, false);
        } else {
            GraphicsOps.paintVerticalGradient(g, thumbBackgroundCol, trackBounds.x, trackBounds.y, trackBounds.x + trackBounds.width, trackBounds.y + trackBounds.height, 0.66f, 1.0f, 0.01974f, true);
        }
        g.setColor(GraphicsOps.getRatioCol(bc, 0.74f, 1.0f));
        g.draw3DRect(trackBounds.x, trackBounds.y, trackBounds.width - 1, trackBounds.height - 1, false);
    }
}

