/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.Lang;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class GlobaliskRadioButtonUI
extends MetalRadioButtonUI {
    protected Font iFont;
    static Icon selectedIcon;
    static Icon unselectedIcon;
    static Icon disabledIcon;
    static Icon disabledSelectedIcon;

    public GlobaliskRadioButtonUI(JComponent b) {
        b.setOpaque(false);
        b.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.labelFont));
        this.iFont = Lang.getInternationalizedFont(b.getFont());
    }

    public static ComponentUI createUI(JComponent b) {
        return new GlobaliskRadioButtonUI(b);
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Icon bIcon = b.getIcon();
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        g.setFont(this.iFont);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), bIcon != null ? bIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (bIcon == null) {
            if (!model.isEnabled()) {
                bIcon = model.isSelected() ? GlobaliskRadioButtonUI.getDisabledSelectedIcon() : GlobaliskRadioButtonUI.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                bIcon = b.getPressedIcon();
                if (bIcon == null) {
                    bIcon = GlobaliskRadioButtonUI.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    bIcon = b.getRolloverSelectedIcon();
                    if (bIcon == null) {
                        bIcon = GlobaliskRadioButtonUI.getSelectedIcon();
                    }
                } else {
                    bIcon = GlobaliskRadioButtonUI.getSelectedIcon();
                }
            } else {
                bIcon = GlobaliskRadioButtonUI.getUnselectedIcon();
            }
            bIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        } else {
            if (!model.isEnabled()) {
                bIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                bIcon = b.getPressedIcon();
                if (bIcon == null) {
                    bIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    bIcon = b.getRolloverSelectedIcon();
                    if (bIcon == null) {
                        bIcon = b.getSelectedIcon();
                    }
                } else {
                    bIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                bIcon = b.getRolloverIcon();
            }
            if (bIcon == null) {
                bIcon = b.getIcon();
            }
            bIcon.paintIcon(c, g, iconRect.x, iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                if (model.isEnabled()) {
                    g.setColor(b.getForeground());
                } else {
                    g.setColor(this.getDisabledTextColor());
                }
                g.drawString(text, textRect.x, textRect.y + fm.getAscent());
            }
            if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
                this.paintFocus(g, textRect, size);
            }
        }
    }

    public static Icon getSelectedIcon() {
        if (selectedIcon != null) {
            return selectedIcon;
        }
        selectedIcon = new ImageIcon(GlobaliskRadioButtonUI.getRadioIcon(true, false));
        return selectedIcon;
    }

    public static Icon getUnselectedIcon() {
        if (unselectedIcon != null) {
            return unselectedIcon;
        }
        unselectedIcon = new ImageIcon(GlobaliskRadioButtonUI.getRadioIcon(false, false));
        return unselectedIcon;
    }

    public static Icon getDisabledIcon() {
        if (disabledIcon != null) {
            return disabledIcon;
        }
        disabledIcon = new ImageIcon(GlobaliskRadioButtonUI.getRadioIcon(false, true));
        return disabledIcon;
    }

    public static Icon getDisabledSelectedIcon() {
        if (disabledSelectedIcon != null) {
            return disabledSelectedIcon;
        }
        disabledSelectedIcon = new ImageIcon(GlobaliskRadioButtonUI.getRadioIcon(true, true));
        return disabledSelectedIcon;
    }

    private static Image getRadioIcon(boolean selected, boolean disabled) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D g = bi.createGraphics();
        if (disabled) {
            g.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
        } else {
            g.setColor(GlobaliskLookAndFeel.foregroundCol);
        }
        g.drawOval(0, 0, 11, 11);
        if (selected) {
            if (!disabled) {
                g.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
            }
            g.fillOval(2, 2, 7, 7);
        }
        g.dispose();
        return bi;
    }
}

