/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;

public class GlobaliskRadioButtonMenuItemUI
extends BasicRadioButtonMenuItemUI {
    static Icon chkIcon = GlobaliskRadioButtonMenuItemUI.getCheckIcon(false, true);
    static Icon chkSelIcon = GlobaliskRadioButtonMenuItemUI.getCheckIcon(true, true);
    static Icon chkDisabled = GlobaliskRadioButtonMenuItemUI.getCheckIcon(false, false);
    static Icon chkSelDisabled = GlobaliskRadioButtonMenuItemUI.getCheckIcon(true, false);

    public static BasicRadioButtonMenuItemUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.menuItemFont));
        c.setForeground(GlobaliskLookAndFeel.popupMenuForegroundCol);
        c.setBorder(GlobaliskLookAndFeel.menuItemBorder);
        chkIcon = GlobaliskRadioButtonMenuItemUI.getCheckIcon(false, true);
        chkSelIcon = GlobaliskRadioButtonMenuItemUI.getCheckIcon(true, true);
        chkDisabled = GlobaliskRadioButtonMenuItemUI.getCheckIcon(false, false);
        chkSelDisabled = GlobaliskRadioButtonMenuItemUI.getCheckIcon(true, false);
        return new GlobaliskRadioButtonMenuItemUI();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Icon chk = chkSelIcon;
        if (!((JRadioButtonMenuItem)c).isEnabled()) {
            chk = ((JRadioButtonMenuItem)c).isSelected() ? chkSelDisabled : chkDisabled;
        } else if (!((JRadioButtonMenuItem)c).isSelected()) {
            chk = chkIcon;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintMenuItem(g2, c, chk, arrowIcon, background, foreground, defaultTextIconGap);
    }

    public static Icon getCheckIcon(boolean sel, boolean enabled) {
        BufferedImage bi = new BufferedImage(10, 10, 2);
        Graphics2D g = bi.createGraphics();
        if (!enabled) {
            g.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
        } else if (GlobaliskLookAndFeel.translucentMenus) {
            g.setColor(GlobaliskLookAndFeel.foregroundCol);
        } else {
            g.setColor(Color.BLACK);
        }
        g.drawOval(0, 0, 9, 9);
        if (!GlobaliskLookAndFeel.translucentMenus) {
            if (sel) {
                g.drawOval(2, 2, 5, 5);
            }
        } else {
            g.setColor(GraphicsOps.getRatioCol(g.getColor(), 1.0f, 0.5f));
            g.drawLine(3, 1, 6, 1);
            g.drawLine(3, 8, 6, 8);
            g.drawLine(1, 3, 1, 6);
            g.drawLine(8, 3, 8, 6);
            g.setColor(GraphicsOps.getRatioCol(g.getColor(), 1.0f, 0.13f));
            g.drawLine(2, 2, 2, 2);
            g.drawLine(7, 2, 7, 2);
            g.drawLine(2, 7, 2, 7);
            g.drawLine(7, 7, 7, 7);
        }
        if (sel) {
            if (!enabled) {
                g.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
            } else {
                g.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
            }
            g.fillRect(4, 4, 2, 2);
            g.setColor(GraphicsOps.getRatioCol(g.getColor(), 1.0f, 0.8f));
            g.drawLine(4, 3, 5, 3);
            g.drawLine(4, 6, 5, 6);
            g.drawLine(3, 4, 3, 5);
            g.drawLine(6, 4, 6, 5);
            g.setColor(GraphicsOps.getRatioCol(g.getColor(), 1.0f, 0.2f));
            g.drawLine(3, 3, 3, 3);
            g.drawLine(6, 3, 6, 3);
            g.drawLine(3, 6, 3, 6);
            g.drawLine(6, 6, 6, 6);
        }
        g.dispose();
        return new ImageIcon(bi);
    }
}

