/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.JGlobaliskMenuBar;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicMenuUI;

public class GlobaliskMenuUI
extends BasicMenuUI {
    protected static HashMap<JComponent, Boolean> hovering = new HashMap();
    boolean init = false;

    public static GlobaliskMenuUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.menuItemFont));
        c.setBorder(GlobaliskLookAndFeel.menuItemBorder);
        c.setForeground(GlobaliskLookAndFeel.popupMenuForegroundCol);
        return new GlobaliskMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    private void doInit(JMenuItem c) {
        this.init = true;
        if (c.getParent() instanceof JGlobaliskMenuBar) {
            c.setForeground(GlobaliskLookAndFeel.buttonForegroundCol);
            c.addMouseListener(new OurMouseListener(c));
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (!this.init) {
            this.doInit(this.menuItem);
        }
        super.paint(g, c);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (menuItem.isSelected()) {
            super.paintBackground(g, menuItem, bgColor);
        } else if (menuItem.getParent() instanceof JGlobaliskMenuBar && hovering.get(menuItem) != null) {
            g.setColor(GraphicsOps.getRatioCol(Color.GRAY, 0.88f, 1.0f));
            g.drawRoundRect(0, 0, menuItem.getWidth() - 1, menuItem.getHeight() - 1, 2, 2);
            GraphicsOps.paintVerticalGradient(g, Color.WHITE, 1, 1, menuItem.getWidth() - 2, menuItem.getHeight() - 1, 0.5f, 0.88f, 0.01f, false);
        } else {
            super.paintBackground(g, menuItem, bgColor);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (menuItem.isSelected()) {
            super.paintText(g, menuItem, textRect, text);
        } else if (menuItem.getParent() instanceof JGlobaliskMenuBar) {
            Color fc = menuItem.getForeground();
            g.translate(1, 1);
            if (GraphicsOps.isDarkCol(fc)) {
                g.setColor(Color.LIGHT_GRAY);
            } else {
                g.setColor(Color.BLACK);
            }
            super.paintText(g, menuItem, textRect, text);
            g.setColor(fc);
            g.translate(-1, -1);
            super.paintText(g, menuItem, textRect, text);
        } else {
            super.paintText(g, menuItem, textRect, text);
        }
    }

    static class OurMouseListener
    implements MouseListener {
        JComponent c;

        public OurMouseListener(JComponent c) {
            this.c = c;
        }

        public void mouseExited(MouseEvent e) {
            hovering.remove(this.c);
            this.c.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            hovering.put(this.c, true);
            this.c.repaint();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }
}

