/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskCheckBoxUI;
import com.globalisk.plaf.Theme;
import com.globalisk.util.GraphicsOps;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class GlobaliskLookAndFeel
extends MetalLookAndFeel {
    public static final Color MAIZE = new Color(236, 222, 20);
    public static final Color BLUE = new Color(28, 34, 67);
    public static final Color GREEN = new Color(154, 235, 154);
    public static final String GREEN_HEX = "AEFFAE";
    public static Color foregroundCol = Theme.getCol("foreground");
    public static String foregroundHexCol = Theme.getHexCol("foregroundHex");
    public static Color backgroundCol = Theme.getCol("background");
    public static String backgroundHexCol = Theme.getHexCol("backgroundHex");
    public static Color textBackgroundCol = Theme.getCol("textBackground");
    public static Color textForegroundCol = Theme.getCol("textForeground");
    public static Color textBorderCol = Theme.getCol("textBorder");
    public static Color textDisabledBorderCol = Theme.getCol("textDisabledBorder");
    public static String textForegroundHexCol = Theme.getHexCol("textForegroundHex");
    public static Color buttonBorderCol = Theme.getCol("buttonBorder");
    public static Color buttonBorderDisabledCol = Theme.getCol("buttonBorderDisabled");
    public static Color buttonBackgroundCol = Theme.getCol("buttonBackground");
    public static Color buttonBackgroundDisabledCol = Theme.getCol("buttonBackgroundDisabled");
    public static Color buttonForegroundDisabledCol = Theme.getCol("buttonForegroundDisabled");
    public static Color buttonForegroundCol = Theme.getCol("buttonForeground");
    public static Color buttonPressedCol = Theme.getCol("buttonPressed");
    public static Color buttonHoverCol = Theme.getCol("buttonHover");
    public static Color tabbedPaneForeground = Theme.getCol("tabbedPaneForeground");
    public static Color tabbedPaneUnselectedForeground = Theme.getCol("tabbedPaneUnselectedForeground");
    public static Color selectionBackgroundCol = Theme.getCol("selectionBackground");
    public static Color selectionForegroundCol = Theme.getCol("selectionForeground");
    public static Color menuSelectionBackgroundCol = Theme.getCol("menuSelectionBackground");
    public static Color menuSelectionForegroundCol = Theme.getCol("menuSelectionForeground");
    public static Color focusHighlightCol = Theme.getCol("focusHighlight");
    public static Color menuBarBackgroundCol = Theme.getCol("menuBarBackground");
    public static Color popupMenuBackgroundCol = Theme.getCol("popupMenuBackground");
    public static Color popupMenuForegroundCol = Theme.getCol("popupMenuForeground");
    public static Color popupMenuBorderCol = Theme.getCol("popupMenuBorder");
    public static Color toolTipBackgroundCol = Theme.getCol("toolTipBackground");
    public static Color toolTipForegroundCol = Theme.getCol("toolTipForeground");
    public static Color splitPaneGripLightCol = Theme.getCol("splitPaneGripLight");
    public static Color splitPaneGripDarkCol = Theme.getCol("splitPaneGripDark");
    public static Color tabbedPaneContentBorderGrey = Theme.getCol("tabbedPaneContentBorderGrey");
    public static Font PLAIN_TEXT_FONT = new Font("Arial", 0, 13);
    public static Font titledBorderFont = new Font("Arial", 1, 15);
    public static Font buttonFont = new Font("Arial", 0, 14);
    public static Font tabbedPaneFont = new Font("Verdana", 0, 15);
    public static Font menuItemFont;
    public static Font labelFont;
    public static Font checkBoxFont;
    public static Font cellRendererFont;
    public static final Border tb2;
    public static final Border tb1;
    public static Border titledBorder;
    public static Border popupMenuBorder;
    public static Border toolTipBorder;
    public static Border menuItemBorder;
    public static Border cellRendererBorder;
    public static Border spinnerEditorBorder;
    public static Border textBorder;
    public static Border buttonBorder;
    public static Border spinnerBorder;
    public static Border comboBoxBorder;
    public static int buttonCornerRoundSize;
    public static int textCornerRoundSize;
    public static int comboBoxButtonWidth;
    public static Insets tabbedPaneContentInsets;
    public static boolean textAntiAliasing;
    public static boolean translucentMenus;

    public String getID() {
        return "Globalisk Look and Feel";
    }

    public GlobaliskLookAndFeel() {
        menuItemFont = PLAIN_TEXT_FONT;
        labelFont = PLAIN_TEXT_FONT;
        checkBoxFont = PLAIN_TEXT_FONT;
        cellRendererFont = PLAIN_TEXT_FONT;
        tabbedPaneUnselectedForeground = foregroundCol;
        this.init();
    }

    private void init() {
        try {
            UIManager.put("ToolTip.background", toolTipBackgroundCol);
            UIManager.put("ToolTip.foreground", toolTipForegroundCol);
            UIManager.put("ToolTip.border", toolTipBorder);
            UIManager.put("TitledBorder.titleColor", foregroundCol);
            UIManager.put("TitledBorder.border", titledBorder);
            UIManager.put("TitledBorder.font", titledBorderFont);
            UIManager.put("Panel.background", backgroundCol);
            UIManager.put("Panel.foreground", foregroundCol);
            UIManager.put("Label.background", backgroundCol);
            UIManager.put("Label.foreground", foregroundCol);
            UIManager.put("Label.font", labelFont);
            UIManager.put("CheckBox.font", checkBoxFont);
            UIManager.put("CheckBoxMenuItem.border", menuItemBorder);
            UIManager.put("RadioButtonMenuItem.border", menuItemBorder);
            UIManager.put("CheckBoxMenuItem.font", menuItemFont);
            UIManager.put("RadioButtonMenuItem.font", menuItemFont);
            UIManager.put("SliderMenuItem.font", menuItemFont);
            UIManager.put("Button.background", buttonBackgroundCol);
            UIManager.put("Button.hoverBackground", buttonHoverCol);
            UIManager.put("Button.foreground", buttonForegroundCol);
            UIManager.put("Button.select", buttonPressedCol);
            UIManager.put("PopupMenu.border", popupMenuBorder);
            UIManager.put("Menu.selectionForeground", menuSelectionForegroundCol);
            UIManager.put("Menu.selectionBackground", menuSelectionBackgroundCol);
            UIManager.put("MenuItem.selectionForeground", menuSelectionForegroundCol);
            UIManager.put("MenuItem.selectionBackground", menuSelectionBackgroundCol);
            UIManager.put("CheckBoxMenuItem.selectionForeground", menuSelectionForegroundCol);
            UIManager.put("CheckBoxMenuItem.selectionBackground", menuSelectionBackgroundCol);
            UIManager.put("RadioButtonMenuItem.selectionForeground", menuSelectionForegroundCol);
            UIManager.put("RadioButtonMenuItem.selectionBackground", menuSelectionBackgroundCol);
            UIManager.put("TabbedPane.foreground", tabbedPaneForeground);
            UIManager.put("TabbedPane.unselectedForeground", tabbedPaneUnselectedForeground);
            UIManager.put("TabbedPane.font", tabbedPaneFont);
            UIManager.put("TabbedPane.selectHighlight", Theme.getCol("tabbedPaneSelectHighlight"));
            UIManager.put("TabbedPane.highlight", Theme.getCol("tabbedPaneHighlight"));
            UIManager.put("TabbedPane.light", Theme.getCol("tabbedPaneLight"));
            UIManager.put("TabbedPane.focus", Theme.getCol("tabbedPaneFocus"));
            UIManager.put("TabbedPane.background", backgroundCol);
            UIManager.put("TabbedPane.selected", selectionBackgroundCol);
            UIManager.put("TabbedPane.darkShadow", selectionBackgroundCol);
            UIManager.put("TabbedPane.contentAreaColor", selectionBackgroundCol);
            UIManager.put("TabbedPane.contentBorderInsets", tabbedPaneContentInsets);
            UIManager.put("Button.focus", GraphicsOps.getRatioCol(selectionBackgroundCol, 1.0f, 0.66f));
            UIManager.put("CheckBox.focus", GraphicsOps.getRatioCol(selectionBackgroundCol, 1.0f, 0.66f));
            UIManager.put("RadioButton.focus", GraphicsOps.getRatioCol(selectionBackgroundCol, 1.0f, 0.66f));
            UIManager.put("CheckBox.background", backgroundCol);
            UIManager.put("CheckBox.foreground", foregroundCol);
            UIManager.put("CheckBox.margin", new Insets(0, 0, 0, 0));
            UIManager.put("CheckBox.icon", new ImageIcon(GlobaliskCheckBoxUI.getCheckBoxIcon()));
            UIManager.put("CheckBox.iconChecked", new ImageIcon(GlobaliskCheckBoxUI.getCheckBoxCheckedIcon()));
            UIManager.put("CheckBox.iconPressed", new ImageIcon(GlobaliskCheckBoxUI.getCheckBoxCheckedIcon()));
            UIManager.put("CheckBox.iconPressedChecked", new ImageIcon(GlobaliskCheckBoxUI.getCheckBoxCheckedIcon()));
            UIManager.put("CheckBox.iconDisabled", new ImageIcon(GlobaliskCheckBoxUI.getCheckBoxDisabledIcon()));
            UIManager.put("RadioButton.background", backgroundCol);
            UIManager.put("RadioButton.foreground", foregroundCol);
            UIManager.put("ScrollPane.background", backgroundCol);
            UIManager.put("ScrollPane.foreground", foregroundCol);
            UIManager.put("Slider.background", backgroundCol);
            UIManager.put("Slider.foreground", foregroundCol);
            UIManager.put("OptionPane.background", backgroundCol);
            UIManager.put("OptionPane.messageForeground", foregroundCol);
            UIManager.put("EditorPane.background", textBackgroundCol);
            UIManager.put("TextField.background", textBackgroundCol);
            UIManager.put("TextField.foreground", textForegroundCol);
            UIManager.put("FormattedTextField.background", textBackgroundCol);
            UIManager.put("FormattedTextField.foreground", textForegroundCol);
            UIManager.put("PasswordField.background", textBackgroundCol);
            UIManager.put("PasswordField.foreground", textForegroundCol);
            UIManager.put("TextArea.background", textBackgroundCol);
            UIManager.put("TextArea.foreground", textForegroundCol);
            UIManager.put("TextPane.background", textBackgroundCol);
            UIManager.put("TextPane.foreground", textForegroundCol);
            UIManager.put("ComboBox.background", textBackgroundCol);
            UIManager.put("ComboBox.foreground", textForegroundCol);
            UIManager.put("Spinner.background", textBackgroundCol);
            UIManager.put("Spinner.foreground", textForegroundCol);
            UIManager.put("Table.background", textBackgroundCol);
            UIManager.put("Table.foreground", textForegroundCol);
            UIManager.put("DesktopPane.background", textBackgroundCol);
            UIManager.put("DesktopPane.foreground", textForegroundCol);
            UIManager.put("List.background", textBackgroundCol);
            UIManager.put("List.foreground", textForegroundCol);
            UIManager.put("ColorChooser.background", backgroundCol);
            UIManager.put("ColorChooser.foreground", foregroundCol);
            UIManager.put("Viewport.background", backgroundCol);
            UIManager.put("Viewport.foreground", foregroundCol);
            UIManager.put("Dialog.background", backgroundCol);
            UIManager.put("Dialog.foreground", foregroundCol);
            UIManager.put("Frame.background", backgroundCol);
            UIManager.put("Frame.foreground", foregroundCol);
            UIManager.put("Window.background", backgroundCol);
            UIManager.put("Window.foreground", foregroundCol);
            UIManager.put("ComboBox.selectionBackground", selectionBackgroundCol);
            UIManager.put("ComboBox.selectionForeground", selectionForegroundCol);
            UIManager.put("FormattedTextField.selectionBackground", selectionBackgroundCol);
            UIManager.put("FormattedTextField.selectionForeground", selectionForegroundCol);
            UIManager.put("TextField.selectionBackground", selectionBackgroundCol);
            UIManager.put("TextField.selectionForeground", selectionForegroundCol);
            UIManager.put("TextArea.selectionBackground", selectionBackgroundCol);
            UIManager.put("TextArea.selectionForeground", selectionForegroundCol);
            UIManager.put("PasswordField.selectionBackground", selectionBackgroundCol);
            UIManager.put("PasswordField.selectionForeground", selectionForegroundCol);
            UIManager.put("TextPane.selectionBackground", selectionBackgroundCol);
            UIManager.put("TextPane.selectionForeground", selectionForegroundCol);
            UIManager.put("EditorPane.selectionBackground", selectionBackgroundCol);
            UIManager.put("EditorPane.selectionForeground", selectionForegroundCol);
            UIManager.put("List.selectionBackground", selectionBackgroundCol);
            UIManager.put("List.selectionForeground", selectionForegroundCol);
            UIManager.put("DesktopPane.selectionBackground", selectionBackgroundCol);
            UIManager.put("DesktopPane.selectionForeground", selectionForegroundCol);
            UIManager.put("TextField.caretForeground", selectionBackgroundCol);
            UIManager.put("FormattedTextField.caretForeground", selectionBackgroundCol);
            UIManager.put("PasswordField.caretForeground", selectionBackgroundCol);
            UIManager.put("TextArea.caretForeground", selectionBackgroundCol);
            UIManager.put("TextPane.caretForeground", selectionBackgroundCol);
            UIManager.put("EditorPane.caretForeground", selectionBackgroundCol);
            UIManager.put("CheckBox.iconTextGap", 2);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public String getDescription() {
        return "Globalisk Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String pfix = "com.globalisk.plaf.Globalisk";
        Object[] defaults = new Object[]{"ButtonUI", pfix + "ButtonUI", "ToggleButtonUI", pfix + "ToggleButtonUI", "ComboBoxUI", pfix + "ComboBoxUI", "MenuUI", pfix + "MenuUI", "MenuItemUI", pfix + "MenuItemUI", "CheckBoxMenuItemUI", pfix + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", pfix + "RadioButtonMenuItemUI", "PopupMenuUI", pfix + "PopupMenuUI", "TextFieldUI", pfix + "TextFieldUI", "FormattedTextFieldUI", pfix + "TextFieldUI", "PasswordFieldUI", pfix + "PasswordFieldUI", "TextAreaUI", pfix + "TextAreaUI", "ScrollPaneUI", pfix + "ScrollPaneUI", "TabbedPaneUI", pfix + "TabbedPaneUI", "CheckBoxUI", pfix + "CheckBoxUI", "RadioButtonUI", pfix + "RadioButtonUI", "ScrollBarUI", pfix + "ScrollBarUI", "SliderUI", pfix + "SliderUI", "SpinnerUI", pfix + "SpinnerUI", "SplitPaneUI", pfix + "SplitPaneUI", "SeparatorUI", pfix + "SeparatorUI", "PanelUI", pfix + "PanelUI", "LabelUI", pfix + "LabelUI", "TreeUI", "javax.swing.plaf.metal.MetalTreeUI"};
        table.putDefaults(defaults);
    }

    static {
        tb2 = BorderFactory.createMatteBorder(1, 1, 1, 1, Theme.getCol("titledBorderCol1"));
        tb1 = BorderFactory.createMatteBorder(1, 1, 1, 1, Theme.getCol("titledBorderCol2"));
        titledBorder = BorderFactory.createCompoundBorder(tb1, tb2);
        popupMenuBorder = BorderFactory.createLineBorder(popupMenuBorderCol);
        toolTipBorder = BorderFactory.createLineBorder(Theme.getCol("toolTipBorder"));
        menuItemBorder = BorderFactory.createEmptyBorder(3, 2, 3, 2);
        cellRendererBorder = BorderFactory.createEmptyBorder(5, 6, 5, 4);
        spinnerEditorBorder = BorderFactory.createEmptyBorder(4, 6, 3, 4);
        textBorder = BorderFactory.createEmptyBorder(4, 6, 5, 4);
        buttonBorder = BorderFactory.createEmptyBorder(4, 9, 4, 9);
        spinnerBorder = BorderFactory.createEmptyBorder(0, 0, 1, 0);
        comboBoxBorder = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        buttonCornerRoundSize = 3;
        textCornerRoundSize = 8;
        comboBoxButtonWidth = 18;
        tabbedPaneContentInsets = new Insets(5, 4, 4, 4);
        textAntiAliasing = false;
        translucentMenus = true;
    }
}

