/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskComboBoxUI;
import com.globalisk.plaf.GlobaliskLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class GlobaliskListCellRenderer
extends JLabel
implements ListCellRenderer {
    GlobaliskComboBoxUI comp;
    boolean hasFocus = false;

    public GlobaliskListCellRenderer(GlobaliskComboBoxUI comp) {
        this.comp = comp;
        this.setBorder(GlobaliskLookAndFeel.cellRendererBorder);
        this.setOpaque(false);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value.toString());
        if (isSelected) {
            this.setForeground(GlobaliskLookAndFeel.selectionForegroundCol);
            this.setOpaque(true);
        } else {
            this.setForeground(GlobaliskLookAndFeel.foregroundCol);
            this.setOpaque(false);
        }
        this.setEnabled(list.isEnabled());
        this.hasFocus = cellHasFocus;
        return this;
    }

    public void paintComponent(Graphics g) {
        boolean wasOpaque = this.isOpaque();
        if (wasOpaque) {
            this.setOpaque(false);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fillRoundRect(2, 2, this.getWidth() - 4, this.getHeight() - 4, GlobaliskLookAndFeel.buttonCornerRoundSize, GlobaliskLookAndFeel.buttonCornerRoundSize);
            if (!GlobaliskLookAndFeel.textAntiAliasing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            super.paintComponent(g);
        } else {
            super.paintComponent(g);
        }
        if (this.comp.getPopup().isVisible()) {
            g.setColor(GlobaliskLookAndFeel.textBackgroundCol);
            g.drawLine(0, 0, 0, this.getHeight() - 1);
        }
        this.setOpaque(wasOpaque);
    }

    public void paintBorder(Graphics g) {
    }
}

