/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskComboBoxEditor;
import com.globalisk.plaf.GlobaliskComboPopup;
import com.globalisk.plaf.GlobaliskListCellRenderer;
import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.plaf.GlobaliskTextFieldUI;
import com.globalisk.plaf.JGlobaliskArrowButton;
import com.globalisk.util.Lang;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class GlobaliskComboBoxUI
extends BasicComboBoxUI {
    JComponent combo;
    private ComboPopup pops;

    public GlobaliskComboBoxUI(JComponent combo) {
        this.combo = combo;
    }

    public static ComponentUI createUI(JComponent c) {
        GlobaliskComboBoxUI ret = new GlobaliskComboBoxUI(c);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.cellRendererFont));
        c.setOpaque(false);
        ((JComboBox)c).setRenderer(new GlobaliskListCellRenderer(ret));
        ((JComboBox)c).setEditor(new GlobaliskComboBoxEditor((JComboBox)c));
        c.setBorder(GlobaliskLookAndFeel.comboBoxBorder);
        return ret;
    }

    protected ComboPopup createPopup() {
        this.pops = new GlobaliskComboPopup(this.comboBox);
        return this.pops;
    }

    public ComboPopup getPopup() {
        return this.pops;
    }

    protected JButton createArrowButton() {
        return new JGlobaliskArrowButton(5, this.combo);
    }

    public void paint(Graphics g, JComponent c) {
        GlobaliskTextFieldUI.paintTextBack(g, c);
        super.paint(g, c);
        GlobaliskTextFieldUI.paintTextBorder(g, c);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component renderer = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, hasFocus, hasFocus);
        if (!this.comboBox.isEnabled()) {
            renderer.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            renderer.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        } else if (hasFocus) {
            renderer.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            renderer.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
        }
        this.currentValuePane.paintComponent(g, renderer, this.comboBox, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            if (parent == null) {
                throw new NullPointerException();
            }
            return new Dimension(0, 0);
        }

        public Dimension minimumLayoutSize(Container parent) {
            if (parent == null) {
                throw new NullPointerException();
            }
            return new Dimension(0, 0);
        }

        public void layoutContainer(Container parent) {
            Rectangle bounds = GlobaliskComboBoxUI.this.comboBox.getBounds();
            Insets insets = GlobaliskComboBoxUI.this.getInsets();
            Rectangle textEditorBounds = new Rectangle();
            int arrowButtonHeight = bounds.height - insets.top - insets.bottom;
            int arrowButtonWidth = GlobaliskLookAndFeel.comboBoxButtonWidth;
            if (GlobaliskComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight()) {
                GlobaliskComboBoxUI.this.arrowButton.setBounds(bounds.width - arrowButtonWidth - insets.right, insets.top, arrowButtonWidth, arrowButtonHeight);
                textEditorBounds.setBounds(insets.left, insets.top, bounds.width - insets.left - insets.right - arrowButtonWidth, arrowButtonHeight);
                if (GlobaliskComboBoxUI.this.comboBox.isEditable()) {
                    GlobaliskComboBoxUI.this.editor.setBounds(textEditorBounds);
                }
            } else {
                GlobaliskComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, arrowButtonWidth, arrowButtonHeight);
                textEditorBounds.setBounds(insets.left + arrowButtonWidth, insets.top, bounds.width - insets.left - insets.right - arrowButtonWidth, arrowButtonHeight);
                if (GlobaliskComboBoxUI.this.comboBox.isEditable()) {
                    GlobaliskComboBoxUI.this.editor.setBounds(textEditorBounds);
                }
            }
        }
    }
}

