/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class GlobaliskCheckBoxUI
extends BasicCheckBoxUI {
    private static final GlobaliskCheckBoxUI checkboxUI = new GlobaliskCheckBoxUI();
    private static final String propertyPrefix = "CheckBox.";
    protected Icon uncheckedIcon;
    protected Icon checkedIcon;
    protected Icon pressedIcon;
    protected Icon pressedCheckedIcon;
    protected Icon disabledIcon;
    protected Color focus;
    protected Color focusHighlight;
    protected Color disabledTextColor;
    protected int iconTextGap = 2;
    protected Font iFont = null;

    public static ComponentUI createUI(JComponent b) {
        b.setOpaque(false);
        return checkboxUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
        this.iFont = Lang.getInternationalizedFont(c.getFont());
        c.setFont(this.iFont);
        this.uncheckedIcon = UIManager.getIcon("CheckBox.icon");
        this.checkedIcon = UIManager.getIcon("CheckBox.iconChecked");
        this.pressedIcon = UIManager.getIcon("CheckBox.iconPressed");
        this.pressedCheckedIcon = UIManager.getIcon("CheckBox.iconPressedChecked");
        this.disabledIcon = UIManager.getIcon("CheckBox.iconDisabled");
        this.focus = UIManager.getColor("CheckBox.focus");
        this.focusHighlight = UIManager.getColor("CheckBox.focusHighlight");
        this.disabledTextColor = UIManager.getColor("CheckBox.disabledText");
        this.iconTextGap = UIManager.getInt("CheckBox.iconTextGap");
    }

    public String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension d = b.getSize();
        g.setFont(this.iFont);
        FontMetrics fm = g.getFontMetrics();
        this.icon = !model.isEnabled() ? this.disabledIcon : (model.isSelected() ? (model.isPressed() ? this.pressedCheckedIcon : this.checkedIcon) : (model.isPressed() ? this.pressedIcon : this.uncheckedIcon));
        g.setColor(b.getForeground());
        int y = 0;
        int x = 0;
        if (this.icon != null) {
            y = (d.height - this.icon.getIconHeight()) / 2 + 1;
            this.icon.paintIcon(c, g, 0, y);
            x = this.icon.getIconWidth() + this.iconTextGap + 1;
        }
        y = (d.height + fm.getAscent()) / 2;
        if (!b.isEnabled()) {
            g.setColor(this.disabledTextColor);
        }
        if (b.getText() != null) {
            g.drawString(b.getText(), x, y);
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            g.setColor(this.focus);
            g.drawRect(x - 2, y - fm.getAscent() - 1, d.width - x, fm.getAscent() + fm.getDescent());
        }
    }

    public static Image getCheckBoxIcon() {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D g = bi.createGraphics();
        GlobaliskCheckBoxUI.drawCheckBoxBackground(g, bi);
        GlobaliskCheckBoxUI.drawCheckBoxBorder(g, bi, false);
        g.dispose();
        return bi;
    }

    public static Image getCheckBoxCheckedIcon() {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D g = bi.createGraphics();
        GlobaliskCheckBoxUI.drawCheckBoxBackground(g, bi);
        g.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
        g.fillRect(5, 5, 7, 7);
        ((Graphics)g).draw3DRect(5, 5, 6, 6, true);
        GlobaliskCheckBoxUI.drawCheckBoxBorder(g, bi, false);
        g.dispose();
        return bi;
    }

    public static Image getCheckBoxPressedIcon() {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(GlobaliskLookAndFeel.buttonPressedCol);
        g.fillRect(5, 5, 7, 7);
        GlobaliskCheckBoxUI.drawCheckBoxBorder(g, bi, false);
        g.dispose();
        return bi;
    }

    public static Image getCheckBoxDisabledIcon() {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D g = bi.createGraphics();
        GlobaliskCheckBoxUI.drawCheckBoxBackground(g, bi);
        GlobaliskCheckBoxUI.drawCheckBoxBorder(g, bi, true);
        g.dispose();
        return bi;
    }

    private static void drawCheckBoxBackground(Graphics g, Image img) {
        g.setColor(GlobaliskLookAndFeel.textBackgroundCol);
        g.fillRect(2, 2, img.getWidth(null) - 4, img.getHeight(null) - 4);
    }

    private static void drawCheckBoxBorder(Graphics g, Image img, boolean disabled) {
        if (disabled) {
            g.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
        } else {
            g.setColor(GlobaliskLookAndFeel.foregroundCol);
        }
        g.draw3DRect(2, 2, img.getWidth(null) - 4, img.getHeight(null) - 4, true);
        g.draw3DRect(3, 3, img.getWidth(null) - 6, img.getHeight(null) - 6, false);
    }
}

