/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.Lang;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicCheckBoxMenuItemUI;

public class GlobaliskCheckBoxMenuItemUI
extends BasicCheckBoxMenuItemUI {
    static Icon chkIcon = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(false, true));
    static Icon chkSelIcon = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(true, true));
    static Icon chkDisabled = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(false, false));
    static Icon chkSelDisabled = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(true, false));

    public static BasicCheckBoxMenuItemUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.menuItemFont));
        c.setBorder(GlobaliskLookAndFeel.menuItemBorder);
        c.setForeground(GlobaliskLookAndFeel.popupMenuForegroundCol);
        chkIcon = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(false, true));
        chkSelIcon = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(true, true));
        chkDisabled = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(false, false));
        chkSelDisabled = new ImageIcon(GlobaliskCheckBoxMenuItemUI.getCheckIcon(true, false));
        return new GlobaliskCheckBoxMenuItemUI();
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        Icon chk = chkSelIcon;
        if (!((JCheckBoxMenuItem)c).isEnabled()) {
            chk = ((JCheckBoxMenuItem)c).isSelected() ? chkSelDisabled : chkDisabled;
        } else if (!((JCheckBoxMenuItem)c).isSelected()) {
            chk = chkIcon;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintMenuItem(g2, c, chk, arrowIcon, background, foreground, defaultTextIconGap);
    }

    public static Image getCheckIcon(boolean sel, boolean enabled) {
        BufferedImage bi = new BufferedImage(10, 10, 2);
        Graphics2D g2 = bi.createGraphics();
        if (sel) {
            if (!enabled) {
                g2.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
            } else {
                g2.setColor(GlobaliskLookAndFeel.selectionBackgroundCol);
            }
            g2.fillRect(3, 3, 4, 4);
            g2.setComposite(AlphaComposite.getInstance(3, 0.66f));
            g2.draw3DRect(2, 2, 5, 5, true);
            g2.setColor(Color.BLACK);
            g2.draw3DRect(2, 2, 5, 5, true);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        if (!enabled) {
            g2.setColor(GlobaliskLookAndFeel.buttonBorderDisabledCol);
        } else if (GlobaliskLookAndFeel.translucentMenus) {
            g2.setColor(GlobaliskLookAndFeel.foregroundCol);
        } else {
            g2.setColor(Color.BLACK);
        }
        g2.draw3DRect(0, 0, 9, 9, true);
        if (GlobaliskLookAndFeel.translucentMenus) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.draw3DRect(1, 1, 7, 7, false);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        g2.dispose();
        return bi;
    }
}

