/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.plaf;

import com.globalisk.plaf.GlobaliskLookAndFeel;
import com.globalisk.util.GraphicsOps;
import com.globalisk.util.Lang;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class GlobaliskButtonUI
extends MetalButtonUI {
    protected static GlobaliskButtonUI buttonUI;
    protected static HashMap<AbstractButton, MouseListener> addedMouse;
    protected static HashMap<AbstractButton, Boolean> down;
    protected static HashMap<AbstractButton, Boolean> hovering;
    protected static Color hoverColor;
    protected static Color backgroundColor;
    protected static Color selectedColor;

    public GlobaliskButtonUI() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        selectedColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        backgroundColor = UIManager.getColor(this.getPropertyPrefix() + "background");
        hoverColor = UIManager.getColor(this.getPropertyPrefix() + "hoverBackground");
    }

    public static ComponentUI createUI(JComponent c) {
        c.setOpaque(false);
        c.setFont(Lang.getInternationalizedFont(GlobaliskLookAndFeel.buttonFont));
        c.setBorder(GlobaliskLookAndFeel.buttonBorder);
        if (buttonUI == null) {
            buttonUI = new GlobaliskButtonUI();
        }
        return buttonUI;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (addedMouse.get(b) == null) {
            OurMouseListener ml = new OurMouseListener(b);
            b.addMouseListener(ml);
            addedMouse.put(b, ml);
        }
        Rectangle area = b.getBounds();
        GlobaliskButtonUI.paintButtonBackground(g, new Rectangle(0, 0, area.width - 1, area.height - 1), b, b.isRolloverEnabled() && hovering.get(b) != null, false);
        super.paint(g, c);
        GlobaliskButtonUI.paintButtonBorder(g, new Rectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1), b, 0);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        GlobaliskButtonUI.paintButtonBackground(g, new Rectangle(0, 0, b.getWidth() - 1, b.getHeight() - 1), b, false, true);
        GlobaliskButtonUI.paintButtonBorder(g, new Rectangle(0, 0, b.getWidth() - 1, b.getHeight() - 1), b, 0);
    }

    public static void paintButtonBackground(Graphics g, Rectangle area, AbstractButton b, boolean hover, boolean down) {
        GlobaliskButtonUI.paintButtonBackground(g, area, b, hover, down, null);
    }

    public static void paintButtonBackground(Graphics g, Rectangle area, AbstractButton b, boolean hover, boolean down, Color background) {
        Color col = background;
        if (col == null) {
            col = b.isEnabled() ? (down ? GlobaliskLookAndFeel.buttonPressedCol : (hover ? GlobaliskLookAndFeel.buttonHoverCol : GlobaliskLookAndFeel.buttonBackgroundCol)) : GlobaliskLookAndFeel.buttonBackgroundDisabledCol;
        }
        g.setColor(col);
        g.fillRoundRect(area.x + 1, area.y, area.width - 2, area.height, GlobaliskLookAndFeel.buttonCornerRoundSize, GlobaliskLookAndFeel.buttonCornerRoundSize);
        boolean topLight = false;
        Color grad = Color.WHITE;
        if (GraphicsOps.isLightCol(col)) {
            grad = Color.BLACK;
            topLight = true;
        }
        GraphicsOps.paintVerticalGradient(g, grad, area.x + 2, area.y + 1, area.width - 4, area.height - 1, 0.66f, 1.0f, 0.042f * (28.0f / (float)area.height), topLight);
    }

    public static void paintButtonBorder(Graphics g, Rectangle area, AbstractButton b, int dir) {
        GlobaliskButtonUI.paintButtonBorder(g, area, b, dir, null);
    }

    public static void paintButtonBorder(Graphics g, Rectangle area, AbstractButton b, int dir, Color col) {
        Color lightCol = GlobaliskLookAndFeel.buttonBorderCol;
        if (col == null) {
            if (!b.isEnabled()) {
                lightCol = GlobaliskLookAndFeel.buttonBorderDisabledCol;
            }
        } else {
            lightCol = col;
        }
        g.setColor(lightCol);
        g.drawLine(area.x + 3, area.y, area.x + area.width - 3, area.y);
        g.drawLine(area.x + 1, area.y + 2, area.x + 1, area.y + area.height - 2);
        Color darkCol = new Color((int)((float)g.getColor().getRed() * 0.88f), (int)((float)g.getColor().getGreen() * 0.88f), (int)((float)g.getColor().getBlue() * 0.88f));
        g.setColor(darkCol);
        g.drawLine(area.x + 3, area.y + area.height, area.x + area.width - 3, area.y + area.height);
        g.drawLine(area.x + area.width - 1, area.y + 2, area.x + area.width - 1, area.y + area.height - 2);
        if (dir == 1 || dir == 7) {
            g.drawLine(area.x + area.width - 2, area.y + area.height, area.x + area.width - 1, area.y + area.height);
            GlobaliskButtonUI.drawDot(g, area.x + area.width - 1, area.y + area.height - 1);
        } else {
            GlobaliskButtonUI.drawDot(g, area.x + area.width - 2, area.y + area.height - 1);
        }
        if (dir == 1 || dir == 3) {
            g.drawLine(area.x + 1, area.y + area.height, area.x + 2, area.y + area.height);
            GlobaliskButtonUI.drawDot(g, area.x + 1, area.y + area.height - 1, lightCol);
        } else {
            GlobaliskButtonUI.drawDot(g, area.x + 2, area.y + area.height - 1);
        }
        g.setColor(lightCol);
        if (dir == 5 || dir == 3) {
            g.drawLine(area.x + 1, area.y, area.x + 2, area.y);
            GlobaliskButtonUI.drawDot(g, area.x + 1, area.y + 1);
        } else {
            GlobaliskButtonUI.drawDot(g, area.x + 2, area.y + 1);
        }
        if (dir == 5 || dir == 7) {
            g.drawLine(area.x + area.width - 2, area.y, area.x + area.width - 1, area.y);
            GlobaliskButtonUI.drawDot(g, area.x + area.width - 1, area.y + 1, darkCol);
        } else {
            GlobaliskButtonUI.drawDot(g, area.x + area.width - 2, area.y + 1);
        }
    }

    private static void drawDot(Graphics g, int x, int y) {
        GlobaliskButtonUI.drawDot(g, x, y, null);
    }

    private static void drawDot(Graphics g, int x, int y, Color col) {
        if (col != null) {
            g.setColor(col);
        }
        g.drawLine(x, y, x, y);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.isEnabled() && b.hasFocus() && b.isFocusPainted() && down.get(b) == null) {
            Color savedColor = g.getColor();
            g.setColor(this.getFocusColor());
            Rectangle focusRect = iconRect.union(textRect);
            g.drawRect(focusRect.x - 3, focusRect.y - 1, focusRect.width + 5, focusRect.height);
            g.setColor(savedColor);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle area, String text) {
        AbstractButton b = (AbstractButton)c;
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (b.isEnabled()) {
            if (GraphicsOps.isDarkCol(b.getForeground())) {
                g.setColor(Color.LIGHT_GRAY);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawString(text, area.x + 1, area.y + fm.getAscent());
            g.setColor(b.getForeground());
            g.drawString(text, area.x, area.y + fm.getAscent() - 1);
        } else {
            g.setColor(Color.BLACK);
            g.drawString(text, area.x + 1, area.y + fm.getAscent());
            g.setColor(GlobaliskLookAndFeel.buttonForegroundDisabledCol);
            g.drawString(text, area.x, area.y + fm.getAscent() - 1);
        }
    }

    static {
        addedMouse = new HashMap();
        down = new HashMap();
        hovering = new HashMap();
        hoverColor = Color.GRAY;
        backgroundColor = Color.BLACK;
        selectedColor = GlobaliskLookAndFeel.selectionBackgroundCol;
    }

    class OurMouseListener
    implements MouseListener {
        AbstractButton b;

        public OurMouseListener(AbstractButton b) {
            this.b = b;
        }

        public void mouseExited(MouseEvent e) {
            hovering.remove(this.b);
            this.b.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            hovering.put(this.b, true);
            this.b.repaint();
        }

        public void mousePressed(MouseEvent e) {
            down.put(this.b, true);
        }

        public void mouseReleased(MouseEvent e) {
            down.remove(this.b);
        }

        public void mouseClicked(MouseEvent e) {
        }
    }
}

