/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.mediashuffle;

import com.globalisk.mediashuffle.AppFrameView;
import com.globalisk.mediashuffle.AppGUI;
import com.globalisk.util.Files;
import com.globalisk.util.Options;
import java.awt.Dimension;
import java.io.File;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;

public class MediaShuffle
extends SingleFrameApplication {
    public static final String appName = "Media Shuffle";
    public static final String fullAppName = "Globalisk Media Shuffle";
    public static Options opts = null;
    public static final String stateDirname = System.getProperty("user.home") + "/.GlobaliskMediaShuffle";
    public static final String optsFilename = stateDirname + "/opts.dat";
    public static AppGUI gui;

    public static void main(String[] args) {
        MediaShuffle.launch(MediaShuffle.class, args);
    }

    public MediaShuffle() {
        this.init();
    }

    private void init() {
        File stateDir = new File(stateDirname);
        if (!stateDir.exists()) {
            stateDir.mkdir();
            opts = new Options();
        } else if (new File(optsFilename).exists()) {
            opts = (Options)Files.getSerializedObject((String)optsFilename);
        }
        if (opts == null) {
            opts = new Options();
        }
    }

    public static void saveOpts() {
        MediaShuffle.opts.strings.put("Source media folder", gui.getFolderLocation());
        MediaShuffle.opts.strings.put("Media player", gui.getMediaPlayer());
        MediaShuffle.opts.integers.put("Num files", gui.getNumFiles());
        MediaShuffle.opts.integers.put("Play mode", gui.getPlayMode());
        MediaShuffle.opts.booleans.put("Loop", gui.getLoop());
        Files.putSerializedObject((String)optsFilename, (Object)opts);
    }

    public static void shutDown() {
        MediaShuffle.saveOpts();
        System.exit(0);
    }

    public static boolean getBooleanOption(String name, boolean initVal) {
        Boolean ret = (Boolean)MediaShuffle.opts.booleans.get(name);
        if (ret == null) {
            ret = initVal;
        }
        return ret;
    }

    public static String getStringOption(String name, String initVal) {
        String ret = (String)MediaShuffle.opts.strings.get(name);
        if (ret == null) {
            ret = initVal;
        }
        return ret;
    }

    public static int getIntegerOption(String name, int initVal) {
        if (MediaShuffle.opts.integers.get(name) != null) {
            return (Integer)MediaShuffle.opts.integers.get(name);
        }
        return initVal;
    }

    protected void startup() {
        try {
            UIManager.setLookAndFeel("com.globalisk.plaf.GlobaliskLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        gui = new AppGUI();
        this.show(new AppFrameView(this));
        this.getMainFrame().setMinimumSize(new Dimension(400, 400));
    }

    protected void shutdown() {
        MediaShuffle.saveOpts();
    }

    public static MediaShuffle getApplication() {
        return Application.getInstance(MediaShuffle.class);
    }
}

