/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.mediashuffle;

import com.globalisk.mediashuffle.AboutBox;
import com.globalisk.mediashuffle.AppFrameView;
import com.globalisk.mediashuffle.MediaShuffle;
import com.globalisk.plaf.GlobaliskPanelUI;
import com.globalisk.plaf.JGlobaliskBorderPanel;
import com.globalisk.util.BrowserLaunch;
import com.globalisk.util.Dialogs;
import com.globalisk.util.Lang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class AppGUI
extends JPanel {
    public static String defaultSourceMediaFolder = System.getProperty("user.home");
    ArrayList<JCheckBox> checkBoxes;
    HashMap<String, Boolean> alreadyCopied;
    String defaultMediaPlayer = "C:\\Program Files\\Windows Media Player\\wmplayer.exe";
    StringBuffer vidsList;
    JPanel p = new JTransparentPanel();
    JButton launchButton;
    JSpinner launchSpinner;
    JComboBox launchTypeCombo;
    JCheckBox playInLoopCheckBox;
    JButton selectAll;
    JButton clearAll;
    Font labelFont = new Font("Arial", 1, 13);
    JPanel browseTexts;
    JTextField mediaPlayerTextField = new JTextField();
    JTextField folderLocationTextField = new JTextField();
    Box foldersList;
    JScrollPane sp;
    public static String[] videoExt = new String[]{"avi", "mpg", "mpeg", "mov", "wmv", "qt", "3g2", "3gp", "asf", "asx", "flv", "mp4", "rm", "swf", "vob"};
    public static String[] audioExt = new String[]{"3gp", "act", "aiff", "aac", "alac", "amr", "atrac", "au", "awb", "dct", "dss", "dvf", "flac", "gsm", "iklax", "ivs", "m4a", "mmf", "mp3", "mpc", "msv", "mxp4", "ogg", "ra", "rm", "ram", "raw", "tta", "vox", "wav", "wma"};
    private static String lastDir = "";
    private static int lastIndex = -1;
    private static int lastMaxIndex = 0;
    static ArrayList<File> allFilesList;
    AboutBox aboutBox;

    public static boolean isMediaFile(String fname) {
        if (AppGUI.isMediaFile(fname, videoExt)) {
            return true;
        }
        return AppGUI.isMediaFile(fname, audioExt);
    }

    public static boolean isMediaFile(String fname, String[] formats) {
        for (int i = 0; i < formats.length; ++i) {
            if (!fname.toLowerCase().endsWith("." + formats[i])) continue;
            return true;
        }
        return false;
    }

    public String getMediaPlayer() {
        String ret = this.mediaPlayerTextField.getText();
        if (ret == null || ret.length() == 0) {
            ret = MediaShuffle.getStringOption("Media player", this.defaultMediaPlayer);
        }
        return ret;
    }

    public String getFolderLocation() {
        String ret = this.folderLocationTextField.getText();
        if (ret == null || ret.length() == 0) {
            ret = MediaShuffle.getStringOption("Source media folder", defaultSourceMediaFolder);
        }
        return ret;
    }

    public int getPlayMode() {
        return this.launchTypeCombo.getSelectedIndex();
    }

    public int getNumFiles() {
        return (Integer)this.launchSpinner.getValue();
    }

    public boolean getLoop() {
        return this.playInLoopCheckBox.isSelected();
    }

    private JPanel labelPanel(JComponent c, String lab) {
        JTransparentPanel ret = new JTransparentPanel(new BorderLayout());
        JLabel l = new JLabel(lab);
        l.setFont(this.labelFont);
        l.setBorder(BorderFactory.createEmptyBorder(10, 14, 4, 0));
        JTransparentPanel n = new JTransparentPanel(new BorderLayout());
        n.add((Component)l, "West");
        ret.add((Component)n, "North");
        ret.add((Component)c, "South");
        return ret;
    }

    private JPanel browseText(String lab, String initVal, JTextField textField, int fileSelectionMode) {
        JTransparentPanel ret = new JTransparentPanel(new BorderLayout());
        ret.setBorder(BorderFactory.createEmptyBorder(0, 13, 2, 12));
        JButton browseButton = new JButton(Lang.get((String)"Browse..."));
        textField.setEditable(false);
        textField.setText(initVal);
        ret.add((Component)textField, "Center");
        ret.add((Component)browseButton, "East");
        browseButton.setAction(new BrowseSelectionAction(Lang.get((String)"Browse..."), textField, fileSelectionMode));
        return this.labelPanel(ret, lab);
    }

    public void settingsDisplay(boolean show) {
        this.browseTexts.setVisible(show);
    }

    public AppGUI() {
        this.init();
    }

    private void initFoldersList() {
        this.foldersList = Box.createVerticalBox();
        this.checkBoxes = new ArrayList();
        File src = new File(this.getFolderLocation());
        File[] srcFolders = src.listFiles();
        if (srcFolders != null) {
            for (int i = 0; i < srcFolders.length; ++i) {
                if (!srcFolders[i].isDirectory()) continue;
                JCheckBox newCheck = new JCheckBox(srcFolders[i].getName());
                this.foldersList.add(newCheck);
                this.checkBoxes.add(newCheck);
                newCheck.setSelected(true);
            }
        }
        if (this.sp == null) {
            this.sp = new JScrollPane(this.foldersList);
        } else {
            this.sp.setViewportView(this.foldersList);
        }
    }

    private void init() {
        GlobaliskPanelUI.applyBackgroundGradient((Component)this);
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(400, 400));
        this.initFoldersList();
        JTransparentPanel topNav = new JTransparentPanel(new BorderLayout());
        JTransparentPanel buttonsTop = new JTransparentPanel();
        buttonsTop.setLayout(new FlowLayout(2));
        buttonsTop.setBorder(BorderFactory.createEmptyBorder(5, 7, 0, 7));
        JTransparentPanel buttons = new JTransparentPanel();
        buttons.setLayout(new FlowLayout(1));
        this.browseTexts = new JTransparentPanel(new BorderLayout());
        this.browseTexts.add((Component)this.browseText(Lang.get((String)"Media player executable"), this.getMediaPlayer(), this.mediaPlayerTextField, 0), "North");
        this.browseTexts.add((Component)this.browseText(Lang.get((String)"Root media files folder"), this.getFolderLocation(), this.folderLocationTextField, 1), "South");
        topNav.add((Component)this.browseTexts, "North");
        topNav.add((Component)buttonsTop, "South");
        this.selectAll = new JButton(new AbstractAction("Select all"){

            public void actionPerformed(ActionEvent e) {
                AppGUI.this.selectChecks(true);
            }
        });
        this.selectAll.setPreferredSize(new Dimension(100, 18));
        buttonsTop.add(this.selectAll);
        this.clearAll = new JButton(new AbstractAction("Clear all"){

            public void actionPerformed(ActionEvent e) {
                AppGUI.this.selectChecks(false);
            }
        });
        this.clearAll.setPreferredSize(new Dimension(100, 18));
        buttonsTop.add(this.clearAll);
        this.launchButton = new JButton(new AbstractAction("Play"){

            public void actionPerformed(ActionEvent e) {
                AppGUI.this.newSet();
            }
        });
        this.launchButton.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("resources/AppIcon16.png"))));
        this.launchSpinner = new JSpinner(new SpinnerNumberModel(4, 1, 9999, 1));
        this.launchSpinner.setPreferredSize(new Dimension(42, this.launchSpinner.getFont().getSize() + 13));
        this.launchSpinner.setValue(new Integer(MediaShuffle.getIntegerOption("Num files", 4)));
        this.launchTypeCombo = new JComboBox<String>(new String[]{"randomly", "at random, then sequentially", "sequentially"});
        this.launchTypeCombo.setSelectedIndex(MediaShuffle.getIntegerOption("Play mode", 0));
        this.playInLoopCheckBox = new JCheckBox(Lang.get((String)"in loop mode"));
        this.playInLoopCheckBox.setSelected(MediaShuffle.getBooleanOption("Loop", false));
        buttons.add(this.launchButton);
        buttons.add(this.launchSpinner);
        buttons.add(new JLabel(Lang.get((String)"files")));
        buttons.add(this.launchTypeCombo);
        if (this.getMediaPlayer().indexOf("vlc.exe") > -1) {
            buttons.add(this.playInLoopCheckBox);
        }
        this.foldersList.setOpaque(false);
        JGlobaliskBorderPanel wrap = new JGlobaliskBorderPanel((LayoutManager)new BorderLayout());
        wrap.setOpaque(false);
        wrap.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 14));
        wrap.add((Component)this.sp, "Center");
        this.add((Component)wrap, "Center");
        this.add((Component)topNav, "North");
        this.add((Component)buttons, "South");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Enabler e = new Enabler();
                e.start();
            }
        });
    }

    private void newSet() {
        this.vidsList = new StringBuffer();
        this.alreadyCopied = new HashMap();
        int copyCt = 0;
        int num = (Integer)this.launchSpinner.getValue();
        for (int i = 0; i < this.checkBoxes.size() && copyCt < num; ++i) {
            ++copyCt;
            String fromName = "";
            fromName = this.launchTypeCombo.getSelectedIndex() == 2 ? this.getNextSequential() : (this.launchTypeCombo.getSelectedIndex() == 1 ? this.getNextRandomSequential() : this.getRandom());
            File fromFile = new File(fromName);
            System.out.println("");
            try {
                this.vidsList.append(" \"").append(fromFile.getAbsolutePath()).append("\"");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        new VidThread().start();
    }

    private int numSelected() {
        int ct = 0;
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!this.checkBoxes.get(i).isSelected()) continue;
            ++ct;
        }
        return ct;
    }

    private String getFromDir(String srcDir) {
        File[] dirFiles = AppGUI.listAllFiles(this.getFolderLocation() + "/" + srcDir);
        int which = Math.max(0, Math.round((float)(Math.random() * (double)dirFiles.length)) - 1);
        if (this.launchTypeCombo.getSelectedIndex() == 2 && lastIndex == -1) {
            which = 0;
        }
        lastDir = srcDir;
        lastIndex = which;
        lastMaxIndex = dirFiles.length - 1;
        return dirFiles[which].getAbsolutePath();
    }

    private String getInitial() {
        int which = Math.max(0, Math.round((float)(Math.random() * (double)this.checkBoxes.size())) - 1);
        if (this.launchTypeCombo.getSelectedIndex() == 2) {
            which = 0;
            while (!this.checkBoxes.get(which).isSelected()) {
                ++which;
            }
        } else {
            while (!this.checkBoxes.get(which).isSelected()) {
                which = Math.max(0, Math.round((float)(Math.random() * (double)this.checkBoxes.size())) - 1);
            }
        }
        String srcDir = this.checkBoxes.get(which).getText();
        String ret = this.getFromDir(srcDir);
        return ret;
    }

    private String getRandom() {
        String ret = this.getInitial();
        if (this.alreadyCopied.get(ret) != null) {
            return this.getRandom();
        }
        this.alreadyCopied.put(ret, Boolean.TRUE);
        return ret;
    }

    private String getNextRandomSequential() {
        if (lastIndex == -1) {
            return this.getRandom();
        }
        return this.getNextSequential();
    }

    private String getNextSequential() {
        if (lastIndex == -1) {
            return this.getInitial();
        }
        if (++lastIndex > lastMaxIndex) {
            lastIndex = 0;
        }
        File[] dirFiles = AppGUI.listAllFiles(this.getFolderLocation() + "/" + lastDir);
        return dirFiles[lastIndex].getAbsolutePath();
    }

    private static File[] listAllFiles(String srcDir) {
        allFilesList = new ArrayList();
        AppGUI.listAll(srcDir);
        File[] ret = new File[allFilesList.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = allFilesList.get(i);
        }
        return ret;
    }

    private static void listAll(String srcDir) {
        File[] ret = new File(srcDir).listFiles();
        for (int i = 0; i < ret.length; ++i) {
            if (ret[i].isDirectory()) {
                AppGUI.listAll(ret[i].getAbsolutePath());
                continue;
            }
            if (!AppGUI.isMediaFile(ret[i].getName())) continue;
            allFilesList.add(ret[i]);
        }
    }

    private boolean hasSelected() {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!this.checkBoxes.get(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    private void selectChecks(boolean sel) {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            this.checkBoxes.get(i).setSelected(sel);
        }
    }

    public static void handleDonate() {
        BrowserLaunch.openURL((String)"http://globalisk.com/mediashuffle/donate");
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MediaShuffle.getApplication().getMainFrame();
            this.aboutBox = new AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MediaShuffle.getApplication().show(this.aboutBox);
    }

    class VidThread
    extends Thread {
        VidThread() {
        }

        public void run() {
            try {
                String post = "";
                if (AppGUI.this.playInLoopCheckBox.isVisible()) {
                    post = AppGUI.this.playInLoopCheckBox.isSelected() ? " --loop" : " --no-loop";
                }
                String cmd = "\"" + AppGUI.this.getMediaPlayer() + "\"" + AppGUI.this.vidsList + post;
                System.out.println("cmd: " + cmd);
                Runtime.getRuntime().exec(cmd);
                lastIndex = -1;
                lastDir = "";
            }
            catch (Exception e) {
                Dialogs.alert((String)e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }

    class Enabler
    extends Thread {
        Enabler() {
        }

        public void run() {
            while (true) {
                if (!AppGUI.this.hasSelected()) {
                    AppGUI.this.launchButton.setEnabled(false);
                } else {
                    AppGUI.this.launchButton.setEnabled(true);
                }
                if (AppGUI.this.numSelected() == 0) {
                    AppGUI.this.clearAll.setEnabled(false);
                } else {
                    AppGUI.this.clearAll.setEnabled(true);
                }
                if (AppGUI.this.numSelected() == AppGUI.this.checkBoxes.size()) {
                    AppGUI.this.selectAll.setEnabled(false);
                } else {
                    AppGUI.this.selectAll.setEnabled(true);
                }
                this.pause();
            }
        }

        private void pause() {
            try {
                Enabler.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    class BrowseSelectionAction
    extends AbstractAction {
        JTextField field;
        int fileSelectionMode;

        public BrowseSelectionAction(String bText, JTextField field, int fileSelectionMode) {
            super(bText);
            this.field = field;
            this.fileSelectionMode = fileSelectionMode;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(this.fileSelectionMode);
            String lab = "Select folder";
            if (this.fileSelectionMode == 2) {
                lab = "Select file/folder";
            } else if (this.fileSelectionMode == 0) {
                lab = "Select file";
            }
            int ret = fileChooser.showDialog(MediaShuffle.getApplication().getMainFrame(), Lang.get((String)lab));
            if (ret == 0) {
                File file = fileChooser.getSelectedFile();
                this.field.setText(file.getAbsolutePath());
            }
            AppGUI.this.initFoldersList();
            AppFrameView.updateTitle(this.field.getText());
        }
    }

    class JTransparentPanel
    extends JPanel {
        public JTransparentPanel() {
            this.setOpaque(false);
        }

        public JTransparentPanel(LayoutManager l) {
            super(l);
            this.setOpaque(false);
        }
    }
}

