/*
 * Decompiled with CFR 0.152.
 */
package com.globalisk.mediashuffle;

import com.globalisk.mediashuffle.AboutBox;
import com.globalisk.mediashuffle.AppGUI;
import com.globalisk.mediashuffle.MediaShuffle;
import com.globalisk.plaf.JGlobaliskMenuBar;
import com.globalisk.util.Lang;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.SingleFrameApplication;

public class AppFrameView
extends FrameView
implements ActionListener {
    static SingleFrameApplication app;
    JCheckBoxMenuItem toggleSettingsDisplay;
    static TrayIcon trayIcon;
    static SystemTray systemTray;
    static PopupMenu trayPopup;
    static MenuItem trayExit;
    static MenuItem trayRestore;
    static MenuItem trayAbout;
    ActionListener trayActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MediaShuffle.getApplication().getMainFrame().setVisible(true);
        }
    };
    MouseListener trayMouseListener = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                AppFrameView.setFrameVisible(!MediaShuffle.getApplication().getMainFrame().isVisible());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            AppFrameView.trayPopulate();
        }

        public void mouseReleased(MouseEvent e) {
        }
    };
    static boolean trayNotified;

    public AppFrameView(SingleFrameApplication app) {
        super(app);
        AppFrameView.app = app;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppFrameView.this.init();
            }
        });
    }

    public static void updateTitle(String folderLoc) {
        String f = folderLoc.replaceAll("\\\\", "/");
        int ind = f.lastIndexOf("/");
        if (ind > -1) {
            f = f.substring(ind + 1);
        }
        app.getMainFrame().setTitle(f + " - " + "Globalisk Media Shuffle");
    }

    private static void trayNotify() {
        if (!trayNotified) {
            trayIcon.displayMessage("Media Shuffle", Lang.get((String)"Click here to restore the window"), TrayIcon.MessageType.NONE);
        }
        trayNotified = true;
    }

    public static void setFrameVisible(boolean vis) {
        MediaShuffle.getApplication().getMainFrame().setVisible(vis);
        if (vis) {
            MediaShuffle.getApplication().getMainFrame().setExtendedState(0);
            MediaShuffle.getApplication().getMainFrame().toFront();
            MediaShuffle.getApplication().getMainFrame().requestFocus();
        } else {
            AppFrameView.trayNotify();
        }
        AppFrameView.trayPopulate();
    }

    private static void trayPopulate() {
        trayPopup.removeAll();
        JFrame frame = MediaShuffle.getApplication().getMainFrame();
        if (frame == null || !frame.isVisible() || frame.getExtendedState() != 0) {
            trayPopup.add(trayRestore);
        }
        trayPopup.add(trayAbout);
        trayPopup.addSeparator();
        trayPopup.add(trayExit);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == trayExit) {
            MediaShuffle.shutDown();
        } else if (e.getSource() == trayAbout) {
            MediaShuffle.gui.showAboutBox();
        } else if (e.getSource() == trayRestore) {
            AppFrameView.setFrameVisible(true);
        }
    }

    private void init() {
        Image appIcon = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("resources/AppIcon16.png"));
        trayPopup = new PopupMenu();
        trayExit = new MenuItem(Lang.get((String)"Exit"));
        trayExit.addActionListener(this);
        trayAbout = new MenuItem(Lang.get((String)"About"));
        trayAbout.addActionListener(this);
        AppFrameView.trayPopulate();
        trayIcon = new TrayIcon(appIcon, "Media Shuffle", trayPopup);
        trayIcon.setImageAutoSize(false);
        trayIcon.addActionListener(this.trayActionListener);
        trayIcon.addMouseListener(this.trayMouseListener);
        trayRestore.addActionListener(this);
        trayRestore.setFont(new Font("Arial", 1, 12));
        try {
            systemTray.add(trayIcon);
        }
        catch (AWTException e) {
            System.err.println("TrayIcon could not be added:" + e.getMessage());
        }
        app.getMainFrame().setIconImage(appIcon);
        String name = MediaShuffle.gui.getFolderLocation();
        int ind = name.lastIndexOf("/");
        if (ind > -1) {
            name = name.substring(ind + 1);
        }
        AppFrameView.updateTitle(name);
        JGlobaliskMenuBar menuBar = new JGlobaliskMenuBar();
        JMenu fileMenu = new JMenu(Lang.get((String)"File"));
        JMenuItem exitMenuItem = new JMenuItem();
        exitMenuItem.setAction(new AbstractAction(Lang.get((String)"Exit")){

            public void actionPerformed(ActionEvent e) {
                MediaShuffle.saveOpts();
                System.exit(0);
            }
        });
        JMenuItem donateMenuItem = new JMenuItem();
        donateMenuItem.setAction(new AbstractAction(Lang.get((String)"Donate...")){

            public void actionPerformed(ActionEvent e) {
                AppGUI.handleDonate();
            }
        });
        fileMenu.add(donateMenuItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitMenuItem);
        JMenu helpMenu = new JMenu(Lang.get((String)"Help"));
        JMenuItem aboutMenuItem = new JMenuItem();
        aboutMenuItem.setAction(new AbstractAction(Lang.get((String)"About")){

            public void actionPerformed(ActionEvent e) {
                AboutBox aboutSplash = new AboutBox(app.getMainFrame());
                aboutSplash.setLocationRelativeTo(app.getMainFrame());
                aboutSplash.setVisible(true);
            }
        });
        this.toggleSettingsDisplay = new JCheckBoxMenuItem();
        this.toggleSettingsDisplay.setAction(new AbstractAction(Lang.get((String)"App settings")){

            public void actionPerformed(ActionEvent e) {
                MediaShuffle.gui.settingsDisplay(AppFrameView.this.toggleSettingsDisplay.isSelected());
                MediaShuffle.opts.booleans.put("View app settings", AppFrameView.this.toggleSettingsDisplay.isSelected());
            }
        });
        this.toggleSettingsDisplay.setSelected(MediaShuffle.getBooleanOption("View app settings", true));
        MediaShuffle.gui.settingsDisplay(this.toggleSettingsDisplay.isSelected());
        helpMenu.add(aboutMenuItem);
        JMenu viewMenu = new JMenu(Lang.get((String)"View"));
        viewMenu.add(this.toggleSettingsDisplay);
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(helpMenu);
        menuBar.setBorder(null);
        this.setComponent(MediaShuffle.gui);
        this.setMenuBar((JMenuBar)menuBar);
    }

    static {
        systemTray = SystemTray.getSystemTray();
        trayRestore = new MenuItem(Lang.get((String)"Restore"));
        trayNotified = false;
    }
}

