/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.io.Serializable;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumValidator<Z extends Comparable<Z> & Serializable>
implements IValidator<Z> {
    private static final long serialVersionUID = 1L;
    private final Z minimum;

    public MinimumValidator(Z minimum) {
        this.minimum = minimum;
    }

    @Override
    public void validate(IValidatable<Z> validatable) {
        Comparable value = (Comparable)validatable.getValue();
        if (value.compareTo(this.minimum) < 0) {
            ValidationError error = new ValidationError();
            error.addMessageKey("MinimumValidator");
            error.setVariable("minimum", this.minimum);
            validatable.error(error);
        }
    }

    public Z getMinimum() {
        return this.minimum;
    }
}

