/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.resource;

import java.io.IOException;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.protocol.http.request.WebErrorCodeResponseTarget;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.IResourceStreamWriter;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStreamRequestTarget
implements IRequestTarget {
    private static final Logger log = LoggerFactory.getLogger(ResourceStreamRequestTarget.class);
    private String fileName;
    private final IResourceStream resourceStream;

    public ResourceStreamRequestTarget(IResourceStream resourceStream) {
        this.resourceStream = resourceStream;
    }

    public ResourceStreamRequestTarget(IResourceStream resourceStream, String fileName) {
        this.resourceStream = resourceStream;
        this.fileName = fileName;
    }

    public void detach(RequestCycle requestCycle) {
        try {
            this.resourceStream.close();
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Could not close resource stream", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceStreamRequestTarget) {
            ResourceStreamRequestTarget that = (ResourceStreamRequestTarget)obj;
            return this.resourceStream.equals(that.resourceStream) && (this.fileName == null || this.fileName.equals(that.fileName));
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public final IResourceStream getResourceStream() {
        return this.resourceStream;
    }

    public int hashCode() {
        int result = "ResourceStreamRequestTarget".hashCode();
        result += this.resourceStream.hashCode();
        return 17 * (result += this.fileName != null ? this.fileName.hashCode() : 0);
    }

    public void respond(RequestCycle requestCycle) {
        Response response = requestCycle.getResponse();
        this.configure(requestCycle, response, this.resourceStream);
        try {
            if (this.resourceStream instanceof IResourceStreamWriter) {
                ((IResourceStreamWriter)this.resourceStream).write(response.getOutputStream());
            } else {
                response.write(this.resourceStream.getInputStream());
            }
        }
        catch (ResourceStreamNotFoundException e) {
            requestCycle.setRequestTarget(new WebErrorCodeResponseTarget(404));
        }
    }

    public ResourceStreamRequestTarget setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String toString() {
        return "[ResourceStreamRequestTarget[resourceStream=" + this.resourceStream + ",fileName=" + this.fileName + "]";
    }

    protected void configure(RequestCycle requestCycle, Response response, IResourceStream resourceStream) {
        String file;
        String responseType = resourceStream.getContentType();
        if (responseType != null) {
            if (responseType.toLowerCase().indexOf("text") != -1) {
                response.setContentType(responseType + "; charset=" + response.getCharacterEncoding());
            } else {
                response.setContentType(responseType);
            }
        } else if (this.getFileName() != null) {
            response.detectContentType(requestCycle, this.getFileName());
        } else {
            String path = requestCycle.getRequest().getURL();
            int qs = path.indexOf(63);
            if (qs >= 0) {
                path = path.substring(0, qs);
            }
            response.detectContentType(requestCycle, path);
        }
        long len = resourceStream.length();
        if (len >= 0L) {
            response.setContentLength(len);
        }
        if ((file = this.getFileName()) != null && response instanceof WebResponse) {
            ((WebResponse)response).setAttachmentHeader(file);
        }
    }
}

