/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import org.apache.wicket.AbstractRestartResponseException;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.request.target.basic.EmptyRequestTarget;

public class AbortWithHttpStatusException
extends AbstractRestartResponseException {
    private static final long serialVersionUID = 1L;
    private final int status;

    public AbortWithHttpStatusException(int status, boolean statusCodeOptional) {
        this.status = status;
        RequestCycle rc = RequestCycle.get();
        if (rc == null) {
            if (!statusCodeOptional) {
                throw new IllegalStateException("This exception can only be thrown from within request processing cycle");
            }
        } else {
            Response r = rc.getResponse();
            if (!(r instanceof WebResponse)) {
                throw new IllegalStateException("This exception can only be thrown when wicket is processing an http request");
            }
            WebResponse wr = (WebResponse)r;
            wr.getHttpServletResponse().setStatus(status);
            rc.setRequestTarget(EmptyRequestTarget.getInstance());
        }
    }

    public final int getStatus() {
        return this.status;
    }
}

